/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.IdentifierMapAdapter;
import org.apache.sis.internal.jaxb.ModifiableIdentifierMap;
import org.apache.sis.internal.jaxb.gco.GO_Integer64;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.identification.RepresentativeFraction;

@XmlType(name="MD_RepresentativeFraction_Type")
@XmlRootElement(name="MD_RepresentativeFraction")
public class DefaultRepresentativeFraction
extends Number
implements RepresentativeFraction,
IdentifiedObject,
Emptiable,
Cloneable {
    private static final long serialVersionUID = -6043871487256529207L;
    private long denominator;
    private Collection<Identifier> identifiers;
    private transient boolean isUnmodifiable;

    public DefaultRepresentativeFraction() {
    }

    public DefaultRepresentativeFraction(long denominator) {
        ArgumentChecks.ensurePositive("denominator", denominator);
        this.denominator = denominator;
    }

    public DefaultRepresentativeFraction(RepresentativeFraction object) {
        if (object != null) {
            this.denominator = object.getDenominator();
        }
    }

    public static DefaultRepresentativeFraction castOrCopy(RepresentativeFraction object) {
        return object == null || object instanceof DefaultRepresentativeFraction ? (DefaultRepresentativeFraction)object : new DefaultRepresentativeFraction(object);
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlJavaTypeAdapter(value=GO_Integer64.class, type=long.class)
    @XmlElement(name="denominator", required=true)
    public long getDenominator() {
        return this.denominator;
    }

    public void setDenominator(long denominator) {
        if (this.isUnmodifiable) {
            throw new UnmodifiableMetadataException(Errors.format((short)122));
        }
        if (MetadataUtilities.ensurePositive(DefaultRepresentativeFraction.class, "denominator", false, denominator)) {
            this.denominator = denominator;
        }
    }

    public void setScale(double scale) {
        if (this.isUnmodifiable) {
            throw new UnmodifiableMetadataException(Errors.format((short)122));
        }
        if (scale <= 0.0 || scale > 1.0) {
            throw new IllegalArgumentException(scale <= 0.0 ? Errors.format((short)132, "scale", scale) : Errors.format((short)133, "scale", 0, 1, scale));
        }
        this.setDenominator(Math.round(1.0 / scale));
    }

    @Override
    public double doubleValue() {
        return this.denominator != 0L ? 1.0 / (double)this.denominator : Double.NaN;
    }

    @Override
    public float floatValue() {
        return this.denominator != 0L ? 1.0f / (float)this.denominator : Float.NaN;
    }

    @Override
    public long longValue() {
        return this.denominator == 1L ? 1L : 0L;
    }

    @Override
    public int intValue() {
        return this.denominator == 1L ? 1 : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.denominator == 0L;
    }

    public void freeze() {
        this.isUnmodifiable = true;
    }

    public DefaultRepresentativeFraction clone() {
        DefaultRepresentativeFraction c;
        try {
            c = (DefaultRepresentativeFraction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        c.isUnmodifiable = false;
        return c;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof RepresentativeFraction) {
            return ((RepresentativeFraction)object).getDenominator() == this.denominator;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this.denominator;
    }

    public String toString() {
        return this.denominator != 0L ? "1:" + this.denominator : "NaN";
    }

    public Collection<Identifier> getIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = new CheckedArrayList<Identifier>(Identifier.class);
        }
        return this.identifiers;
    }

    @Override
    public IdentifierMap getIdentifierMap() {
        Collection<Identifier> identifiers = this.getIdentifiers();
        return this.isUnmodifiable ? new IdentifierMapAdapter(identifiers) : new ModifiableIdentifierMap(identifiers);
    }

    @XmlID
    @XmlAttribute
    @XmlSchemaType(name="ID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : MetadataUtilities.getObjectID(this);
    }

    private void setID(String id) {
        MetadataUtilities.setObjectID(this, id);
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getUUID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : (String)this.getIdentifierMap().get(IdentifierSpace.UUID);
    }

    private void setUUID(String id) {
        this.getIdentifierMap().put(IdentifierSpace.UUID, id);
    }
}

