/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.code.SV_CouplingType;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultCoupledResource;
import org.apache.sis.metadata.iso.identification.DefaultOperationChainMetadata;
import org.apache.sis.metadata.iso.identification.DefaultOperationMetadata;
import org.apache.sis.metadata.iso.identification.OperationName;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.ServiceIdentification;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;

@XmlType(name="MD_ServiceIdentification_Type", propOrder={"serviceType", "serviceTypeVersions", "coupledResources", "couplingType", "containsOperations", "operatesOn"})
@XmlRootElement(name="SV_ServiceIdentification", namespace="http://www.isotc211.org/2005/srv")
public class DefaultServiceIdentification
extends AbstractIdentification
implements ServiceIdentification {
    private static final long serialVersionUID = 7700836694236616300L;
    private GenericName serviceType;
    private Collection<String> serviceTypeVersions;
    private StandardOrderProcess accessProperties;
    private CodeList<?> couplingType;
    private Collection<DefaultCoupledResource> coupledResources;
    private Collection<Citation> operatedDatasets;
    private Collection<Citation> profiles;
    private Collection<Citation> serviceStandards;
    private Collection<DefaultOperationMetadata> containsOperations;
    private Collection<DataIdentification> operatesOn;
    private Collection<DefaultOperationChainMetadata> containsChain;

    public DefaultServiceIdentification() {
    }

    public DefaultServiceIdentification(GenericName serviceType, Citation citation, CharSequence abstracts) {
        super(citation, abstracts);
        this.serviceType = serviceType;
    }

    public DefaultServiceIdentification(ServiceIdentification object) {
        super(object);
        if (object instanceof DefaultServiceIdentification) {
            DefaultServiceIdentification c = (DefaultServiceIdentification)object;
            this.serviceType = c.getServiceType();
            this.serviceTypeVersions = this.copyCollection(c.getServiceTypeVersions(), String.class);
            this.accessProperties = c.getAccessProperties();
            this.couplingType = c.getCouplingType();
            this.coupledResources = this.copyCollection(c.getCoupledResources(), DefaultCoupledResource.class);
            this.operatedDatasets = this.copyCollection(c.getOperatedDatasets(), Citation.class);
            this.profiles = this.copyCollection(c.getProfiles(), Citation.class);
            this.serviceStandards = this.copyCollection(c.getServiceStandards(), Citation.class);
            this.containsOperations = this.copyCollection(c.getContainsOperations(), DefaultOperationMetadata.class);
            this.operatesOn = this.copyCollection(c.getOperatesOn(), DataIdentification.class);
            this.containsChain = this.copyCollection(c.getContainsChain(), DefaultOperationChainMetadata.class);
        }
    }

    public static DefaultServiceIdentification castOrCopy(ServiceIdentification object) {
        if (object == null || object instanceof DefaultServiceIdentification) {
            return (DefaultServiceIdentification)object;
        }
        return new DefaultServiceIdentification(object);
    }

    @XmlElement(name="serviceType", namespace="http://www.isotc211.org/2005/srv", required=true)
    @UML(identifier="serviceType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public GenericName getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(GenericName newValue) {
        this.checkWritePermission();
        this.serviceType = newValue;
    }

    @XmlElement(name="serviceTypeVersion", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="serviceTypeVersion", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<String> getServiceTypeVersions() {
        this.serviceTypeVersions = this.nonNullCollection(this.serviceTypeVersions, String.class);
        return this.serviceTypeVersions;
    }

    public void setServiceTypeVersions(Collection<? extends String> newValues) {
        this.serviceTypeVersions = this.writeCollection(newValues, this.serviceTypeVersions, String.class);
    }

    @UML(identifier="accessProperties", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public StandardOrderProcess getAccessProperties() {
        return this.accessProperties;
    }

    public void setAccessProperties(StandardOrderProcess newValue) {
        this.checkWritePermission();
        this.accessProperties = newValue;
    }

    @XmlJavaTypeAdapter(value=SV_CouplingType.class)
    @XmlElement(name="couplingType", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="couplingType", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public CodeList<?> getCouplingType() {
        return this.couplingType;
    }

    public void setCouplingType(CodeList<?> newValue) {
        this.checkWritePermission();
        this.couplingType = newValue;
    }

    @XmlElement(name="coupledResource", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="coupledResource", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultCoupledResource> getCoupledResources() {
        this.coupledResources = this.nonNullCollection(this.coupledResources, DefaultCoupledResource.class);
        return this.coupledResources;
    }

    public void setCoupledResources(Collection<? extends DefaultCoupledResource> newValues) {
        this.coupledResources = this.writeCollection(newValues, this.coupledResources, DefaultCoupledResource.class);
    }

    @UML(identifier="operatedDataset", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getOperatedDatasets() {
        this.operatedDatasets = this.nonNullCollection(this.operatedDatasets, Citation.class);
        return this.operatedDatasets;
    }

    public void setOperatedDatasets(Collection<? extends Citation> newValues) {
        this.operatedDatasets = this.writeCollection(newValues, this.operatedDatasets, Citation.class);
    }

    @UML(identifier="profile", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getProfiles() {
        this.profiles = this.nonNullCollection(this.profiles, Citation.class);
        return this.profiles;
    }

    public void setProfiles(Collection<? extends Citation> newValues) {
        this.profiles = this.writeCollection(newValues, this.profiles, Citation.class);
    }

    @UML(identifier="serviceStandard", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getServiceStandards() {
        this.serviceStandards = this.nonNullCollection(this.serviceStandards, Citation.class);
        return this.serviceStandards;
    }

    public void setServiceStandards(Collection<? extends Citation> newValues) {
        this.serviceStandards = this.writeCollection(newValues, this.serviceStandards, Citation.class);
    }

    @XmlElement(name="containsOperations", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="containsOperations", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultOperationMetadata> getContainsOperations() {
        this.containsOperations = this.nonNullCollection(this.containsOperations, DefaultOperationMetadata.class);
        return this.containsOperations;
    }

    public void setContainsOperations(Collection<? extends DefaultOperationMetadata> newValues) {
        this.containsOperations = this.writeCollection(newValues, this.containsOperations, DefaultOperationMetadata.class);
    }

    @XmlElement(name="operatesOn", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="operatesOn", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DataIdentification> getOperatesOn() {
        this.operatesOn = this.nonNullCollection(this.operatesOn, DataIdentification.class);
        return this.operatesOn;
    }

    public void setOperatesOn(Collection<? extends DataIdentification> newValues) {
        this.operatesOn = this.writeCollection(newValues, this.operatesOn, DataIdentification.class);
    }

    @UML(identifier="containsChain", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultOperationChainMetadata> getContainsChain() {
        this.containsChain = this.nonNullCollection(this.containsChain, DefaultOperationChainMetadata.class);
        return this.containsChain;
    }

    public void setContainsChain(Collection<? extends DefaultOperationChainMetadata> newValues) {
        this.containsChain = this.writeCollection(newValues, this.containsChain, DefaultOperationChainMetadata.class);
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.containsOperations != null && this.coupledResources != null) {
            OperationName.resolve(this.containsOperations, this.coupledResources);
        }
    }
}

