/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.identification.Usage;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Usage_Type", propOrder={"specificUsage", "usageDate", "userDeterminedLimitations", "userContactInfo"})
@XmlRootElement(name="MD_Usage")
public class DefaultUsage
extends ISOMetadata
implements Usage {
    private static final long serialVersionUID = 7464000583573398579L;
    private InternationalString specificUsage;
    private long usageDate = Long.MIN_VALUE;
    private InternationalString userDeterminedLimitations;
    private Collection<ResponsibleParty> userContactInfo;
    private Collection<InternationalString> responses;
    private Collection<Citation> additionalDocumentation;
    private Collection<Citation> identifiedIssues;

    public DefaultUsage() {
    }

    public DefaultUsage(CharSequence specificUsage, ResponsibleParty userContactInfo) {
        this.specificUsage = Types.toInternationalString(specificUsage);
        this.userContactInfo = this.singleton(userContactInfo, ResponsibleParty.class);
    }

    public DefaultUsage(Usage object) {
        super(object);
        if (object != null) {
            this.specificUsage = object.getSpecificUsage();
            this.usageDate = MetadataUtilities.toMilliseconds(object.getUsageDate());
            this.userDeterminedLimitations = object.getUserDeterminedLimitations();
            this.userContactInfo = this.copyCollection(object.getUserContactInfo(), ResponsibleParty.class);
            if (object instanceof DefaultUsage) {
                DefaultUsage c = (DefaultUsage)object;
                this.responses = this.copyCollection(c.getResponses(), InternationalString.class);
                this.additionalDocumentation = this.copyCollection(c.getAdditionalDocumentation(), Citation.class);
                this.identifiedIssues = this.copyCollection(c.getIdentifiedIssues(), Citation.class);
            }
        }
    }

    public static DefaultUsage castOrCopy(Usage object) {
        if (object == null || object instanceof DefaultUsage) {
            return (DefaultUsage)object;
        }
        return new DefaultUsage(object);
    }

    @Override
    @XmlElement(name="specificUsage", required=true)
    public InternationalString getSpecificUsage() {
        return this.specificUsage;
    }

    public void setSpecificUsage(InternationalString newValue) {
        this.checkWritePermission();
        this.specificUsage = newValue;
    }

    @Override
    @XmlElement(name="usageDateTime")
    public Date getUsageDate() {
        return MetadataUtilities.toDate(this.usageDate);
    }

    public void setUsageDate(Date newValue) {
        this.checkWritePermission();
        this.usageDate = MetadataUtilities.toMilliseconds(newValue);
    }

    @Override
    @XmlElement(name="userDeterminedLimitations")
    public InternationalString getUserDeterminedLimitations() {
        return this.userDeterminedLimitations;
    }

    public void setUserDeterminedLimitations(InternationalString newValue) {
        this.checkWritePermission();
        this.userDeterminedLimitations = newValue;
    }

    @XmlElement(name="userContactInfo", required=true)
    public Collection<ResponsibleParty> getUserContactInfo() {
        this.userContactInfo = this.nonNullCollection(this.userContactInfo, ResponsibleParty.class);
        return this.userContactInfo;
    }

    public void setUserContactInfo(Collection<? extends ResponsibleParty> newValues) {
        this.userContactInfo = this.writeCollection(newValues, this.userContactInfo, ResponsibleParty.class);
    }

    @UML(identifier="response", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends InternationalString> getResponses() {
        this.responses = this.nonNullCollection(this.responses, InternationalString.class);
        return this.responses;
    }

    public void setResponses(Collection<? extends InternationalString> newValues) {
        this.responses = this.writeCollection(newValues, this.responses, InternationalString.class);
    }

    @UML(identifier="additionalDocumentation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAdditionalDocumentation() {
        this.additionalDocumentation = this.nonNullCollection(this.additionalDocumentation, Citation.class);
        return this.additionalDocumentation;
    }

    public void setAdditionalDocumentation(Collection<? extends Citation> newValues) {
        this.additionalDocumentation = this.writeCollection(newValues, this.additionalDocumentation, Citation.class);
    }

    @UML(identifier="identifiedIssues", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Citation> getIdentifiedIssues() {
        this.identifiedIssues = this.nonNullCollection(this.identifiedIssues, Citation.class);
        return this.identifiedIssues;
    }

    public void setIdentifiedIssues(Collection<? extends Citation> newValues) {
        this.identifiedIssues = this.writeCollection(newValues, this.identifiedIssues, Citation.class);
    }
}

