/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.lineage.NominalResolution;

@XmlType(name="LE_NominalResolution_Type", propOrder={"scanningResolution", "groundResolution"})
@XmlRootElement(name="LE_NominalResolution", namespace="http://www.isotc211.org/2005/gmi")
public class DefaultNominalResolution
extends ISOMetadata
implements NominalResolution {
    private static final long serialVersionUID = -4000422414866855607L;
    private Double scanningResolution;
    private Double groundResolution;

    public DefaultNominalResolution() {
    }

    public DefaultNominalResolution(NominalResolution object) {
        super(object);
        if (object != null) {
            this.scanningResolution = object.getScanningResolution();
            this.groundResolution = object.getGroundResolution();
        }
    }

    public static DefaultNominalResolution castOrCopy(NominalResolution object) {
        if (object == null || object instanceof DefaultNominalResolution) {
            return (DefaultNominalResolution)object;
        }
        return new DefaultNominalResolution(object);
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="scanningResolution", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Double getScanningResolution() {
        return this.scanningResolution;
    }

    public void setScanningResolution(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultNominalResolution.class, "scanningResolution", true, newValue)) {
            this.scanningResolution = newValue;
        }
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="groundResolution", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Double getGroundResolution() {
        return this.groundResolution;
    }

    public void setGroundResolution(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultNominalResolution.class, "groundResolution", true, newValue)) {
            this.groundResolution = newValue;
        }
    }
}

