/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.lineage.Algorithm;
import org.opengis.metadata.lineage.Processing;
import org.opengis.util.InternationalString;

@XmlType(name="LE_Processing_Type", propOrder={"identifier", "softwareReferences", "procedureDescription", "documentations", "runTimeParameters", "algorithms"})
@XmlRootElement(name="LE_Processing", namespace="http://www.isotc211.org/2005/gmi")
public class DefaultProcessing
extends ISOMetadata
implements Processing {
    private static final long serialVersionUID = 5698533358975632857L;
    private Collection<Citation> softwareReferences;
    private InternationalString procedureDescription;
    private Collection<Citation> documentations;
    private InternationalString runTimeParameters;
    private Collection<Algorithm> algorithms;

    public DefaultProcessing() {
    }

    public DefaultProcessing(Processing object) {
        super(object);
        if (object != null) {
            this.identifiers = this.singleton(object.getIdentifier(), Identifier.class);
            this.softwareReferences = this.copyCollection(object.getSoftwareReferences(), Citation.class);
            this.procedureDescription = object.getProcedureDescription();
            this.documentations = this.copyCollection(object.getDocumentations(), Citation.class);
            this.runTimeParameters = object.getRunTimeParameters();
            this.algorithms = this.copyCollection(object.getAlgorithms(), Algorithm.class);
        }
    }

    public static DefaultProcessing castOrCopy(Processing object) {
        if (object == null || object instanceof DefaultProcessing) {
            return (DefaultProcessing)object;
        }
        return new DefaultProcessing(object);
    }

    @Override
    @XmlElement(name="identifier", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier newValue) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, newValue);
    }

    @XmlElement(name="softwareReference", namespace="http://www.isotc211.org/2005/gmi")
    public Collection<Citation> getSoftwareReferences() {
        this.softwareReferences = this.nonNullCollection(this.softwareReferences, Citation.class);
        return this.softwareReferences;
    }

    public void setSoftwareReferences(Collection<? extends Citation> newValues) {
        this.softwareReferences = this.writeCollection(newValues, this.softwareReferences, Citation.class);
    }

    @Override
    @XmlElement(name="procedureDescription", namespace="http://www.isotc211.org/2005/gmi")
    public InternationalString getProcedureDescription() {
        return this.procedureDescription;
    }

    public void setProcedureDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.procedureDescription = newValue;
    }

    @XmlElement(name="documentation", namespace="http://www.isotc211.org/2005/gmi")
    public Collection<Citation> getDocumentations() {
        this.documentations = this.nonNullCollection(this.documentations, Citation.class);
        return this.documentations;
    }

    public void setDocumentations(Collection<? extends Citation> newValues) {
        this.documentations = this.writeCollection(newValues, this.documentations, Citation.class);
    }

    @Override
    @XmlElement(name="runTimeParameters", namespace="http://www.isotc211.org/2005/gmi")
    public InternationalString getRunTimeParameters() {
        return this.runTimeParameters;
    }

    public void setRunTimeParameters(InternationalString newValue) {
        this.checkWritePermission();
        this.runTimeParameters = newValue;
    }

    @XmlElement(name="algorithm", namespace="http://www.isotc211.org/2005/gmi")
    public Collection<Algorithm> getAlgorithms() {
        this.algorithms = this.nonNullCollection(this.algorithms, Algorithm.class);
        return this.algorithms;
    }

    public void setAlgorithms(Collection<? extends Algorithm> newValues) {
        this.algorithms = this.writeCollection(newValues, this.algorithms, Algorithm.class);
    }
}

