/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.LE_Source;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultResolution;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.RepresentativeFraction;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.lineage.NominalResolution;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.metadata.quality.Scope;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@XmlType(name="LI_Source_Type", propOrder={"description", "scaleDenominator", "sourceCitation", "sourceExtents", "sourceSteps", "processedLevel", "resolution"})
@XmlRootElement(name="LI_Source")
@XmlSeeAlso(value={LE_Source.class})
public class DefaultSource
extends ISOMetadata
implements Source {
    private static final long serialVersionUID = -8444238043227180224L;
    private InternationalString description;
    private Resolution sourceSpatialResolution;
    private ReferenceSystem sourceReferenceSystem;
    private Citation sourceCitation;
    private Collection<Citation> sourceMetadata;
    private Scope scope;
    private Collection<ProcessStep> sourceSteps;
    private Identifier processedLevel;
    private NominalResolution resolution;

    public DefaultSource() {
    }

    public DefaultSource(CharSequence description) {
        this.description = Types.toInternationalString(description);
    }

    public DefaultSource(Source object) {
        super(object);
        if (object != null) {
            this.description = object.getDescription();
            this.sourceReferenceSystem = object.getSourceReferenceSystem();
            this.sourceCitation = object.getSourceCitation();
            this.sourceSteps = this.copyCollection(object.getSourceSteps(), ProcessStep.class);
            this.processedLevel = object.getProcessedLevel();
            this.resolution = object.getResolution();
            if (object instanceof DefaultSource) {
                this.sourceSpatialResolution = ((DefaultSource)object).getSourceSpatialResolution();
                this.sourceMetadata = this.copyCollection(((DefaultSource)object).getSourceMetadata(), Citation.class);
                this.scope = ((DefaultSource)object).getScope();
            } else {
                this.setScaleDenominator(object.getScaleDenominator());
                this.setSourceExtents(object.getSourceExtents());
            }
        }
    }

    public static DefaultSource castOrCopy(Source object) {
        if (object == null || object instanceof DefaultSource) {
            return (DefaultSource)object;
        }
        return new DefaultSource(object);
    }

    @Override
    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    @UML(identifier="sourceSpatialResolution", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Resolution getSourceSpatialResolution() {
        return this.sourceSpatialResolution;
    }

    public void setSourceSpatialResolution(Resolution newValue) {
        this.checkWritePermission();
        this.sourceSpatialResolution = newValue;
    }

    @Override
    @Deprecated
    @XmlElement(name="scaleDenominator")
    public RepresentativeFraction getScaleDenominator() {
        Resolution resolution = this.getSourceSpatialResolution();
        return resolution != null ? resolution.getEquivalentScale() : null;
    }

    @Deprecated
    public void setScaleDenominator(RepresentativeFraction newValue) {
        this.checkWritePermission();
        Resolution resolution = null;
        if (newValue != null) {
            resolution = this.sourceSpatialResolution;
            if (resolution instanceof DefaultResolution) {
                ((DefaultResolution)resolution).setEquivalentScale(newValue);
            } else {
                resolution = new DefaultResolution(newValue);
            }
        }
        if (resolution != this.sourceSpatialResolution) {
            this.setSourceSpatialResolution(resolution);
        }
    }

    @Override
    public ReferenceSystem getSourceReferenceSystem() {
        return this.sourceReferenceSystem;
    }

    public void setSourceReferenceSystem(ReferenceSystem newValue) {
        this.checkWritePermission();
        this.sourceReferenceSystem = newValue;
    }

    @Override
    @XmlElement(name="sourceCitation")
    public Citation getSourceCitation() {
        return this.sourceCitation;
    }

    public void setSourceCitation(Citation newValue) {
        this.checkWritePermission();
        this.sourceCitation = newValue;
    }

    @UML(identifier="sourceMetadata", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getSourceMetadata() {
        this.sourceMetadata = this.nonNullCollection(this.sourceMetadata, Citation.class);
        return this.sourceMetadata;
    }

    public void setSourceMetadata(Collection<? extends Citation> newValues) {
        this.sourceMetadata = this.writeCollection(newValues, this.sourceMetadata, Citation.class);
    }

    @UML(identifier="scope", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope newValue) {
        this.checkWritePermission();
        this.scope = newValue;
    }

    @Deprecated
    @XmlElement(name="sourceExtent")
    public Collection<Extent> getSourceExtents() {
        Scope scope = this.getScope();
        if (!(scope instanceof DefaultScope)) {
            if (this.isModifiable()) {
                this.scope = scope = new DefaultScope(scope);
            } else {
                return Collections.singleton(scope.getExtent());
            }
        }
        return ((DefaultScope)scope).getExtents();
    }

    @Deprecated
    public void setSourceExtents(Collection<? extends Extent> newValues) {
        this.checkWritePermission();
        Scope scope = this.scope;
        if (!(scope instanceof DefaultScope)) {
            scope = new DefaultScope(scope);
            this.setScope(scope);
        }
        ((DefaultScope)scope).setExtents(newValues);
    }

    @XmlElement(name="sourceStep")
    public Collection<ProcessStep> getSourceSteps() {
        this.sourceSteps = this.nonNullCollection(this.sourceSteps, ProcessStep.class);
        return this.sourceSteps;
    }

    public void setSourceSteps(Collection<? extends ProcessStep> newValues) {
        this.sourceSteps = this.writeCollection(newValues, this.sourceSteps, ProcessStep.class);
    }

    @Override
    @XmlElement(name="processedLevel", namespace="http://www.isotc211.org/2005/gmi")
    public Identifier getProcessedLevel() {
        return this.processedLevel;
    }

    public void setProcessedLevel(Identifier newValue) {
        this.checkWritePermission();
        this.processedLevel = newValue;
    }

    @Override
    @XmlElement(name="resolution", namespace="http://www.isotc211.org/2005/gmi")
    public NominalResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(NominalResolution newValue) {
        this.checkWritePermission();
        this.resolution = newValue;
    }
}

