/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.metadata.quality.Scope;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

@XmlType(name="MD_MaintenanceInformation_Type", propOrder={"maintenanceAndUpdateFrequency", "dateOfNextUpdate", "userDefinedMaintenanceFrequency", "updateScopes", "updateScopeDescriptions", "maintenanceNotes", "contacts"})
@XmlRootElement(name="MD_MaintenanceInformation")
public class DefaultMaintenanceInformation
extends ISOMetadata
implements MaintenanceInformation {
    private static final long serialVersionUID = -8736825706141936429L;
    private static final DateType NEXT_UPDATE = DateType.valueOf("NEXT_UPDATE");
    private MaintenanceFrequency maintenanceAndUpdateFrequency;
    private Collection<CitationDate> maintenanceDates;
    private PeriodDuration userDefinedMaintenanceFrequency;
    private Collection<Scope> maintenanceScopes;
    private Collection<InternationalString> maintenanceNotes;
    private Collection<ResponsibleParty> contacts;

    public DefaultMaintenanceInformation() {
    }

    public DefaultMaintenanceInformation(MaintenanceFrequency maintenanceAndUpdateFrequency) {
        this.maintenanceAndUpdateFrequency = maintenanceAndUpdateFrequency;
    }

    public DefaultMaintenanceInformation(MaintenanceInformation object) {
        super(object);
        if (object != null) {
            this.maintenanceAndUpdateFrequency = object.getMaintenanceAndUpdateFrequency();
            this.userDefinedMaintenanceFrequency = object.getUserDefinedMaintenanceFrequency();
            this.maintenanceNotes = this.copyCollection(object.getMaintenanceNotes(), InternationalString.class);
            if (object instanceof DefaultMaintenanceInformation) {
                DefaultMaintenanceInformation c = (DefaultMaintenanceInformation)object;
                this.maintenanceDates = this.copyCollection(c.getMaintenanceDates(), CitationDate.class);
                this.maintenanceScopes = this.copyCollection(c.getMaintenanceScopes(), Scope.class);
                this.contacts = this.copyCollection(c.getContacts(), ResponsibleParty.class);
            } else {
                this.setDateOfNextUpdate(object.getDateOfNextUpdate());
                this.setUpdateScopes(object.getUpdateScopes());
                this.setUpdateScopeDescriptions(object.getUpdateScopeDescriptions());
            }
        }
    }

    public static DefaultMaintenanceInformation castOrCopy(MaintenanceInformation object) {
        if (object == null || object instanceof DefaultMaintenanceInformation) {
            return (DefaultMaintenanceInformation)object;
        }
        return new DefaultMaintenanceInformation(object);
    }

    @Override
    @XmlElement(name="maintenanceAndUpdateFrequency", required=true)
    public MaintenanceFrequency getMaintenanceAndUpdateFrequency() {
        return this.maintenanceAndUpdateFrequency;
    }

    public void setMaintenanceAndUpdateFrequency(MaintenanceFrequency newValue) {
        this.checkWritePermission();
        this.maintenanceAndUpdateFrequency = newValue;
    }

    @UML(identifier="maintenanceDate", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<CitationDate> getMaintenanceDates() {
        this.maintenanceDates = this.nonNullCollection(this.maintenanceDates, CitationDate.class);
        return this.maintenanceDates;
    }

    public void setMaintenanceDates(Collection<? extends CitationDate> newValues) {
        this.maintenanceDates = this.writeCollection(newValues, this.maintenanceDates, CitationDate.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="dateOfNextUpdate")
    public Date getDateOfNextUpdate() {
        Collection<CitationDate> dates = this.getMaintenanceDates();
        if (dates != null) {
            for (CitationDate date : dates) {
                if (!NEXT_UPDATE.equals(date.getDateType())) continue;
                return date.getDate();
            }
        }
        return null;
    }

    @Deprecated
    public void setDateOfNextUpdate(Date newValue) {
        this.checkWritePermission();
        Collection<CitationDate> dates = this.maintenanceDates;
        if (dates != null) {
            Iterator<CitationDate> it = dates.iterator();
            while (it.hasNext()) {
                CitationDate date = it.next();
                if (!NEXT_UPDATE.equals(date.getDateType())) continue;
                if (newValue == null) {
                    it.remove();
                    return;
                }
                if (!(date instanceof DefaultCitationDate)) continue;
                ((DefaultCitationDate)date).setDate(newValue);
                return;
            }
        }
        if (newValue != null) {
            DefaultCitationDate date = new DefaultCitationDate(newValue, NEXT_UPDATE);
            if (dates != null) {
                dates.add(date);
            } else {
                dates = Collections.singleton(date);
            }
            this.setMaintenanceDates(dates);
        }
    }

    @Override
    @XmlElement(name="userDefinedMaintenanceFrequency")
    public PeriodDuration getUserDefinedMaintenanceFrequency() {
        return this.userDefinedMaintenanceFrequency;
    }

    public void setUserDefinedMaintenanceFrequency(PeriodDuration newValue) {
        this.checkWritePermission();
        this.userDefinedMaintenanceFrequency = newValue;
    }

    @UML(identifier="maintenanceScope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Scope> getMaintenanceScopes() {
        this.maintenanceScopes = this.nonNullCollection(this.maintenanceScopes, Scope.class);
        return this.maintenanceScopes;
    }

    public void setMaintenanceScopes(Collection<? extends Scope> newValues) {
        this.maintenanceScopes = this.writeCollection(newValues, this.maintenanceScopes, Scope.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="updateScope")
    public final Collection<ScopeCode> getUpdateScopes() {
        return new LegacyPropertyAdapter<ScopeCode, Scope>(this.getMaintenanceScopes()){

            @Override
            protected Scope wrap(ScopeCode value) {
                return new DefaultScope(value);
            }

            @Override
            protected ScopeCode unwrap(Scope container) {
                return container.getLevel();
            }

            @Override
            protected boolean update(Scope container, ScopeCode value) {
                if (container instanceof DefaultScope) {
                    ((DefaultScope)container).setLevel(value);
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setUpdateScopes(Collection<? extends ScopeCode> newValues) {
        this.checkWritePermission();
        ((LegacyPropertyAdapter)this.getUpdateScopes()).setValues(newValues);
    }

    @Deprecated
    @XmlElement(name="updateScopeDescription")
    public final Collection<ScopeDescription> getUpdateScopeDescriptions() {
        return new LegacyPropertyAdapter<ScopeDescription, Scope>(this.getMaintenanceScopes()){

            @Override
            protected Scope wrap(ScopeDescription value) {
                DefaultScope container = new DefaultScope();
                container.setLevelDescription(2.asCollection(value));
                return container;
            }

            @Override
            protected ScopeDescription unwrap(Scope container) {
                return 2.getSingleton(container.getLevelDescription(), ScopeDescription.class, this, DefaultMaintenanceInformation.class, "getUpdateScopeDescriptions");
            }

            @Override
            protected boolean update(Scope container, ScopeDescription value) {
                if (container instanceof DefaultScope) {
                    ((DefaultScope)container).setLevelDescription(2.asCollection(value));
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setUpdateScopeDescriptions(Collection<? extends ScopeDescription> newValues) {
        this.checkWritePermission();
        ((LegacyPropertyAdapter)this.getUpdateScopeDescriptions()).setValues(newValues);
    }

    @XmlElement(name="maintenanceNote")
    public Collection<InternationalString> getMaintenanceNotes() {
        this.maintenanceNotes = this.nonNullCollection(this.maintenanceNotes, InternationalString.class);
        return this.maintenanceNotes;
    }

    public void setMaintenanceNotes(Collection<? extends InternationalString> newValues) {
        this.maintenanceNotes = this.writeCollection(newValues, this.maintenanceNotes, InternationalString.class);
    }

    @XmlElement(name="contact")
    public Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public void setContacts(Collection<? extends ResponsibleParty> newValues) {
        this.contacts = this.writeCollection(newValues, this.contacts, ResponsibleParty.class);
    }
}

