/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.metadata.quality.Scope;

@XmlType(name="DQ_Scope_Type", propOrder={"level", "extents", "levelDescription"})
@XmlRootElement(name="DQ_Scope")
public class DefaultScope
extends ISOMetadata
implements Scope {
    private static final long serialVersionUID = -979575548481874359L;
    private ScopeCode level;
    private Collection<Extent> extents;
    private Collection<ScopeDescription> levelDescription;

    public DefaultScope() {
    }

    public DefaultScope(ScopeCode level) {
        this.level = level;
    }

    public DefaultScope(Scope object) {
        super(object);
        if (object != null) {
            this.level = object.getLevel();
            this.levelDescription = this.copyCollection(object.getLevelDescription(), ScopeDescription.class);
            this.extents = object instanceof DefaultScope ? this.copyCollection(((DefaultScope)object).getExtents(), Extent.class) : this.singleton(object.getExtent(), Extent.class);
        }
    }

    public static DefaultScope castOrCopy(Scope object) {
        if (object == null || object instanceof DefaultScope) {
            return (DefaultScope)object;
        }
        return new DefaultScope(object);
    }

    @Override
    @XmlElement(name="level", required=true)
    public ScopeCode getLevel() {
        return this.level;
    }

    public void setLevel(ScopeCode newValue) {
        this.checkWritePermission();
        this.level = newValue;
    }

    @XmlElement(name="extent")
    @UML(identifier="extent", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> newValues) {
        this.extents = this.writeCollection(newValues, this.extents, Extent.class);
    }

    @Override
    @Deprecated
    public Extent getExtent() {
        return LegacyPropertyAdapter.getSingleton(this.getExtents(), Extent.class, null, DefaultScope.class, "getExtent");
    }

    @Deprecated
    public void setExtent(Extent newValue) {
        this.setExtents(LegacyPropertyAdapter.asCollection(newValue));
    }

    @XmlElement(name="levelDescription")
    public Collection<ScopeDescription> getLevelDescription() {
        this.levelDescription = this.nonNullCollection(this.levelDescription, ScopeDescription.class);
        return this.levelDescription;
    }

    public void setLevelDescription(Collection<? extends ScopeDescription> newValues) {
        this.levelDescription = this.writeCollection(newValues, this.levelDescription, ScopeDescription.class);
    }
}

