/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import java.util.Collection;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.ExcludedSet;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Messages;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.metadata.maintenance.ScopeDescription;

@XmlType(name="MD_ScopeDescription_Type")
@XmlRootElement(name="MD_ScopeDescription")
public class DefaultScopeDescription
extends ISOMetadata
implements ScopeDescription {
    private static final long serialVersionUID = -2029119689389845656L;
    private static final byte DATASET = 1;
    private static final byte FEATURES = 2;
    private static final byte ATTRIBUTES = 3;
    private static final byte FEATURE_INSTANCES = 4;
    private static final byte ATTRIBUTE_INSTANCES = 5;
    private static final byte OTHER = 6;
    private static final String[] NAMES = new String[]{"dataset", "features", "attributes", "featureInstances", "attributeInstances", "other"};
    private static final String[] SETTERS = new String[]{"setDataset", "setFeatures", "setAttributes", "setFeatureInstances", "setAttributeInstances", "setOther"};
    private byte property;
    private Object value;

    public DefaultScopeDescription() {
    }

    public DefaultScopeDescription(ScopeDescription object) {
        super(object);
        if (object != null) {
            for (int i = 1; i <= 6; i = (int)((byte)(i + 1))) {
                Set<Object> candidate;
                switch (i) {
                    case 1: {
                        candidate = object.getDataset();
                        break;
                    }
                    case 2: {
                        candidate = object.getFeatures();
                        break;
                    }
                    case 3: {
                        candidate = object.getAttributes();
                        break;
                    }
                    case 4: {
                        candidate = object.getFeatureInstances();
                        break;
                    }
                    case 5: {
                        candidate = object.getAttributeInstances();
                        break;
                    }
                    case 6: {
                        candidate = object.getOther();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                if (candidate == null) continue;
                switch (i) {
                    case 3: 
                    case 5: {
                        candidate = this.copySet((Collection)candidate, AttributeType.class);
                        break;
                    }
                    case 2: 
                    case 4: {
                        candidate = this.copySet((Collection)candidate, FeatureType.class);
                    }
                }
                this.value = candidate;
                this.property = (byte)i;
                break;
            }
        }
    }

    public static DefaultScopeDescription castOrCopy(ScopeDescription object) {
        if (object == null || object instanceof DefaultScopeDescription) {
            return (DefaultScopeDescription)object;
        }
        return new DefaultScopeDescription(object);
    }

    private static <E> Set<E> cast(Object value, Class<E> type) {
        assert (((CheckedContainer)value).getElementType() == type);
        return (Set)value;
    }

    private <E> Set<E> getProperty(Class<E> type, byte code) {
        Object value = this.value;
        if (value != null) {
            if (this.property == code) {
                return DefaultScopeDescription.cast(value, type);
            }
            if (!(value instanceof Set) || !((Set)value).isEmpty()) {
                return Semaphores.query((byte)4) ? null : new ExcludedSet(NAMES[code - 1], NAMES[this.property - 1]);
            }
        }
        Set<E> c = this.nonNullSet(null, type);
        this.property = code;
        this.value = c;
        return c;
    }

    private <E> void setProperty(Set<? extends E> newValue, Class<E> type, byte code) {
        Set<E> c = null;
        if (this.property == code) {
            c = DefaultScopeDescription.cast(this.value, type);
        } else {
            if (Containers.isNullOrEmpty(newValue)) {
                return;
            }
            this.warningOnOverwrite(code);
            this.property = code;
        }
        this.value = this.writeSet(newValue, c, type);
    }

    private void warningOnOverwrite(byte code) {
        if (this.value != null && this.property != code) {
            Context.warningOccured(Context.current(), DefaultScopeDescription.class, SETTERS[code - 1], Messages.class, (short)2, NAMES[this.property - 1], NAMES[code - 1]);
        }
    }

    @Override
    @XmlElement(name="dataset")
    public String getDataset() {
        return this.property == 1 ? (String)this.value : null;
    }

    public void setDataset(String newValue) {
        this.checkWritePermission();
        if (newValue != null || this.property == 1) {
            this.warningOnOverwrite((byte)1);
            this.property = 1;
            this.value = newValue;
        }
    }

    public Set<FeatureType> getFeatures() {
        return this.getProperty(FeatureType.class, (byte)2);
    }

    public void setFeatures(Set<? extends FeatureType> newValues) {
        this.setProperty(newValues, FeatureType.class, (byte)2);
    }

    public Set<AttributeType> getAttributes() {
        return this.getProperty(AttributeType.class, (byte)3);
    }

    public void setAttributes(Set<? extends AttributeType> newValues) {
        this.setProperty(newValues, AttributeType.class, (byte)3);
    }

    public Set<FeatureType> getFeatureInstances() {
        return this.getProperty(FeatureType.class, (byte)4);
    }

    public void setFeatureInstances(Set<? extends FeatureType> newValues) {
        this.setProperty(newValues, FeatureType.class, (byte)4);
    }

    public Set<AttributeType> getAttributeInstances() {
        return this.getProperty(AttributeType.class, (byte)5);
    }

    public void setAttributeInstances(Set<? extends AttributeType> newValues) {
        this.setProperty(newValues, AttributeType.class, (byte)5);
    }

    @Override
    @XmlElement(name="other")
    public String getOther() {
        return this.property == 6 ? (String)this.value : null;
    }

    public void setOther(String newValue) {
        this.checkWritePermission();
        if (newValue != null || this.property == 6) {
            this.warningOnOverwrite((byte)6);
            this.property = (byte)6;
            this.value = newValue;
        }
    }
}

