/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.quality.AbstractCompleteness;
import org.apache.sis.metadata.iso.quality.AbstractLogicalConsistency;
import org.apache.sis.metadata.iso.quality.AbstractPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.AbstractTemporalAccuracy;
import org.apache.sis.metadata.iso.quality.AbstractThematicAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultUsability;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Completeness;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.LogicalConsistency;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.quality.TemporalAccuracy;
import org.opengis.metadata.quality.ThematicAccuracy;
import org.opengis.metadata.quality.Usability;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDQ_Element_Type", propOrder={"namesOfMeasure", "measureIdentification", "measureDescription", "evaluationMethodType", "evaluationMethodDescription", "evaluationProcedure", "dates", "results"})
@XmlRootElement(name="DQ_Element")
@XmlSeeAlso(value={AbstractCompleteness.class, AbstractLogicalConsistency.class, AbstractPositionalAccuracy.class, AbstractThematicAccuracy.class, AbstractTemporalAccuracy.class, DefaultUsability.class})
public class AbstractElement
extends ISOMetadata
implements Element {
    private static final long serialVersionUID = 3963454452767190970L;
    private Collection<InternationalString> namesOfMeasure;
    private Identifier measureIdentification;
    private InternationalString measureDescription;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private Dates dates;
    private Collection<Result> results;

    public AbstractElement() {
    }

    public AbstractElement(Result result) {
        this.results = this.singleton(result, Result.class);
    }

    public AbstractElement(Element object) {
        super(object);
        if (object != null) {
            this.namesOfMeasure = this.copyCollection(object.getNamesOfMeasure(), InternationalString.class);
            this.measureIdentification = object.getMeasureIdentification();
            this.measureDescription = object.getMeasureDescription();
            this.evaluationMethodType = object.getEvaluationMethodType();
            this.evaluationMethodDescription = object.getEvaluationMethodDescription();
            this.evaluationProcedure = object.getEvaluationProcedure();
            this.results = this.copyCollection(object.getResults(), Result.class);
            this.writeDates(object.getDates());
        }
    }

    public static AbstractElement castOrCopy(Element object) {
        if (object instanceof PositionalAccuracy) {
            return AbstractPositionalAccuracy.castOrCopy((PositionalAccuracy)object);
        }
        if (object instanceof TemporalAccuracy) {
            return AbstractTemporalAccuracy.castOrCopy((TemporalAccuracy)object);
        }
        if (object instanceof ThematicAccuracy) {
            return AbstractThematicAccuracy.castOrCopy((ThematicAccuracy)object);
        }
        if (object instanceof LogicalConsistency) {
            return AbstractLogicalConsistency.castOrCopy((LogicalConsistency)object);
        }
        if (object instanceof Completeness) {
            return AbstractCompleteness.castOrCopy((Completeness)object);
        }
        if (object instanceof Usability) {
            return DefaultUsability.castOrCopy((Usability)object);
        }
        if (object == null || object instanceof AbstractElement) {
            return (AbstractElement)object;
        }
        return new AbstractElement(object);
    }

    @XmlElement(name="nameOfMeasure")
    public Collection<InternationalString> getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public void setNamesOfMeasure(Collection<? extends InternationalString> newValues) {
        this.namesOfMeasure = this.writeCollection(newValues, this.namesOfMeasure, InternationalString.class);
    }

    @Override
    @XmlElement(name="measureIdentification")
    public Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public void setMeasureIdentification(Identifier newValue) {
        this.checkWritePermission();
        this.measureIdentification = newValue;
    }

    @Override
    @XmlElement(name="measureDescription")
    public InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public void setMeasureDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.measureDescription = newValue;
    }

    @Override
    @XmlElement(name="evaluationMethodType")
    public EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public void setEvaluationMethodType(EvaluationMethodType newValue) {
        this.checkWritePermission();
        this.evaluationMethodType = newValue;
    }

    @Override
    @XmlElement(name="evaluationMethodDescription")
    public InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public void setEvaluationMethodDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.evaluationMethodDescription = newValue;
    }

    @Override
    @XmlElement(name="evaluationProcedure")
    public Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public void setEvaluationProcedure(Citation newValue) {
        this.checkWritePermission();
        this.evaluationProcedure = newValue;
    }

    @XmlElement(name="dateTime")
    public Collection<Date> getDates() {
        if (Semaphores.query((byte)4)) {
            return Containers.isNullOrEmpty(this.dates) ? null : this.dates;
        }
        if (this.dates == null) {
            this.dates = new Dates();
        }
        return this.dates;
    }

    public void setDates(Collection<? extends Date> newValues) {
        this.checkWritePermission();
        if (newValues != this.dates) {
            this.writeDates(newValues);
        }
    }

    private void writeDates(Collection<? extends Date> newValues) {
        if (Containers.isNullOrEmpty(newValues)) {
            this.dates = null;
        } else {
            if (this.dates == null) {
                this.dates = new Dates();
            }
            this.dates.clear();
            this.dates.addAll(newValues);
        }
    }

    @XmlElement(name="result", required=true)
    public Collection<Result> getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public void setResults(Collection<? extends Result> newValues) {
        this.results = this.writeCollection(newValues, this.results, Result.class);
    }

    private static final class Dates
    extends AbstractList<Date>
    implements CheckedContainer<Date>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1210175223467194009L;
        private long date1;
        private long date2;

        Dates() {
            this.clear();
        }

        @Override
        public Class<Date> getElementType() {
            return Date.class;
        }

        @Override
        public void clear() {
            this.date1 = Long.MIN_VALUE;
            this.date2 = Long.MIN_VALUE;
        }

        @Override
        public int size() {
            if (this.date2 != Long.MIN_VALUE) {
                return 2;
            }
            if (this.date1 != Long.MIN_VALUE) {
                return 1;
            }
            return 0;
        }

        @Override
        public Date get(int index) {
            long date = this.date1;
            switch (index) {
                case 1: {
                    date = this.date2;
                }
                case 0: {
                    if (date == Long.MIN_VALUE) break;
                    return new Date(date);
                }
            }
            throw new IndexOutOfBoundsException(Errors.format((short)49, index));
        }

        @Override
        public Date set(int index, Date value) {
            long date = value.getTime();
            Date previous = this.get(index);
            switch (index) {
                case 0: {
                    this.date1 = date;
                    break;
                }
                case 1: {
                    this.date2 = date;
                }
            }
            ++this.modCount;
            return previous;
        }

        @Override
        public Date remove(int index) {
            Date previous = this.get(index);
            switch (index) {
                case 0: {
                    this.date1 = this.date2;
                }
                case 1: {
                    this.date2 = Long.MIN_VALUE;
                }
            }
            ++this.modCount;
            return previous;
        }

        @Override
        public void add(int index, Date value) {
            long date = value.getTime();
            if (this.date2 == Long.MIN_VALUE) {
                switch (index) {
                    case 0: {
                        this.date2 = this.date1;
                        this.date1 = date;
                        ++this.modCount;
                        return;
                    }
                    case 1: {
                        if (this.date1 == Long.MIN_VALUE) break;
                        this.date2 = date;
                        ++this.modCount;
                        return;
                    }
                }
            }
            throw new IndexOutOfBoundsException(Errors.format((short)49, index));
        }

        @Override
        public boolean addAll(Collection<? extends Date> dates) {
            int c = this.modCount++;
            if (dates != null) {
                Iterator<? extends Date> it = dates.iterator();
                switch (this.size()) {
                    case 0: {
                        if (!it.hasNext()) break;
                        this.date1 = it.next().getTime();
                    }
                    case 1: {
                        if (!it.hasNext()) break;
                        this.date2 = it.next().getTime();
                        ++this.modCount;
                    }
                    default: {
                        if (!it.hasNext()) break;
                        throw new IllegalArgumentException(Errors.format((short)24, "dates", 2, dates.size()));
                    }
                }
            }
            return this.modCount != c;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

