/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.Scope;

@XmlType(name="DQ_DataQuality_Type", propOrder={"scope", "reports", "lineage"})
@XmlRootElement(name="DQ_DataQuality")
public class DefaultDataQuality
extends ISOMetadata
implements DataQuality {
    private static final long serialVersionUID = 5036527927404894540L;
    private Scope scope;
    private Collection<Element> reports;
    private Lineage lineage;

    public DefaultDataQuality() {
    }

    public DefaultDataQuality(Scope scope) {
        this.scope = scope;
    }

    public DefaultDataQuality(DataQuality object) {
        super(object);
        if (object != null) {
            this.scope = object.getScope();
            this.reports = this.copyCollection(object.getReports(), Element.class);
            this.lineage = object.getLineage();
        }
    }

    public static DefaultDataQuality castOrCopy(DataQuality object) {
        if (object == null || object instanceof DefaultDataQuality) {
            return (DefaultDataQuality)object;
        }
        return new DefaultDataQuality(object);
    }

    @Override
    @XmlElement(name="scope", required=true)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope newValue) {
        this.checkWritePermission();
        this.scope = newValue;
    }

    @XmlElement(name="report")
    public Collection<Element> getReports() {
        this.reports = this.nonNullCollection(this.reports, Element.class);
        return this.reports;
    }

    public void setReports(Collection<? extends Element> newValues) {
        this.reports = this.writeCollection(newValues, this.reports, Element.class);
    }

    @Override
    @XmlElement(name="lineage")
    public Lineage getLineage() {
        return this.lineage;
    }

    public void setLineage(Lineage newValue) {
        this.checkWritePermission();
        this.lineage = newValue;
    }
}

