/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.List;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="DQ_QuantitativeResult_Type", propOrder={"valueType", "valueUnit", "errorStatistic"})
@XmlRootElement(name="DQ_QuantitativeResult")
public class DefaultQuantitativeResult
extends AbstractResult
implements QuantitativeResult {
    private static final long serialVersionUID = -403671810118461829L;
    private List<Record> values;
    private RecordType valueType;
    private Unit<?> valueUnit;
    private InternationalString errorStatistic;

    public DefaultQuantitativeResult() {
    }

    public DefaultQuantitativeResult(QuantitativeResult object) {
        super(object);
        if (object != null) {
            this.valueType = object.getValueType();
            this.valueUnit = object.getValueUnit();
            this.errorStatistic = object.getErrorStatistic();
            this.values = this.copyList(object.getValues(), Record.class);
        }
    }

    public static DefaultQuantitativeResult castOrCopy(QuantitativeResult object) {
        if (object == null || object instanceof DefaultQuantitativeResult) {
            return (DefaultQuantitativeResult)object;
        }
        return new DefaultQuantitativeResult(object);
    }

    public List<Record> getValues() {
        this.values = this.nonNullList(this.values, Record.class);
        return this.values;
    }

    public void setValues(List<? extends Record> newValues) {
        this.values = this.writeList(newValues, this.values, Record.class);
    }

    @Override
    @XmlElement(name="valueType")
    public RecordType getValueType() {
        RecordType type = this.valueType;
        if (type == null && this.values != null) {
            for (Record value : this.values) {
                if (value == null) continue;
                RecordType t = value.getRecordType();
                if (t == null) {
                    return null;
                }
                if (type == null) {
                    type = t;
                    continue;
                }
                if (type == t) continue;
                return null;
            }
        }
        return type;
    }

    public void setValueType(RecordType newValue) {
        this.checkWritePermission();
        this.valueType = newValue;
    }

    @Override
    @XmlElement(name="valueUnit", required=true)
    public Unit<?> getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(Unit<?> newValue) {
        this.checkWritePermission();
        this.valueUnit = newValue;
    }

    @Override
    @XmlElement(name="errorStatistic")
    public InternationalString getErrorStatistic() {
        return this.errorStatistic;
    }

    public void setErrorStatistic(InternationalString newValue) {
        this.checkWritePermission();
        this.errorStatistic = newValue;
    }
}

