/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Measure;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Dimension_Type", propOrder={"dimensionName", "dimensionSize", "resolution"})
@XmlRootElement(name="MD_Dimension")
public class DefaultDimension
extends ISOMetadata
implements Dimension {
    private static final long serialVersionUID = 1104542984724265236L;
    private DimensionNameType dimensionName;
    private Integer dimensionSize;
    private Double resolution;
    private InternationalString dimensionTitle;
    private InternationalString dimensionDescription;

    public DefaultDimension() {
    }

    public DefaultDimension(DimensionNameType dimensionName, int dimensionSize) {
        ArgumentChecks.ensurePositive("dimensionSize", dimensionSize);
        this.dimensionName = dimensionName;
        this.dimensionSize = dimensionSize;
    }

    public DefaultDimension(Dimension object) {
        super(object);
        if (object != null) {
            this.dimensionName = object.getDimensionName();
            this.dimensionSize = object.getDimensionSize();
            this.resolution = object.getResolution();
            if (object instanceof DefaultDimension) {
                this.dimensionTitle = ((DefaultDimension)object).getDimensionTitle();
                this.dimensionDescription = ((DefaultDimension)object).getDimensionDescription();
            }
        }
    }

    public static DefaultDimension castOrCopy(Dimension object) {
        if (object == null || object instanceof DefaultDimension) {
            return (DefaultDimension)object;
        }
        return new DefaultDimension(object);
    }

    @Override
    @XmlElement(name="dimensionName", required=true)
    public DimensionNameType getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(DimensionNameType newValue) {
        this.checkWritePermission();
        this.dimensionName = newValue;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="dimensionSize", required=true)
    public Integer getDimensionSize() {
        return this.dimensionSize;
    }

    public void setDimensionSize(Integer newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultDimension.class, "dimensionSize", false, newValue)) {
            this.dimensionSize = newValue;
        }
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlJavaTypeAdapter(value=GO_Measure.class)
    @XmlElement(name="resolution")
    public Double getResolution() {
        return this.resolution;
    }

    public void setResolution(Double newValue) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultDimension.class, "dimensionSize", true, newValue)) {
            this.resolution = newValue;
        }
    }

    @UML(identifier="dimensionTitle", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDimensionTitle() {
        return this.dimensionTitle;
    }

    public void setDimensionTitle(InternationalString newValue) {
        this.checkWritePermission();
        this.dimensionTitle = newValue;
    }

    @UML(identifier="dimensionDescription", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDimensionDescription() {
        return this.dimensionDescription;
    }

    public void setDimensionDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.dimensionDescription = newValue;
    }
}

