/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.spatial.AbstractGeolocationInformation;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.GCPCollection;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@XmlType(name="MI_GCPCollection_Type", propOrder={"collectionIdentification", "collectionName", "coordinateReferenceSystem", "GCPs"})
@XmlRootElement(name="MI_GCPCollection", namespace="http://www.isotc211.org/2005/gmi")
public class DefaultGCPCollection
extends AbstractGeolocationInformation
implements GCPCollection {
    private static final long serialVersionUID = -2757911443659529373L;
    private Integer collectionIdentification;
    private InternationalString collectionName;
    private ReferenceSystem coordinateReferenceSystem;
    private Collection<GCP> GCPs;

    public DefaultGCPCollection() {
    }

    public DefaultGCPCollection(GCPCollection object) {
        super(object);
        if (object != null) {
            this.collectionIdentification = object.getCollectionIdentification();
            this.collectionName = object.getCollectionName();
            this.coordinateReferenceSystem = object.getCoordinateReferenceSystem();
            this.GCPs = this.copyCollection(object.getGCPs(), GCP.class);
        }
    }

    public static DefaultGCPCollection castOrCopy(GCPCollection object) {
        if (object == null || object instanceof DefaultGCPCollection) {
            return (DefaultGCPCollection)object;
        }
        return new DefaultGCPCollection(object);
    }

    @Override
    @XmlElement(name="collectionIdentification", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Integer getCollectionIdentification() {
        return this.collectionIdentification;
    }

    public void setCollectionIdentification(Integer newValue) {
        this.checkWritePermission();
        this.collectionIdentification = newValue;
    }

    @Override
    @XmlElement(name="collectionName", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public InternationalString getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(InternationalString newValue) {
        this.checkWritePermission();
        this.collectionName = newValue;
    }

    @Override
    @XmlElement(name="coordinateReferenceSystem", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public ReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public void setCoordinateReferenceSystem(ReferenceSystem newValue) {
        this.checkWritePermission();
        this.coordinateReferenceSystem = newValue;
    }

    @XmlElement(name="gcp", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Collection<GCP> getGCPs() {
        this.GCPs = this.nonNullCollection(this.GCPs, GCP.class);
        return this.GCPs;
    }

    public void setGCPs(Collection<? extends GCP> newValues) {
        this.GCPs = this.writeCollection(newValues, this.GCPs, GCP.class);
    }
}

