/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gmi.MI_Georectified;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.util.resources.Messages;
import org.opengis.geometry.primitive.Point;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Georectified_Type", propOrder={"checkPointAvailable", "checkPointDescription", "cornerPoints", "centerPoint", "pointInPixel", "transformationDimensionDescription", "transformationDimensionMapping", "checkPoints"})
@XmlRootElement(name="MD_Georectified")
@XmlSeeAlso(value={MI_Georectified.class})
public class DefaultGeorectified
extends DefaultGridSpatialRepresentation
implements Georectified {
    private static final long serialVersionUID = -2924562334097446037L;
    private static final byte CHECK_POINT_MASK = 2;
    private InternationalString checkPointDescription;
    private List<Point> cornerPoints;
    private Point centerPoint;
    private PixelOrientation pointInPixel;
    private InternationalString transformationDimensionDescription;
    private Collection<InternationalString> transformationDimensionMapping;
    private Collection<GCP> checkPoints;

    public DefaultGeorectified() {
    }

    public DefaultGeorectified(Georectified object) {
        super(object);
        if (object != null) {
            this.checkPointDescription = object.getCheckPointDescription();
            this.cornerPoints = this.copyList(object.getCornerPoints(), Point.class);
            this.centerPoint = object.getCenterPoint();
            this.pointInPixel = object.getPointInPixel();
            this.transformationDimensionDescription = object.getTransformationDimensionDescription();
            this.transformationDimensionMapping = this.copyCollection(object.getTransformationDimensionMapping(), InternationalString.class);
            this.checkPoints = this.copyCollection(object.getCheckPoints(), GCP.class);
            if (this.checkPointDescription != null || object.isCheckPointAvailable()) {
                this.booleans = (byte)(this.booleans | 2);
            }
        }
    }

    public static DefaultGeorectified castOrCopy(Georectified object) {
        if (object == null || object instanceof DefaultGeorectified) {
            return (DefaultGeorectified)object;
        }
        return new DefaultGeorectified(object);
    }

    @Override
    @XmlElement(name="checkPointAvailability", required=true)
    public boolean isCheckPointAvailable() {
        return (this.booleans & 2) != 0;
    }

    public void setCheckPointAvailable(boolean newValue) {
        this.checkWritePermission();
        if (newValue) {
            this.booleans = (byte)(this.booleans | 2);
        } else {
            if (this.checkPointDescription != null && (this.booleans & 2) != 0) {
                Context.warningOccured(Context.current(), DefaultGeorectified.class, "setCheckPointAvailable", Messages.class, (short)4, "checkPointDescription", "checkPointAvailability");
            }
            this.booleans = (byte)(this.booleans & 0xFFFFFFFD);
        }
    }

    @Override
    @XmlElement(name="checkPointDescription")
    public InternationalString getCheckPointDescription() {
        return (this.booleans & 2) != 0 ? this.checkPointDescription : null;
    }

    public void setCheckPointDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.checkPointDescription = newValue;
        if (newValue != null) {
            this.booleans = (byte)(this.booleans | 2);
        }
    }

    @XmlElement(name="cornerPoints", required=true)
    public List<Point> getCornerPoints() {
        this.cornerPoints = this.nonNullList(this.cornerPoints, Point.class);
        return this.cornerPoints;
    }

    public void setCornerPoints(List<? extends Point> newValues) {
        this.cornerPoints = this.writeList(newValues, this.cornerPoints, Point.class);
    }

    @Override
    @XmlElement(name="centerPoint")
    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(Point newValue) {
        this.checkWritePermission();
        this.centerPoint = newValue;
    }

    @Override
    @XmlElement(name="pointInPixel", required=true)
    public PixelOrientation getPointInPixel() {
        return this.pointInPixel;
    }

    public void setPointInPixel(PixelOrientation newValue) {
        this.checkWritePermission();
        this.pointInPixel = newValue;
    }

    @Override
    @XmlElement(name="transformationDimensionDescription")
    public InternationalString getTransformationDimensionDescription() {
        return this.transformationDimensionDescription;
    }

    public void setTransformationDimensionDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.transformationDimensionDescription = newValue;
    }

    @XmlElement(name="transformationDimensionMapping")
    public Collection<InternationalString> getTransformationDimensionMapping() {
        this.transformationDimensionMapping = this.nonNullCollection(this.transformationDimensionMapping, InternationalString.class);
        return this.transformationDimensionMapping;
    }

    public void setTransformationDimensionMapping(Collection<? extends InternationalString> newValues) {
        this.transformationDimensionMapping = this.writeCollection(newValues, this.transformationDimensionMapping, InternationalString.class);
    }

    @XmlElement(name="checkPoint", namespace="http://www.isotc211.org/2005/gmi")
    public Collection<GCP> getCheckPoints() {
        this.checkPoints = this.nonNullCollection(this.checkPoints, GCP.class);
        return this.checkPoints;
    }

    public void setCheckPoints(Collection<? extends GCP> newValues) {
        this.checkPoints = this.writeCollection(newValues, this.checkPoints, GCP.class);
    }
}

