/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.MI_Georeferenceable;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.spatial.GeolocationInformation;
import org.opengis.metadata.spatial.Georeferenceable;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

@XmlType(name="MD_Georeferenceable_Type", propOrder={"controlPointAvailable", "orientationParameterAvailable", "orientationParameterDescription", "parameterCitations", "geolocationInformation"})
@XmlRootElement(name="MD_Georeferenceable")
@XmlSeeAlso(value={MI_Georeferenceable.class})
public class DefaultGeoreferenceable
extends DefaultGridSpatialRepresentation
implements Georeferenceable {
    private static final long serialVersionUID = -334605303200205283L;
    private static final byte CONTROL_POINT_MASK = 2;
    private static final byte OPERATION_MASK = 4;
    private InternationalString orientationParameterDescription;
    private Record georeferencedParameters;
    private Collection<Citation> parameterCitations;
    private Collection<GeolocationInformation> geolocationInformation;

    public DefaultGeoreferenceable() {
    }

    public DefaultGeoreferenceable(Georeferenceable object) {
        super(object);
        if (object != null) {
            if (object.isControlPointAvailable()) {
                this.booleans = (byte)(this.booleans | 2);
            }
            if (object.isOrientationParameterAvailable()) {
                this.booleans = (byte)(this.booleans | 4);
            }
            this.orientationParameterDescription = object.getOrientationParameterDescription();
            this.parameterCitations = this.copyCollection(object.getParameterCitations(), Citation.class);
            this.geolocationInformation = this.copyCollection(object.getGeolocationInformation(), GeolocationInformation.class);
            this.georeferencedParameters = object.getGeoreferencedParameters();
        }
    }

    public static DefaultGeoreferenceable castOrCopy(Georeferenceable object) {
        if (object == null || object instanceof DefaultGeoreferenceable) {
            return (DefaultGeoreferenceable)object;
        }
        return new DefaultGeoreferenceable(object);
    }

    @Override
    @XmlElement(name="controlPointAvailability", required=true)
    public boolean isControlPointAvailable() {
        return (this.booleans & 2) != 0;
    }

    public void setControlPointAvailable(boolean newValue) {
        this.checkWritePermission();
        this.booleans = newValue ? (byte)(this.booleans | 2) : (byte)(this.booleans & 0xFFFFFFFD);
    }

    @Override
    @XmlElement(name="orientationParameterAvailability", required=true)
    public boolean isOrientationParameterAvailable() {
        return (this.booleans & 4) != 0;
    }

    public void setOrientationParameterAvailable(boolean newValue) {
        this.checkWritePermission();
        this.booleans = newValue ? (byte)(this.booleans | 4) : (byte)(this.booleans & 0xFFFFFFFB);
    }

    @Override
    @XmlElement(name="orientationParameterDescription")
    public InternationalString getOrientationParameterDescription() {
        return this.orientationParameterDescription;
    }

    public void setOrientationParameterDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.orientationParameterDescription = newValue;
    }

    @Override
    public Record getGeoreferencedParameters() {
        return this.georeferencedParameters;
    }

    public void setGeoreferencedParameters(Record newValue) {
        this.checkWritePermission();
        this.georeferencedParameters = newValue;
    }

    @XmlElement(name="parameterCitation")
    public Collection<Citation> getParameterCitations() {
        this.parameterCitations = this.nonNullCollection(this.parameterCitations, Citation.class);
        return this.parameterCitations;
    }

    public void setParameterCitations(Collection<? extends Citation> newValues) {
        this.parameterCitations = this.writeCollection(newValues, this.parameterCitations, Citation.class);
    }

    @XmlElement(name="geolocationInformation", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Collection<GeolocationInformation> getGeolocationInformation() {
        this.geolocationInformation = this.nonNullCollection(this.geolocationInformation, GeolocationInformation.class);
        return this.geolocationInformation;
    }

    public void setGeolocationInformation(Collection<? extends GeolocationInformation> newValues) {
        this.geolocationInformation = this.writeCollection(newValues, this.geolocationInformation, GeolocationInformation.class);
    }
}

