/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.internal.jaxb.gml.MeasureList;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.PatchedUnitFormat;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.IntegerList;
import org.apache.sis.parameter.UnmodifiableParameterValue;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

@XmlType(name="ParameterValueType", propOrder={"xmlValue", "descriptor"})
@XmlRootElement(name="ParameterValue")
public class DefaultParameterValue<T>
extends FormattableObject
implements ParameterValue<T>,
LenientComparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5837826787089486776L;
    private ParameterDescriptor<T> descriptor;
    protected T value;
    protected Unit<?> unit;

    public DefaultParameterValue(ParameterDescriptor<T> descriptor) {
        ArgumentChecks.ensureNonNull("descriptor", descriptor);
        this.descriptor = descriptor;
        this.value = descriptor.getDefaultValue();
        this.unit = descriptor.getUnit();
    }

    public DefaultParameterValue(ParameterValue<T> parameter) {
        ArgumentChecks.ensureNonNull("parameter", parameter);
        this.descriptor = parameter.getDescriptor();
        this.value = parameter.getValue();
        this.unit = parameter.getUnit();
    }

    @Override
    @XmlElement(name="operationParameter", required=true)
    public ParameterDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public int intValue() throws IllegalStateException {
        int integer;
        T value = this.getValue();
        if (value instanceof Number && (double)(integer = ((Number)value).intValue()) == ((Number)value).doubleValue()) {
            return integer;
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public int[] intValueList() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof int[]) {
            return (int[])((int[])value).clone();
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public double doubleValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public double[] doubleValueList() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof double[]) {
            return (double[])((double[])value).clone();
        }
        throw this.missingOrIncompatibleValue(value);
    }

    private UnitConverter getConverterTo(Unit<?> unit) {
        Unit<?> source = this.getUnit();
        if (source == null) {
            throw new IllegalStateException(Errors.format((short)139, Verifier.getDisplayName(this.descriptor)));
        }
        ArgumentChecks.ensureNonNull("unit", unit);
        short expectedID = Verifier.getUnitMessageID(source);
        if (Verifier.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        try {
            return source.getConverterToAny(unit);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(Errors.format((short)46, source, unit), e);
        }
    }

    @Override
    public double doubleValue(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        double value = this.doubleValue();
        return this.getConverterTo(unit).convert(value);
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        UnitConverter converter = this.getConverterTo(unit);
        double[] values = this.doubleValueList();
        for (int i = 0; i < values.length; ++i) {
            values[i] = converter.convert(values[i]);
        }
        return values;
    }

    @Override
    public String stringValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof CharSequence) {
            return value.toString();
        }
        throw this.missingOrIncompatibleValue(value);
    }

    @Override
    public URI valueFile() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof URI) {
            return (URI)value;
        }
        if (value instanceof File) {
            return ((File)value).toURI();
        }
        URISyntaxException cause = null;
        try {
            if (value instanceof URL) {
                return ((URL)value).toURI();
            }
        }
        catch (URISyntaxException exception) {
            cause = exception;
        }
        String name = Verifier.getDisplayName(this.descriptor);
        if (value != null) {
            throw new InvalidParameterTypeException(this.getClassTypeError(), name);
        }
        throw new IllegalStateException(Errors.format((short)142, cause, name));
    }

    private static boolean isFile(Object value) {
        return value instanceof URI || value instanceof URL || value instanceof File;
    }

    private boolean isOrNeedFile(Object value) {
        if (value instanceof String) {
            Class<T> type = this.descriptor.getValueClass();
            return type == URI.class || type == URL.class || File.class.isAssignableFrom(type);
        }
        return DefaultParameterValue.isFile(value);
    }

    private IllegalStateException missingOrIncompatibleValue(Object value) {
        String name = Verifier.getDisplayName(this.descriptor);
        if (value != null) {
            return new InvalidParameterTypeException(this.getClassTypeError(), name);
        }
        return new IllegalStateException(Errors.format((short)142, name));
    }

    private String getClassTypeError() {
        return Errors.format((short)141, this.descriptor != null ? this.descriptor.getValueClass() : "?");
    }

    @Override
    public void setValue(Object value) throws InvalidParameterValueException {
        if (this.isOrNeedFile(value)) {
            try {
                value = ObjectConverters.convert(value, this.descriptor.getValueClass());
            }
            catch (UnconvertibleObjectException e) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), DefaultParameterValue.class, "setValue", e);
            }
        }
        this.setValue(value, this.unit);
    }

    @Override
    public void setValue(boolean value) throws InvalidParameterValueException {
        this.setValue(value, this.unit);
    }

    @Override
    public void setValue(int value) throws InvalidParameterValueException {
        T c;
        Integer n = value;
        Class<T> valueClass = this.descriptor.getValueClass();
        if (Number.class.isAssignableFrom(valueClass) && ((Number)(c = Numbers.cast(value, valueClass))).intValue() == value) {
            n = c;
        }
        this.setValue(n, this.unit);
    }

    private static Number wrap(double value, Class<?> valueClass) throws IllegalArgumentException {
        if (Number.class.isAssignableFrom(valueClass)) {
            return Numbers.wrap(value, valueClass);
        }
        return Numerics.valueOf(value);
    }

    @Override
    public void setValue(double value) throws InvalidParameterValueException {
        try {
            this.setValue(DefaultParameterValue.wrap(value, this.descriptor.getValueClass()), this.unit);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParameterValueException(e.getLocalizedMessage(), Verifier.getDisplayName(this.descriptor), value);
        }
    }

    @Override
    public void setValue(double value, Unit<?> unit) throws InvalidParameterValueException {
        try {
            this.setValue(DefaultParameterValue.wrap(value, this.descriptor.getValueClass()), unit);
        }
        catch (InvalidParameterValueException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw (InvalidParameterValueException)new InvalidParameterValueException(e.getLocalizedMessage(), Verifier.getDisplayName(this.descriptor), value).initCause(e);
        }
    }

    @Override
    public void setValue(double[] values, Unit<?> unit) throws InvalidParameterValueException {
        this.setValue((Object)values, unit);
    }

    protected void setValue(Object value, Unit<?> unit) throws InvalidParameterValueException {
        T convertedValue = Verifier.ensureValidValue(this.descriptor, value, unit);
        if (value != null) {
            this.validate(convertedValue);
            this.value = value;
        } else {
            this.value = this.descriptor.getDefaultValue();
        }
        this.unit = unit;
    }

    protected void validate(T value) throws InvalidParameterValueException {
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (mode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    DefaultParameterValue that = (DefaultParameterValue)object;
                    return Objects.equals(this.descriptor, that.descriptor) && Objects.equals(this.value, that.value) && Objects.equals(this.unit, that.unit);
                }
            } else if (object instanceof ParameterValue) {
                ParameterValue that = (ParameterValue)object;
                return Utilities.deepEquals(this.getDescriptor(), that.getDescriptor(), mode) && Utilities.deepEquals(this.getValue(), that.getValue(), mode) && Objects.equals(this.getUnit(), that.getUnit());
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        int code = 37 * this.descriptor.hashCode();
        if (this.value != null) {
            code += this.value.hashCode();
        }
        if (this.unit != null) {
            code += 31 * this.unit.hashCode();
        }
        return code;
    }

    @Override
    public DefaultParameterValue<T> clone() {
        try {
            return (DefaultParameterValue)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static <T> DefaultParameterValue<T> unmodifiable(ParameterValue<T> parameter) {
        return UnmodifiableParameterValue.create(parameter);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        GeneralParameterDescriptor descriptor = this.getDescriptor();
        WKTUtilities.appendName(descriptor, formatter, ElementKind.PARAMETER);
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        Unit<?> unit = this.getUnit();
        if (unit == null) {
            T value = this.getValue();
            if (!isWKT1 && DefaultParameterValue.isFile(value)) {
                formatter.append(value.toString(), null);
                return "ParameterFile";
            }
            formatter.appendAny(value);
        } else {
            double value;
            boolean ignoreUnits;
            Unit<?> contextualUnit;
            if (descriptor == null || (contextualUnit = descriptor.getUnit()) == null) {
                contextualUnit = unit;
            }
            contextualUnit = formatter.toContextualUnit(contextualUnit);
            if (isWKT1) {
                unit = contextualUnit;
                ignoreUnits = true;
            } else {
                if (convention != Convention.INTERNAL) {
                    unit = PatchedUnitFormat.toFormattable(unit);
                }
                ignoreUnits = unit.equals(contextualUnit);
            }
            try {
                value = this.doubleValue(unit);
            }
            catch (IllegalStateException exception) {
                if (descriptor != null) {
                    formatter.setInvalidWKT(descriptor, (Exception)exception);
                } else {
                    formatter.setInvalidWKT(DefaultParameterValue.class, (Exception)exception);
                }
                value = Double.NaN;
            }
            formatter.append(value);
            if (!ignoreUnits && !Double.isNaN(value)) {
                ignoreUnits = Numerics.equals(value, this.doubleValue(contextualUnit));
            }
            if (ignoreUnits && convention != Convention.INTERNAL) {
                boolean bl = ignoreUnits = convention.isSimplified() && DefaultParameterValue.hasContextualUnit(formatter);
            }
            if (!ignoreUnits) {
                if (!isWKT1) {
                    formatter.append(unit);
                } else if (!ignoreUnits) {
                    if (descriptor != null) {
                        formatter.setInvalidWKT(descriptor, null);
                    } else {
                        formatter.setInvalidWKT(DefaultParameterValue.class, null);
                    }
                }
            }
        }
        return "Parameter";
    }

    private static boolean hasContextualUnit(Formatter formatter) {
        return formatter.hasContextualUnit(1) || formatter.hasContextualUnit(2);
    }

    private DefaultParameterValue() {
    }

    final void setDescriptor(ParameterDescriptor<T> descriptor) {
        this.descriptor = descriptor;
        assert (this.value == null || descriptor.getValueClass().isInstance(this.value)) : this;
    }

    @XmlElements(value={@XmlElement(name="value", type=Measure.class), @XmlElement(name="integerValue", type=Integer.class), @XmlElement(name="booleanValue", type=Boolean.class), @XmlElement(name="stringValue", type=String.class), @XmlElement(name="valueFile", type=URI.class), @XmlElement(name="integerValueList", type=IntegerList.class), @XmlElement(name="valueList", type=MeasureList.class)})
    private Object getXmlValue() {
        T value = this.getValue();
        if (value != null) {
            if (value instanceof Number) {
                int xmlValue;
                Number n = (Number)value;
                if (Numbers.isInteger(n.getClass()) && (xmlValue = n.intValue()) >= 0 && (double)xmlValue == n.doubleValue()) {
                    return xmlValue;
                }
                return new Measure(((Number)value).doubleValue(), this.getUnit());
            }
            if (value instanceof CharSequence) {
                return value.toString();
            }
            if (DefaultParameterValue.isFile(value)) {
                return ObjectConverters.convert(value, URI.class);
            }
            Class<?> type = Numbers.primitiveToWrapper(value.getClass().getComponentType());
            if (type != null && Number.class.isAssignableFrom(type)) {
                if (Numbers.isInteger(type)) {
                    return new IntegerList(value);
                }
                return new MeasureList(value, type, this.getUnit());
            }
        }
        return value;
    }

    private void setXmlValue(Object xmlValue) {
        if (this.value == null && this.unit == null) {
            if (xmlValue instanceof Measure) {
                Measure measure = (Measure)xmlValue;
                xmlValue = measure.value;
                this.unit = measure.unit;
            } else if (xmlValue instanceof MeasureList) {
                MeasureList measure = (MeasureList)xmlValue;
                xmlValue = measure.toArray();
                this.unit = measure.unit;
            } else if (xmlValue instanceof IntegerList) {
                xmlValue = ((IntegerList)xmlValue).toArray();
            }
            this.value = this.descriptor != null ? ObjectConverters.convert(xmlValue, this.descriptor.getValueClass()) : xmlValue;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultParameterValue.class, "setXmlValue", "value");
        }
    }
}

