/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Collections;
import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.MapProjectionDescriptor;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;

final class MapProjectionParameters
extends DefaultParameterValueGroup {
    private static final long serialVersionUID = -6801091012335717139L;
    private transient ParameterValue<Double> earthRadius;
    private transient InverseFlattening inverseFlattening;
    private transient ParameterValue<double[]> standardParallel;
    private transient ParameterValue<Boolean> isIvfDefinitive;

    MapProjectionParameters(MapProjectionDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    boolean isKnownImplementation() {
        return true;
    }

    @Override
    ParameterValue<?> parameterIfExist(String name) throws ParameterNotFoundException {
        if (MapProjectionDescriptor.isHeuristicMatchForName(name, "earth_radius")) {
            if (this.earthRadius == null) {
                this.earthRadius = new EarthRadius(this.parameter("semi_major"), this.parameter("semi_minor"));
            }
            return this.earthRadius;
        }
        if (MapProjectionDescriptor.isHeuristicMatchForName(name, "inverse_flattening")) {
            return this.getInverseFlattening();
        }
        if (MapProjectionDescriptor.isHeuristicMatchForName(name, "is_ivf_definitive")) {
            if (this.isIvfDefinitive == null) {
                this.isIvfDefinitive = new IsIvfDefinitive(this.getInverseFlattening());
            }
            return this.isIvfDefinitive;
        }
        if (((MapProjectionDescriptor)this.getDescriptor()).hasStandardParallels && MapProjectionDescriptor.isHeuristicMatchForName(name, "standard_parallel")) {
            if (this.standardParallel == null) {
                this.standardParallel = new StandardParallel(this.parameter("standard_parallel_1"), this.parameter("standard_parallel_2"));
            }
            return this.standardParallel;
        }
        return super.parameterIfExist(name);
    }

    private InverseFlattening getInverseFlattening() {
        if (this.inverseFlattening == null) {
            this.inverseFlattening = new InverseFlattening(this.parameter("semi_major"), this.parameter("semi_minor"));
        }
        return this.inverseFlattening;
    }

    static final class StandardParallel
    extends DefaultParameterValue<double[]> {
        private static final long serialVersionUID = -1379566730374843040L;
        static final ParameterDescriptor<double[]> DESCRIPTOR = new DefaultParameterDescriptor<Object>(InverseFlattening.toMap("standard_parallel"), 0, 1, double[].class, null, null, null);
        private final ParameterValue<?> standardParallel1;
        private final ParameterValue<?> standardParallel2;

        StandardParallel(ParameterValue<?> standardParallel1, ParameterValue<?> standardParallel2) {
            super(DESCRIPTOR);
            this.standardParallel1 = standardParallel1;
            this.standardParallel2 = standardParallel2;
        }

        @Override
        protected void setValue(Object value, Unit<?> unit) {
            super.setValue(value, unit);
            double p1 = Double.NaN;
            double p2 = Double.NaN;
            if (value != null) {
                double[] values = (double[])value;
                switch (values.length) {
                    default: {
                        throw new IllegalArgumentException(Errors.format((short)107, 2, values.length));
                    }
                    case 2: {
                        p2 = values[1];
                    }
                    case 1: {
                        p1 = values[0];
                    }
                    case 0: 
                }
            }
            this.standardParallel1.setValue(p1, unit);
            this.standardParallel2.setValue(p2, unit);
        }

        @Override
        public double[] getValue() {
            Number p1 = (Number)this.standardParallel1.getValue();
            Number p2 = (Number)this.standardParallel2.getValue();
            if (p2 == null) {
                if (p1 == null) {
                    return ArraysExt.EMPTY_DOUBLE;
                }
                return new double[]{p1.doubleValue()};
            }
            return new double[]{p1 != null ? p1.doubleValue() : Double.NaN, p2.doubleValue()};
        }
    }

    static final class IsIvfDefinitive
    extends DefaultParameterValue<Boolean> {
        private static final long serialVersionUID = 5988883252321358629L;
        static final ParameterDescriptor<Boolean> DESCRIPTOR = new DefaultParameterDescriptor<Boolean>(InverseFlattening.toMap("is_ivf_definitive"), 0, 1, Boolean.class, null, null, Boolean.FALSE);
        private final InverseFlattening inverseFlattening;

        IsIvfDefinitive(InverseFlattening inverseFlattening) {
            super(DESCRIPTOR);
            this.inverseFlattening = inverseFlattening;
        }

        @Override
        protected void setValue(Object value, Unit<?> unit) {
            super.setValue(value, unit);
            if (!((Boolean)value).booleanValue()) {
                this.inverseFlattening.invalidate();
            }
        }

        @Override
        public boolean booleanValue() {
            return this.inverseFlattening.isIvfDefinitive();
        }

        @Override
        public Boolean getValue() {
            return this.booleanValue();
        }
    }

    static final class InverseFlattening
    extends DefaultParameterValue<Double> {
        private static final long serialVersionUID = 4490056024453509851L;
        static final ParameterDescriptor<Double> DESCRIPTOR = new DefaultParameterDescriptor<Object>(InverseFlattening.toMap("inverse_flattening"), 0, 1, Double.class, MeasurementRange.createGreaterThan(0.0, Unit.ONE), null, null);
        private final ParameterValue<?> semiMajor;
        private final ParameterValue<?> semiMinor;
        private double inverseFlattening;
        private double a;
        private double b;

        static Map<String, ?> toMap(String name) {
            return Collections.singletonMap("name", new NamedIdentifier(Citations.NETCDF, name));
        }

        InverseFlattening(ParameterValue<?> semiMajor, ParameterValue<?> semiMinor) {
            super(DESCRIPTOR);
            this.semiMajor = semiMajor;
            this.semiMinor = semiMinor;
            this.invalidate();
        }

        void invalidate() {
            this.b = Double.NaN;
            this.a = Double.NaN;
        }

        boolean isIvfDefinitive() {
            Number cb;
            Number ca;
            if (this.inverseFlattening > 0.0 && (ca = (Number)this.semiMajor.getValue()) != null && ca.doubleValue() == this.a && (cb = (Number)this.semiMinor.getValue()) != null && cb.doubleValue() == this.b) {
                return Objects.equals(this.semiMajor.getUnit(), this.semiMinor.getUnit());
            }
            return false;
        }

        @Override
        protected void setValue(Object value, Unit<?> unit) {
            super.setValue(value, unit);
            double ivf = (Double)value;
            Number ca = (Number)this.semiMajor.getValue();
            if (ca != null) {
                this.a = ca.doubleValue();
                this.b = Formulas.getSemiMinor(this.a, ivf);
                this.semiMinor.setValue(this.b, this.semiMajor.getUnit());
            } else {
                this.invalidate();
            }
            this.inverseFlattening = ivf;
        }

        @Override
        public double doubleValue() {
            double ca = this.semiMajor.doubleValue();
            double cb = this.semiMinor.doubleValue(this.semiMajor.getUnit());
            if (ca == this.a && cb == this.b && this.inverseFlattening > 0.0) {
                return this.inverseFlattening;
            }
            return Formulas.getInverseFlattening(ca, cb);
        }

        @Override
        public Double getValue() {
            return this.doubleValue();
        }
    }

    static final class EarthRadius
    extends DefaultParameterValue<Double> {
        private static final long serialVersionUID = 5848432458976184182L;
        static final ParameterDescriptor<Double> DESCRIPTOR = new DefaultParameterDescriptor<Object>(InverseFlattening.toMap("earth_radius"), 0, 1, Double.class, MeasurementRange.createGreaterThan(0.0, SI.METRE), null, null);
        private final ParameterValue<?> semiMajor;
        private final ParameterValue<?> semiMinor;

        EarthRadius(ParameterValue<?> semiMajor, ParameterValue<?> semiMinor) {
            super(DESCRIPTOR);
            this.semiMajor = semiMajor;
            this.semiMinor = semiMinor;
        }

        @Override
        protected void setValue(Object value, Unit<?> unit) {
            super.setValue(value, unit);
            double r = (Double)value;
            this.semiMajor.setValue(r, unit);
            this.semiMinor.setValue(r, unit);
        }

        @Override
        public double doubleValue() {
            double r = this.semiMajor.doubleValue();
            if (this.semiMinor.getValue() != null) {
                r = Formulas.getAuthalicRadius(r, this.semiMinor.doubleValue(this.semiMajor.getUnit()));
            }
            return r;
        }

        @Override
        public Unit<?> getUnit() {
            return this.semiMajor.getUnit();
        }

        @Override
        public Double getValue() {
            return this.doubleValue();
        }
    }
}

