/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.jaxb.metadata.replace.ServiceParameter;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.ParameterFormat;
import org.apache.sis.parameter.UnmodifiableParameterValueGroup;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.MemberName;

@XmlTransient
public abstract class Parameters
implements ParameterValueGroup,
Cloneable {
    protected Parameters() {
    }

    public static Parameters unmodifiable(ParameterValueGroup parameters) {
        return UnmodifiableParameterValueGroup.create(parameters);
    }

    public static Parameters castOrWrap(ParameterValueGroup parameters) {
        if (parameters == null || parameters instanceof Parameters) {
            return (Parameters)parameters;
        }
        return new Wrapper(parameters);
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> descriptor, Class<T> valueClass) throws ClassCastException {
        Class<?> actual;
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        if (descriptor != null && !valueClass.equals(actual = descriptor.getValueClass())) {
            throw new ClassCastException(Errors.format((short)143, Verifier.getDisplayName(descriptor), actual));
        }
        return descriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> parameter, Class<T> valueClass) throws ClassCastException {
        ParameterDescriptor<?> descriptor;
        Class<?> actual;
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        if (parameter != null && !valueClass.equals(actual = (descriptor = parameter.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Errors.format((short)143, Verifier.getDisplayName(descriptor), actual));
        }
        return parameter;
    }

    public static GeneralParameterDescriptor[] getDescriptors(GeneralParameterValue ... parameters) {
        if (parameters == null) {
            return null;
        }
        GeneralParameterDescriptor[] descriptors = new GeneralParameterDescriptor[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            GeneralParameterValue p = parameters[i];
            if (p == null) continue;
            descriptors[i] = p.getDescriptor();
        }
        return descriptors;
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameter) {
        return ServiceParameter.getMemberName(parameter);
    }

    public static Range<?> getValueDomain(ParameterDescriptor<?> descriptor) {
        if (descriptor != null) {
            if (descriptor instanceof DefaultParameterDescriptor) {
                return ((DefaultParameterDescriptor)descriptor).getValueDomain();
            }
            Class<?> valueClass = descriptor.getValueClass();
            Comparable<?> minimumValue = descriptor.getMinimumValue();
            Comparable<?> maximumValue = descriptor.getMaximumValue();
            if ((minimumValue == null || valueClass.isInstance(minimumValue)) && (maximumValue == null || valueClass.isInstance(maximumValue))) {
                if (Number.class.isAssignableFrom(valueClass)) {
                    Unit<?> unit = descriptor.getUnit();
                    if (unit != null) {
                        return new MeasurementRange<Number>(valueClass, (Number)((Object)minimumValue), true, (Number)((Object)maximumValue), true, unit);
                    }
                    if (minimumValue != null || maximumValue != null) {
                        return new NumberRange<Number>(valueClass, (Number)((Object)minimumValue), true, (Number)((Object)maximumValue), true);
                    }
                } else if (minimumValue != null || maximumValue != null) {
                    return new Range(valueClass, minimumValue, true, maximumValue, true);
                }
            }
        }
        return null;
    }

    private String getName(GeneralParameterDescriptor source) {
        Citation authority;
        String name;
        ReferenceIdentifier group;
        ParameterDescriptorGroup descriptor = this.getDescriptor();
        if (descriptor != null && (group = descriptor.getName()) != null && ((name = IdentifiedObjects.getName(source, authority = group.getAuthority())) != null || authority == null)) {
            return name;
        }
        return IdentifiedObjects.getName(source, null);
    }

    ParameterValue<?> parameterIfExist(String name) throws ParameterNotFoundException {
        ParameterValue fallback = null;
        ParameterValue ambiguity = null;
        for (GeneralParameterValue value : this.values()) {
            if (!(value instanceof ParameterValue)) continue;
            ParameterValue param = (ParameterValue)value;
            ParameterDescriptor descriptor = param.getDescriptor();
            if (name.equals(descriptor.getName().toString())) {
                return param;
            }
            if (!IdentifiedObjects.isHeuristicMatchForName(descriptor, name)) continue;
            if (fallback == null) {
                fallback = param;
                continue;
            }
            ambiguity = param;
        }
        if (ambiguity != null) {
            throw new ParameterNotFoundException(Errors.format((short)151, IdentifiedObjects.toString(fallback.getDescriptor().getName()), IdentifiedObjects.toString(ambiguity.getDescriptor().getName()), name), name);
        }
        return fallback;
    }

    private ParameterValue<?> getParameter(ParameterDescriptor<?> parameter) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("parameter", parameter);
        String name = this.getName(parameter);
        ParameterValue<?> value = this.parameterIfExist(name);
        if (value == null || this.isKnownImplementation()) {
            return value;
        }
        return this.parameter(name);
    }

    boolean isKnownImplementation() {
        return false;
    }

    public <T> T getValue(ParameterDescriptor<T> parameter) throws ParameterNotFoundException {
        ParameterValue<?> p = this.getParameter(parameter);
        if (p != null) {
            Class<T> type = parameter.getValueClass();
            Unit<?> unit = parameter.getUnit();
            Object value = unit == null ? p.getValue() : (type.isArray() ? (Object)p.doubleValueList(unit) : Double.valueOf(p.doubleValue(unit)));
            if (value != null) {
                return ObjectConverters.convert(value, type);
            }
        }
        return parameter.getDefaultValue();
    }

    public <T> T getMandatoryValue(ParameterDescriptor<T> parameter) throws ParameterNotFoundException {
        T value = this.getValue(parameter);
        if (value != null) {
            return value;
        }
        throw new IllegalStateException(Errors.format((short)142, Verifier.getDisplayName(parameter)));
    }

    private static <T> T defaultValue(ParameterDescriptor<T> parameter) throws IllegalStateException {
        T value = parameter.getDefaultValue();
        if (value != null) {
            return value;
        }
        throw new IllegalStateException(Errors.format((short)142, Verifier.getDisplayName(parameter)));
    }

    public boolean booleanValue(ParameterDescriptor<Boolean> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        return value != null ? value.booleanValue() : Parameters.defaultValue(parameter).booleanValue();
    }

    public int intValue(ParameterDescriptor<? extends Number> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        return value != null ? value.intValue() : Parameters.defaultValue(parameter).intValue();
    }

    public int[] intValueList(ParameterDescriptor<int[]> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        return value != null ? value.intValueList() : Parameters.defaultValue(parameter);
    }

    public double doubleValue(ParameterDescriptor<? extends Number> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        if (value != null) {
            Unit<?> unit = parameter.getUnit();
            return unit != null ? value.doubleValue(unit) : value.doubleValue();
        }
        return Parameters.defaultValue(parameter).doubleValue();
    }

    public double[] doubleValueList(ParameterDescriptor<double[]> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        if (value != null) {
            Unit<?> unit = parameter.getUnit();
            return unit != null ? value.doubleValueList(unit) : value.doubleValueList();
        }
        return Parameters.defaultValue(parameter);
    }

    public String stringValue(ParameterDescriptor<? extends CharSequence> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        return value != null ? value.stringValue() : Parameters.defaultValue(parameter).toString();
    }

    public <T> ParameterValue<T> getOrCreate(ParameterDescriptor<T> parameter) throws ParameterNotFoundException {
        return Parameters.cast(this.parameter(this.getName(parameter)), parameter.getValueClass());
    }

    @Override
    public Parameters clone() {
        try {
            return (Parameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void copy(ParameterValueGroup values, ParameterValueGroup destination) throws InvalidParameterNameException, InvalidParameterValueException {
        Integer ZERO = 0;
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        for (GeneralParameterValue value : values.values()) {
            String name = value.getDescriptor().getName().getCode();
            int occurrence = JDK8.getOrDefault(occurrences, name, ZERO);
            if (value instanceof ParameterValueGroup) {
                List<ParameterValueGroup> groups = destination.groups(name);
                Parameters.copy((ParameterValueGroup)value, occurrence < groups.size() ? groups.get(occurrence) : destination.addGroup(name));
            } else {
                ParameterValue target;
                ParameterValue source = (ParameterValue)value;
                if (occurrence == 0) {
                    try {
                        target = destination.parameter(name);
                    }
                    catch (ParameterNotFoundException cause) {
                        throw (InvalidParameterNameException)new InvalidParameterNameException(Errors.format((short)152, name), name).initCause(cause);
                    }
                } else {
                    target = (ParameterValue)Parameters.getOrCreate(destination, name, occurrence);
                }
                Object v = source.getValue();
                Unit<?> unit = source.getUnit();
                if (unit == null) {
                    target.setValue(v);
                } else if (v instanceof Number) {
                    target.setValue(((Number)v).doubleValue(), unit);
                } else if (v instanceof double[]) {
                    target.setValue((double[])v, unit);
                } else if (v != target.getValue()) {
                    throw new InvalidParameterValueException(Errors.format((short)31, name, v), name, v);
                }
            }
            occurrences.put(name, occurrence + 1);
        }
    }

    private static GeneralParameterValue getOrCreate(ParameterValueGroup values, String name, int n) {
        for (GeneralParameterValue value : values.values()) {
            if (!name.equals(value.getDescriptor().getName().getCode()) || --n >= 0) continue;
            return value;
        }
        if (n == 0) {
            GeneralParameterValue value = values.getDescriptor().descriptor(name).createValue();
            values.values().add(value);
            return value;
        }
        throw new IndexOutOfBoundsException(name);
    }

    public String toString() {
        return ParameterFormat.sharedFormat(this);
    }

    public void print() {
        ParameterFormat.print(this);
    }

    private static final class Wrapper
    extends Parameters
    implements Serializable {
        private static final long serialVersionUID = -5491790565456920471L;
        private final ParameterValueGroup delegate;

        Wrapper(ParameterValueGroup delegate) {
            this.delegate = delegate;
        }

        @Override
        public ParameterDescriptorGroup getDescriptor() {
            return this.delegate.getDescriptor();
        }

        @Override
        public List<GeneralParameterValue> values() {
            return this.delegate.values();
        }

        @Override
        public ParameterValue<?> parameter(String name) {
            return this.delegate.parameter(name);
        }

        @Override
        public List<ParameterValueGroup> groups(String name) {
            return this.delegate.groups(name);
        }

        @Override
        public ParameterValueGroup addGroup(String name) {
            return this.delegate.addGroup(name);
        }

        @Override
        public Parameters clone() {
            return new Wrapper(this.delegate.clone());
        }
    }
}

