/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

@XmlTransient
final class TensorValues<E>
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup,
ParameterValueGroup,
Cloneable {
    private static final long serialVersionUID = -7747712999115044943L;
    private final TensorParameters<E> descriptors;
    private final ParameterValue<Integer>[] dimensions;
    private Object[] values;

    TensorValues(Map<String, ?> properties, TensorParameters<E> descriptors) {
        super(properties, 1, 1);
        this.descriptors = descriptors;
        this.dimensions = new ParameterValue[descriptors.rank()];
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = descriptors.getDimensionDescriptor(i).createValue();
        }
    }

    TensorValues(TensorValues<E> other, boolean clone) {
        super(other);
        this.descriptors = other.descriptors;
        this.dimensions = (ParameterValue[])other.dimensions.clone();
        for (int i = 0; i < this.dimensions.length; ++i) {
            ParameterValue<Integer> dim = this.dimensions[i];
            this.dimensions[i] = clone ? dim.clone() : dim.getDescriptor().createValue();
        }
        if (clone) {
            this.values = TensorValues.clone(other.values);
        }
    }

    private static Object[] clone(Object[] values) {
        if (values != null) {
            values = (Object[])values.clone();
            for (int i = 0; i < values.length; ++i) {
                Object element = values[i];
                element = element instanceof GeneralParameterValue ? ((GeneralParameterValue)element).clone() : TensorValues.clone(element);
                values[i] = element;
            }
        }
        return values;
    }

    @Override
    public ParameterValueGroup clone() {
        return new TensorValues<E>(this, true);
    }

    @Override
    public ParameterValueGroup createValue() {
        return new TensorValues<E>(this, false);
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return this;
    }

    @Override
    public List<GeneralParameterDescriptor> descriptors() {
        return UnmodifiableArrayList.wrap(this.descriptors.getAllDescriptors(this.size()));
    }

    private int[] size() {
        int[] indices = new int[this.dimensions.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.dimensions[i].intValue();
        }
        return indices;
    }

    @Override
    public GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        name = CharSequences.trimWhitespaces(name);
        ArgumentChecks.ensureNonEmpty("name", name);
        return this.descriptors.descriptor(this, name, this.size());
    }

    @Override
    public ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        int[] actualSize;
        name = CharSequences.trimWhitespaces(name);
        ArgumentChecks.ensureNonEmpty("name", name);
        IllegalArgumentException cause = null;
        int[] indices = null;
        try {
            indices = this.descriptors.nameToIndices(name);
        }
        catch (IllegalArgumentException exception) {
            cause = exception;
        }
        if (indices != null && TensorParameters.isInBounds(indices, actualSize = this.size())) {
            return this.parameter(indices, actualSize);
        }
        int rank = this.descriptors.rank();
        for (int i = 0; i < rank; ++i) {
            ParameterDescriptor<Integer> param = this.descriptors.getDimensionDescriptor(i);
            if (!IdentifiedObjects.isHeuristicMatchForName(param, name)) continue;
            return this.dimensions[i];
        }
        throw (ParameterNotFoundException)new ParameterNotFoundException(Errors.format((short)147, this.getName(), name), name).initCause(cause);
    }

    private ParameterValue<E> parameter(int[] indices, int[] actualSize) {
        int rank = this.dimensions.length;
        if (indices.length != rank) {
            throw new IllegalArgumentException(Errors.format((short)107, rank, indices.length));
        }
        Object parent = null;
        Object element = this.values;
        for (int i = 0; i < rank; ++i) {
            if (element == null) {
                Class<?> componentType = Classes.changeArrayDimension(ParameterValue.class, rank - i - 1);
                element = Array.newInstance(componentType, actualSize[i]);
                if (parent != null) {
                    parent[indices[i - 1]] = element;
                } else {
                    this.values = element;
                }
            } else if (((Object[])element).length <= indices[i]) {
                parent[indices[i - 1]] = element = Arrays.copyOf(element, actualSize[i]);
            }
            parent = element;
            element = parent[indices[i]];
        }
        if (element == null) {
            parent[indices[rank - 1]] = element = this.descriptors.getElementDescriptor(indices).createValue();
        }
        return Parameters.cast((ParameterValue)element, this.descriptors.getElementType());
    }

    @Override
    public List<GeneralParameterValue> values() {
        ArrayList<GeneralParameterValue> addTo = new ArrayList<GeneralParameterValue>();
        for (ParameterValue<Integer> dimension : this.dimensions) {
            if (TensorValues.isOmitted(dimension)) continue;
            addTo.add(dimension);
        }
        TensorValues.addValues(this.values, this.size(), 0, addTo);
        return Collections.unmodifiableList(addTo);
    }

    private static void addValues(Object[] values, int[] actualSize, int j, List<GeneralParameterValue> addTo) {
        block4: {
            if (values == null) break block4;
            int length = Math.min(values.length, actualSize[j]);
            if (++j != actualSize.length) {
                for (int i = 0; i < length; ++i) {
                    TensorValues.addValues((Object[])values[i], actualSize, j, addTo);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    ParameterValue parameter = (ParameterValue)values[i];
                    if (parameter == null || TensorValues.isOmitted(parameter)) continue;
                    addTo.add(parameter);
                }
            }
        }
    }

    private static boolean isOmitted(ParameterValue<?> parameter) {
        Object value = parameter.getValue();
        if (value == null) {
            return true;
        }
        ParameterDescriptor<?> descriptor = parameter.getDescriptor();
        return descriptor.getMinimumOccurs() == 0 && value.equals(descriptor.getDefaultValue());
    }

    @Override
    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        throw new ParameterNotFoundException(Errors.format((short)147, this.getName(), name), name);
    }

    @Override
    public ParameterValueGroup addGroup(String name) throws ParameterNotFoundException, IllegalStateException {
        throw new ParameterNotFoundException(Errors.format((short)147, this.getName(), name), name);
    }

    final Matrix toMatrix() {
        int numRow = this.dimensions[0].intValue();
        int numCol = this.dimensions[1].intValue();
        MatrixSIS matrix = Matrices.createDiagonal(numRow, numCol);
        if (this.values != null) {
            for (int j = 0; j < numRow; ++j) {
                ParameterValue[] row = (ParameterValue[])this.values[j];
                if (row == null) continue;
                for (int i = 0; i < numCol; ++i) {
                    ParameterValue element = row[i];
                    if (element == null) continue;
                    matrix.setElement(j, i, element.doubleValue());
                }
            }
        }
        return matrix;
    }

    final void setMatrix(Matrix matrix) {
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        this.dimensions[0].setValue(numRow);
        this.dimensions[1].setValue(numCol);
        this.values = null;
        int[] indices = new int[2];
        for (int j = 0; j < numRow; ++j) {
            indices[0] = j;
            ParameterValue[] row = null;
            for (int i = 0; i < numCol; ++i) {
                indices[1] = i;
                ParameterDescriptor<E> descriptor = this.descriptors.getElementDescriptor(indices);
                E def = descriptor.getDefaultValue();
                double element = matrix.getElement(j, i);
                if (def instanceof Number && Numerics.equalsIgnoreZeroSign(element, ((Number)def).doubleValue())) continue;
                ParameterValue<E> value = descriptor.createValue();
                value.setValue(element);
                if (row == null) {
                    row = new ParameterValue[numCol];
                    if (this.values == null) {
                        this.values = new ParameterValue[numRow][];
                    }
                    this.values[j] = row;
                }
                row[i] = value;
            }
        }
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            TensorValues that = (TensorValues)object;
            return Utilities.deepEquals(this.descriptors, that.descriptors, mode) && Utilities.deepEquals(this.values(), that.values(), mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.descriptors.hashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendParamMT(this, formatter);
        return "ParameterGroup";
    }
}

