/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.apache.sis.internal.referencing.EPSGParameterDomain;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceIdentifier;

final class Verifier {
    private final short errorKey;
    private final boolean needsValue;
    private final Object[] arguments;

    private Verifier(short errorKey, boolean needsValue, Object ... arguments) {
        this.errorKey = errorKey;
        this.needsValue = needsValue;
        this.arguments = arguments;
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> descriptor, Object value, Unit<?> unit) throws InvalidParameterValueException {
        Class<T> valueClass = descriptor.getValueClass();
        UnitConverter converter = null;
        Object convertedValue = value;
        if (unit != null) {
            Unit<?> def = descriptor.getUnit();
            if (def == null && (def = Verifier.getCompatibleUnit(Parameters.getValueDomain(descriptor), unit)) == null) {
                String name = Verifier.getDisplayName(descriptor);
                throw new InvalidParameterValueException(Errors.format((short)139, name), name, unit);
            }
            if (!unit.equals(def)) {
                short expectedID = Verifier.getUnitMessageID(def);
                if (Verifier.getUnitMessageID(unit) != expectedID) {
                    throw new IllegalArgumentException(Errors.format(expectedID, unit));
                }
                if (value != null) {
                    if (!valueClass.isInstance(value)) {
                        String name = Verifier.getDisplayName(descriptor);
                        throw new InvalidParameterValueException(Errors.format((short)138, name, valueClass, value.getClass()), name, value);
                    }
                    try {
                        converter = unit.getConverterToAny(def);
                    }
                    catch (ConversionException e) {
                        throw new IllegalArgumentException(Errors.format((short)46, unit, def), e);
                    }
                    Class<?> componentType = valueClass.getComponentType();
                    if (componentType == null) {
                        Double n = converter.convert(((Number)value).doubleValue());
                        try {
                            convertedValue = Numbers.cast(n, valueClass.asSubclass(Number.class));
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidParameterValueException(e.getLocalizedMessage(), Verifier.getDisplayName(descriptor), value);
                        }
                    }
                    int length = Array.getLength(value);
                    convertedValue = Array.newInstance(componentType, length);
                    componentType = Numbers.primitiveToWrapper(componentType);
                    for (int i = 0; i < length; ++i) {
                        Number n = (Number)Array.get(value, i);
                        n = converter.convert(n.doubleValue());
                        try {
                            n = Numbers.cast(n, componentType.asSubclass(Number.class));
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidParameterValueException(e.getLocalizedMessage(), Verifier.getDisplayName(descriptor) + '[' + i + ']', value);
                        }
                        Array.set(convertedValue, i, n);
                    }
                }
            }
        }
        if (convertedValue != null) {
            Set<T> validValues = descriptor.getValidValues();
            Verifier error = descriptor instanceof DefaultParameterDescriptor ? Verifier.ensureValidValue(valueClass, validValues, ((DefaultParameterDescriptor)descriptor).getValueDomain(), convertedValue) : Verifier.ensureValidValue(valueClass, validValues, descriptor.getMinimumValue(), descriptor.getMaximumValue(), convertedValue);
            if (error != null) {
                error.convertRange(converter);
                String name = Verifier.getDisplayName(descriptor);
                String message = error.message(null, name, value);
                if (!Semaphores.query((byte)8)) {
                    throw new InvalidParameterValueException(message, name, value);
                }
                LogRecord record = new LogRecord(Level.WARNING, message);
                record.setLoggerName("org.apache.sis.referencing.operation");
                Logging.log(DefaultParameterValue.class, "setValue", record);
            }
        }
        return valueClass.cast(convertedValue);
    }

    static <T> Verifier ensureValidValue(Class<T> valueClass, Set<T> validValues, Range<?> valueDomain, Object convertedValue) {
        Verifier verifier = Verifier.ensureValidValue(valueClass, validValues, null, null, convertedValue);
        if (verifier == null && valueDomain != null) {
            if (!valueClass.isArray()) {
                assert (valueDomain.getElementType() == valueClass) : valueDomain;
                if (!valueDomain.contains((Comparable)convertedValue)) {
                    return new Verifier(133, true, null, valueDomain.getMinValue(), valueDomain.getMaxValue(), convertedValue);
                }
            } else {
                assert (valueDomain.getElementType() == Numbers.primitiveToWrapper(valueClass.getComponentType())) : valueDomain;
                int length = Array.getLength(convertedValue);
                for (int i = 0; i < length; ++i) {
                    Object e = Array.get(convertedValue, i);
                    if (valueDomain.contains((Comparable)e)) continue;
                    return new Verifier(133, true, i, valueDomain.getMinValue(), valueDomain.getMaxValue(), e);
                }
            }
        }
        return verifier;
    }

    private static <T> Verifier ensureValidValue(Class<T> valueClass, Set<T> validValues, Comparable<T> minimum, Comparable<T> maximum, Object convertedValue) {
        if (!valueClass.isInstance(convertedValue)) {
            return new Verifier(138, false, null, valueClass, convertedValue.getClass());
        }
        if (validValues != null && !validValues.contains(convertedValue)) {
            return new Verifier(144, true, null, convertedValue);
        }
        if (minimum != null && minimum.compareTo(convertedValue) > 0 || maximum != null && maximum.compareTo(convertedValue) < 0) {
            return new Verifier(133, true, null, minimum, maximum, convertedValue);
        }
        return null;
    }

    private void convertRange(UnitConverter converter) {
        if (converter != null && this.errorKey == 133) {
            converter = converter.inverse();
            Object minimumValue = this.arguments[1];
            Object maximumValue = this.arguments[2];
            minimumValue = minimumValue != null ? Double.valueOf(converter.convert(((Number)minimumValue).doubleValue())) : "-\u221e";
            maximumValue = maximumValue != null ? Double.valueOf(converter.convert(((Number)maximumValue).doubleValue())) : "\u221e";
            this.arguments[1] = minimumValue;
            this.arguments[2] = maximumValue;
        }
    }

    private static Unit<?> getCompatibleUnit(Range<?> valueDomain, Unit<?> unit) {
        if (valueDomain instanceof EPSGParameterDomain) {
            for (Unit<?> valid : ((EPSGParameterDomain)valueDomain).units) {
                if (!unit.isCompatible(valid)) continue;
                return valid;
            }
        }
        return null;
    }

    String message(Map<?, ?> properties, String name, Object value) {
        Object index = this.arguments[0];
        if (index != null) {
            name = name + '[' + index + ']';
            value = Array.get(value, (Integer)index);
        }
        this.arguments[0] = name;
        if (this.needsValue) {
            this.arguments[this.arguments.length - 1] = value;
        }
        return Errors.getResources(properties).getString(this.errorKey, this.arguments);
    }

    static String getDisplayName(GeneralParameterDescriptor descriptor) {
        String code;
        ReferenceIdentifier name;
        if (descriptor != null && (name = descriptor.getName()) != null && (code = name.getCode()) != null) {
            return code;
        }
        return Vocabulary.format((short)65);
    }

    static short getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 84;
        }
        if (Units.isAngular(unit)) {
            return 78;
        }
        if (Units.isTemporal(unit)) {
            return 87;
        }
        if (Units.isScale(unit)) {
            return 86;
        }
        return 140;
    }
}

