/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.referencing.Code;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.referencing.NameIterator;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.PropertiesConverter;
import org.apache.sis.referencing.SubTypes;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

@XmlType(name="IdentifiedObjectType", propOrder={"description", "identifier", "names", "remarks"})
@XmlSeeAlso(value={AbstractCRS.class, AbstractDatum.class, DefaultEllipsoid.class, DefaultPrimeMeridian.class, AbstractCS.class})
public class AbstractIdentifiedObject
extends FormattableObject
implements IdentifiedObject,
LenientComparable,
Deprecable,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    public static final String LOCALE_KEY = "locale";
    public static final String DEPRECATED_KEY = "deprecated";
    private ReferenceIdentifier name;
    private Collection<GenericName> alias;
    private Set<ReferenceIdentifier> identifiers;
    private InternationalString remarks;
    private final boolean deprecated;
    private transient int hashCode;

    public AbstractIdentifiedObject(Map<String, ?> properties) throws IllegalArgumentException {
        GenericName[] names;
        ArgumentChecks.ensureNonNull("properties", properties);
        Object value = properties.get("name");
        if (value == null || value instanceof String) {
            if (value == null && properties.get("code") == null) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)64, "name"));
            }
            this.name = new NamedIdentifier(PropertiesConverter.convert(properties));
        } else if (value instanceof ReferenceIdentifier) {
            this.name = (ReferenceIdentifier)value;
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, "name", value);
        }
        value = properties.get("alias");
        try {
            DefaultNameFactory factory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
            names = factory.toGenericNames(value);
        }
        catch (ClassCastException e) {
            throw (IllegalArgumentException)AbstractIdentifiedObject.illegalPropertyType(properties, "alias", value).initCause(e);
        }
        this.alias = CollectionsExt.immutableSet(true, names);
        value = properties.get("identifiers");
        if (value == null) {
            this.identifiers = null;
        } else if (value instanceof ReferenceIdentifier) {
            this.identifiers = Collections.singleton((ReferenceIdentifier)value);
        } else if (value instanceof ReferenceIdentifier[]) {
            this.identifiers = CollectionsExt.immutableSet(true, (ReferenceIdentifier[])value);
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, "identifiers", value);
        }
        this.remarks = Types.toInternationalString(properties, "remarks");
        value = properties.get(DEPRECATED_KEY);
        if (value == null) {
            this.deprecated = false;
        } else if (value instanceof Boolean) {
            this.deprecated = (Boolean)value;
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, DEPRECATED_KEY, value);
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> properties, String key, Object value) {
        return new IllegalArgumentException(Errors.getResources(properties).getString((short)40, key, value.getClass()));
    }

    protected AbstractIdentifiedObject(IdentifiedObject object) {
        ArgumentChecks.ensureNonNull("object", object);
        this.name = object.getName();
        this.alias = CollectionsExt.nonEmpty(object.getAlias());
        this.identifiers = CollectionsExt.nonEmpty(object.getIdentifiers());
        this.remarks = object.getRemarks();
        this.deprecated = object instanceof Deprecable ? ((Deprecable)((Object)object)).isDeprecated() : false;
    }

    public static AbstractIdentifiedObject castOrCopy(IdentifiedObject object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends IdentifiedObject> getInterface() {
        return IdentifiedObject.class;
    }

    @Override
    public ReferenceIdentifier getName() {
        return this.name;
    }

    @Override
    public Collection<GenericName> getAlias() {
        return CollectionsExt.nonNull(this.alias);
    }

    @Override
    public Set<ReferenceIdentifier> getIdentifiers() {
        return CollectionsExt.nonNull(this.identifiers);
    }

    @XmlElement(name="description")
    public InternationalString getDescription() {
        ReferenceIdentifier name = this.getName();
        if (name instanceof ImmutableIdentifier) {
            return ((ImmutableIdentifier)name).getDescription();
        }
        if (name instanceof DefaultIdentifier) {
            return ((DefaultIdentifier)((Object)name)).getDescription();
        }
        return null;
    }

    @Override
    @XmlElement(name="remarks")
    public InternationalString getRemarks() {
        return this.remarks;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isHeuristicMatchForName(String name) {
        return NameToIdentifier.isHeuristicMatchForName(this.name, this.alias, name, NameToIdentifier.Simplifier.DEFAULT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == null) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                int oc;
                int tc;
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                AbstractIdentifiedObject that = (AbstractIdentifiedObject)object;
                if (mode == ComparisonMode.STRICT && (tc = this.hashCode) != 0 && (oc = that.hashCode) != 0 && tc != oc) {
                    return false;
                }
                return Objects.equals(this.name, that.name) && CollectionsExt.nonNull(this.alias).equals(CollectionsExt.nonNull(that.alias)) && CollectionsExt.nonNull(this.identifiers).equals(CollectionsExt.nonNull(that.identifiers)) && Objects.equals(this.remarks, that.remarks);
            }
            case BY_CONTRACT: {
                if (!this.implementsSameInterface(object)) {
                    return false;
                }
                IdentifiedObject that = (IdentifiedObject)object;
                return Utilities.deepEquals(this.getName(), that.getName(), mode) && Utilities.deepEquals(this.getAlias(), that.getAlias(), mode) && Utilities.deepEquals(this.getIdentifiers(), that.getIdentifiers(), mode) && Utilities.deepEquals(this.getRemarks(), that.getRemarks(), mode);
            }
            case IGNORE_METADATA: 
            case APPROXIMATIVE: 
            case ALLOW_VARIANT: 
            case DEBUG: {
                return this.implementsSameInterface(object);
            }
        }
        throw new IllegalArgumentException(Errors.format((short)114, ComparisonMode.class, (Object)mode));
    }

    private boolean implementsSameInterface(Object object) {
        Class<? extends IdentifiedObject>[] t;
        Class<? extends IdentifiedObject> type = this.getInterface();
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).getInterface() == type;
        }
        return type.isInstance(object) && (t = Classes.getLeafInterfaces(object.getClass(), type)).length == 1 && t[0] == type;
    }

    @Override
    public final boolean equals(Object object) {
        boolean eq = this.equals(object, ComparisonMode.STRICT);
        assert (!eq || this.hashCode() == object.hashCode()) : this;
        return eq;
    }

    public final int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = Numerics.hashCode(this.computeHashCode());
            if (hash == 0) {
                hash = -1;
            }
            this.hashCode = hash;
        }
        assert (hash == -1 || hash == Numerics.hashCode(this.computeHashCode())) : hash;
        return hash;
    }

    protected long computeHashCode() {
        return Objects.hash(this.name, CollectionsExt.nonNull(this.alias), CollectionsExt.nonNull(this.identifiers), this.remarks) ^ this.getInterface().hashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName(this, formatter, ElementKind.forType(this.getClass()));
        return null;
    }

    AbstractIdentifiedObject() {
        this.deprecated = false;
    }

    @XmlID
    @XmlSchemaType(name="ID")
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml/3.2", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    final String getID() {
        return NameIterator.getID(Context.current(), this, this.name, this.alias, this.identifiers);
    }

    private void setID(String id) {
        Context context = Context.current();
        if (!Context.setObjectForID(context, this, id)) {
            Context.warningOccured(context, this.getClass(), "setID", Errors.class, (short)17, id);
        }
    }

    @XmlElement(required=true)
    final Code getIdentifier() {
        return Code.forIdentifiedObject(this.getClass(), this.identifiers);
    }

    private void setIdentifier(Code identifier) {
        if (this.identifiers == null) {
            ReferenceIdentifier id;
            if (identifier != null && (id = identifier.getIdentifier()) != null) {
                this.identifiers = Collections.singleton(id);
            }
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractIdentifiedObject.class, "setIdentifier", "identifier");
        }
    }

    @XmlElement(name="name", required=true)
    final Collection<ReferenceIdentifier> getNames() {
        return new Names();
    }

    private void setRemarks(InternationalString value) {
        if (this.remarks == null) {
            this.remarks = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractIdentifiedObject.class, "setRemarks", "remarks");
        }
    }

    private final class Names
    extends AbstractCollection<ReferenceIdentifier> {
        private Names() {
        }

        @Override
        public void clear() {
        }

        @Override
        public int size() {
            return NameIterator.count(AbstractIdentifiedObject.this);
        }

        @Override
        public Iterator<ReferenceIdentifier> iterator() {
            return new NameIterator(AbstractIdentifiedObject.this);
        }

        @Override
        public boolean add(ReferenceIdentifier id) {
            if (NameIterator.isUnnamed(AbstractIdentifiedObject.this.name)) {
                AbstractIdentifiedObject.this.name = id;
            } else {
                GenericName n;
                GenericName genericName = n = id instanceof GenericName ? (GenericName)((Object)id) : new NamedIdentifier(id);
                if (AbstractIdentifiedObject.this.alias == null) {
                    AbstractIdentifiedObject.this.alias = Collections.singleton(n);
                } else {
                    int size = AbstractIdentifiedObject.this.alias.size();
                    GenericName[] names = AbstractIdentifiedObject.this.alias.toArray(new GenericName[size + 1]);
                    names[size] = n;
                    AbstractIdentifiedObject.this.alias = UnmodifiableArrayList.wrap(names);
                }
            }
            return true;
        }
    }
}

