/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.metadata.EX_Extent;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@XmlTransient
public class AbstractReferenceSystem
extends AbstractIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 3337659819553899435L;
    private Extent domainOfValidity;
    private InternationalString scope;

    public AbstractReferenceSystem(Map<String, ?> properties) {
        super(properties);
        this.domainOfValidity = Containers.property(properties, "domainOfValidity", Extent.class);
        this.scope = Types.toInternationalString(properties, "scope");
    }

    protected AbstractReferenceSystem(ReferenceSystem object) {
        super(object);
        this.domainOfValidity = object.getDomainOfValidity();
        this.scope = object.getScope();
    }

    public Class<? extends ReferenceSystem> getInterface() {
        return ReferenceSystem.class;
    }

    @Override
    @XmlElement(name="domainOfValidity")
    @XmlJavaTypeAdapter(value=EX_Extent.class)
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    @XmlElement(name="scope", required=true)
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                AbstractReferenceSystem that = (AbstractReferenceSystem)object;
                return Objects.equals(this.domainOfValidity, that.domainOfValidity) && Objects.equals(this.scope, that.scope);
            }
            case BY_CONTRACT: {
                ReferenceSystem that = (ReferenceSystem)object;
                return Utilities.deepEquals(this.getDomainOfValidity(), that.getDomainOfValidity(), mode) && Utilities.deepEquals(this.getScope(), that.getScope(), mode);
            }
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.domainOfValidity, this.scope);
    }

    AbstractReferenceSystem() {
    }

    private void setDomainOfValidity(Extent value) {
        if (this.domainOfValidity == null) {
            this.domainOfValidity = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractReferenceSystem.class, "setDomainOfValidity", "domainOfValidity");
        }
    }

    private void setScope(InternationalString value) {
        if (this.scope == null) {
            this.scope = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractReferenceSystem.class, "setScope", "scope");
        }
    }
}

