/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.sql.SQLTransientException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.LazySet;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.EPSGFactoryFallback;
import org.apache.sis.referencing.factory.MultiAuthoritiesFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

final class AuthorityFactories<T extends AuthorityFactory>
extends LazySet<T> {
    private static final AuthorityFactory[] EPSG = new AuthorityFactory[1];
    static final MultiAuthoritiesFactory ALL = new MultiAuthoritiesFactory(new AuthorityFactories<CRSAuthorityFactory>(CRSAuthorityFactory.class), new AuthorityFactories<CSAuthorityFactory>(CSAuthorityFactory.class), new AuthorityFactories<DatumAuthorityFactory>(DatumAuthorityFactory.class), new AuthorityFactories<CoordinateOperationAuthorityFactory>(CoordinateOperationAuthorityFactory.class)){
        {
            this.setLenient(true);
        }

        @Override
        public void reload() {
            AuthorityFactories.EPSG(null);
            super.reload();
        }
    };

    private AuthorityFactories(Class<T> type) {
        super(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void EPSG(AuthorityFactory factory) {
        AuthorityFactory[] authorityFactoryArray = EPSG;
        synchronized (EPSG) {
            AuthorityFactories.EPSG[0] = factory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AuthorityFactory EPSG() {
        AuthorityFactory[] authorityFactoryArray = EPSG;
        synchronized (EPSG) {
            AuthorityFactory factory = EPSG[0];
            if (factory == null) {
                try {
                    factory = new EPSGFactory(null);
                }
                catch (FactoryException e) {
                    AuthorityFactories.log(e, false);
                    factory = EPSGFactoryFallback.INSTANCE;
                }
            }
            AuthorityFactories.EPSG[0] = factory;
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CRSAuthorityFactory fallback(UnavailableFactoryException e) throws UnavailableFactoryException {
        boolean isTransient = e.getCause() instanceof SQLTransientException;
        AuthorityFactory unavailable = e.getUnavailableFactory();
        AuthorityFactory[] authorityFactoryArray = EPSG;
        synchronized (EPSG) {
            if (unavailable != EPSG[0]) {
                throw e;
            }
            CRSAuthorityFactory factory = EPSGFactoryFallback.INSTANCE;
            if (!isTransient) {
                ALL.reload();
                AuthorityFactories.EPSG[0] = factory;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            AuthorityFactories.log(e, true);
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean failure(UnavailableFactoryException e) {
        if (e.getCause() instanceof SQLTransientException) return false;
        AuthorityFactory unavailable = e.getUnavailableFactory();
        AuthorityFactory[] authorityFactoryArray = EPSG;
        synchronized (EPSG) {
            if (unavailable != EPSG[0]) return false;
            ALL.reload();
            AuthorityFactories.EPSG[0] = EPSGFactoryFallback.INSTANCE;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    private static void log(Exception e, boolean isWarning) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            message = e.toString();
        }
        LogRecord record = new LogRecord(isWarning ? Level.WARNING : Level.CONFIG, message);
        record.setLoggerName("org.apache.sis.referencing.factory");
        if (isWarning) {
            record.setThrown(e);
        }
        Logging.log(CRS.class, "getAuthorityFactory", record);
    }

    @Override
    protected T[] initialValues() {
        AuthorityFactories.EPSG();
        return EPSG;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.referencing"){

            @Override
            protected void classpathChanged() {
                ALL.reload();
            }
        });
    }
}

