/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.referencing.DeprecatedCode;
import org.apache.sis.internal.referencing.DeprecatedName;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public abstract class Builder<B extends Builder<B>> {
    protected final Map<String, Object> properties;
    private final List<GenericName> aliases;
    private final List<ReferenceIdentifier> identifiers;
    private transient NameSpace namespace;
    private transient NameFactory nameFactory;

    protected Builder() {
        assert (Builder.verifyParameterizedType(this.getClass()));
        this.properties = new HashMap<String, Object>(8);
        this.aliases = new ArrayList<GenericName>();
        this.identifiers = new ArrayList<ReferenceIdentifier>();
    }

    private static boolean verifyParameterizedType(Class<?> expected) {
        for (Class<?> c = expected; c != null; c = c.getSuperclass()) {
            ParameterizedType p;
            Type type = c.getGenericSuperclass();
            if (!(type instanceof ParameterizedType) || (p = (ParameterizedType)type).getRawType() != Builder.class) continue;
            type = p.getActualTypeArguments()[0];
            if (type == expected) {
                return true;
            }
            throw new AssertionError(type);
        }
        return false;
    }

    private B self() {
        return (B)this;
    }

    protected Builder(IdentifiedObject object) {
        this();
        if (object != null) {
            this.properties.putAll(IdentifiedObjects.getProperties(object, new String[0]));
            GenericName[] valueAlias = (GenericName[])this.properties.remove("alias");
            ReferenceIdentifier[] valueIds = (ReferenceIdentifier[])this.properties.remove("identifiers");
            if (valueAlias != null) {
                this.aliases.addAll(Arrays.asList(valueAlias));
            }
            if (valueIds != null) {
                this.identifiers.addAll(Arrays.asList(valueIds));
            }
        }
    }

    private NameFactory factory() {
        if (this.nameFactory == null) {
            this.nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        }
        return this.nameFactory;
    }

    private GenericName createName(CharSequence name) {
        String codespace;
        NameFactory factory = this.factory();
        if (this.namespace == null && (codespace = this.getCodeSpace()) != null) {
            this.namespace = factory.createNameSpace(factory.createLocalName(null, codespace), null);
        }
        return factory.createLocalName(this.namespace, name);
    }

    private GenericName createName(Citation authority, CharSequence name) {
        if (authority == this.getAuthority()) {
            return this.createName(name);
        }
        return new NamedIdentifier(authority, name);
    }

    private static ReferenceIdentifier toIdentifier(GenericName name) {
        return name instanceof ReferenceIdentifier ? (ReferenceIdentifier)((Object)name) : new NamedIdentifier(name);
    }

    private boolean setProperty(String key, Object value) throws IllegalStateException {
        Object previous = JDK8.putIfAbsent(this.properties, key, value);
        if (previous != null) {
            if (previous.equals(value)) {
                return false;
            }
            if (this.properties.get("name") != null) {
                throw new IllegalStateException(Errors.getResources(this.properties).getString((short)131, key));
            }
            this.properties.put(key, value);
        }
        return true;
    }

    private Citation getAuthority() {
        return (Citation)this.properties.get("authority");
    }

    private String getCodeSpace() {
        return (String)this.properties.get("codespace");
    }

    public B setCodeSpace(Citation authority, String codespace) {
        if (!this.setProperty("codespace", codespace)) {
            this.namespace = null;
        }
        this.setProperty("authority", authority);
        return this.self();
    }

    private String getVersion() {
        return (String)this.properties.get("version");
    }

    public B setVersion(String version) {
        this.setProperty("version", version);
        return this.self();
    }

    public B addName(CharSequence name) {
        ArgumentChecks.ensureNonNull("name", name);
        if (this.isDeprecated()) {
            this.aliases.add(new DeprecatedName(this.getAuthority(), this.getCodeSpace(), name, this.getVersion(), this.getRemarks()));
        } else if (JDK8.putIfAbsent(this.properties, "name", name.toString()) != null) {
            this.aliases.add(this.createName(name));
        }
        return this.self();
    }

    public B addName(Citation authority, CharSequence name) {
        ArgumentChecks.ensureNonNull("name", name);
        boolean isDeprecated = this.isDeprecated();
        if (!isDeprecated && this.properties.get("name") != null) {
            this.aliases.add(this.createName(authority, name));
        } else {
            String version;
            String codeSpace;
            if (authority == this.getAuthority()) {
                codeSpace = this.getCodeSpace();
                version = this.getVersion();
            } else {
                codeSpace = Citations.getCodeSpace(authority);
                version = null;
            }
            if (isDeprecated) {
                this.aliases.add(new DeprecatedName(authority, codeSpace, name, version, this.getRemarks()));
            } else {
                this.properties.put("name", new NamedIdentifier(authority, codeSpace, name, version, this.getDescription()));
            }
        }
        return this.self();
    }

    public B addName(ReferenceIdentifier name) {
        ArgumentChecks.ensureNonNull("name", name);
        if (JDK8.putIfAbsent(this.properties, "name", name) != null) {
            this.aliases.add(name instanceof GenericName ? (GenericName)((Object)name) : new NamedIdentifier(name));
        }
        return this.self();
    }

    public B addName(GenericName name) {
        ArgumentChecks.ensureNonNull("name", name);
        if (this.properties.get("name") == null) {
            this.properties.put("name", Builder.toIdentifier(name));
        } else {
            this.aliases.add(name);
        }
        return this.self();
    }

    public B addIdentifier(String identifier) {
        ArgumentChecks.ensureNonNull("identifier", identifier);
        this.addIdentifier(this.getAuthority(), this.getCodeSpace(), identifier, this.getVersion());
        return this.self();
    }

    public B addIdentifier(Citation authority, String identifier) {
        String version;
        String codeSpace;
        ArgumentChecks.ensureNonNull("identifier", identifier);
        if (authority == this.getAuthority()) {
            codeSpace = this.getCodeSpace();
            version = this.getVersion();
        } else {
            codeSpace = Citations.getCodeSpace(authority);
            version = null;
        }
        this.addIdentifier(authority, codeSpace, identifier, version);
        return this.self();
    }

    private void addIdentifier(Citation authority, String codeSpace, String identifier, String version) {
        ImmutableIdentifier id = this.isDeprecated() ? new DeprecatedCode(authority, codeSpace, identifier, version, null, this.getRemarks()) : new ImmutableIdentifier(authority, codeSpace, identifier, version, this.getDescription());
        this.identifiers.add(id);
    }

    public B addIdentifier(ReferenceIdentifier identifier) {
        ArgumentChecks.ensureNonNull("identifier", identifier);
        this.identifiers.add(identifier);
        return this.self();
    }

    private static boolean isDeprecated(Object object) {
        return object instanceof Deprecable && ((Deprecable)object).isDeprecated();
    }

    public B addNamesAndIdentifiers(IdentifiedObject object) {
        ArgumentChecks.ensureNonNull("object", object);
        for (ReferenceIdentifier id : object.getIdentifiers()) {
            if (Builder.isDeprecated(id)) continue;
            this.addIdentifier(id);
        }
        ReferenceIdentifier id = object.getName();
        if (!Builder.isDeprecated(id)) {
            this.addName(id);
        }
        for (GenericName alias : object.getAlias()) {
            if (Builder.isDeprecated(alias)) continue;
            this.addName(alias);
        }
        return this.self();
    }

    public B rename(Citation authority, CharSequence ... replacements) {
        ArgumentChecks.ensureNonNull("authority", authority);
        int length = replacements != null ? replacements.length : 0;
        int next = 0;
        int insertAt = this.aliases.size();
        for (int i = -1; i < this.aliases.size(); ++i) {
            boolean wasID;
            Object old;
            Object object = old = i < 0 ? this.properties.get("name") : this.aliases.get(i);
            if (old == null || !authority.equals((wasID = old instanceof Identifier) ? ((Identifier)old).getAuthority() : this.getAuthority())) continue;
            if (next < length) {
                int n = next;
                CharSequence name = replacements[next++];
                ArgumentChecks.ensureNonNullElement("replacements", n, name);
                String code = name.toString();
                if (code.equals(wasID ? ((Identifier)old).getCode() : old.toString())) continue;
                if (i < 0) {
                    this.properties.put("name", authority != this.getAuthority() ? new NamedIdentifier(authority, name) : code);
                } else {
                    this.aliases.set(i, this.createName(authority, name));
                }
                insertAt = i + 1;
                continue;
            }
            if (i < 0) {
                this.properties.remove("name");
                continue;
            }
            this.aliases.remove(i--);
        }
        while (next < length) {
            int n = next;
            CharSequence name = replacements[next++];
            ArgumentChecks.ensureNonNullElement("replacements", n, name);
            this.aliases.add(insertAt++, this.createName(authority, name));
        }
        if (this.properties.get("name") == null && !this.aliases.isEmpty()) {
            this.properties.put("name", Builder.toIdentifier(this.aliases.remove(0)));
        }
        return this.self();
    }

    private InternationalString getDescription() {
        return (InternationalString)this.properties.get("description");
    }

    public B setDescription(CharSequence description) {
        this.properties.put("description", Types.toInternationalString(description));
        return this.self();
    }

    private InternationalString getRemarks() {
        return (InternationalString)this.properties.get("remarks");
    }

    public B setRemarks(CharSequence remarks) {
        this.properties.put("remarks", Types.toInternationalString(remarks));
        return this.self();
    }

    private boolean isDeprecated() {
        return Boolean.TRUE.equals(this.properties.get("deprecated"));
    }

    public B setDeprecated(boolean deprecated) {
        this.properties.put("deprecated", deprecated);
        return this.self();
    }

    protected void onCreate(boolean cleanup) {
        Identifier[] valueIds;
        GenericName[] valueAlias;
        if (cleanup) {
            this.properties.put("name", null);
            this.properties.remove("remarks");
            this.properties.remove("description");
            this.properties.remove("deprecated");
            this.aliases.clear();
            this.identifiers.clear();
            valueAlias = null;
            valueIds = null;
        } else {
            valueAlias = this.aliases.toArray(new GenericName[this.aliases.size()]);
            valueIds = this.identifiers.toArray(new ReferenceIdentifier[this.identifiers.size()]);
        }
        this.properties.put("alias", valueAlias);
        this.properties.put("identifiers", valueIds);
    }
}

