/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.unit.NonSI;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.util.FactoryException;

public final class CRS
extends Static {
    private CRS() {
    }

    public static CoordinateReferenceSystem forCode(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", code);
        try {
            return AuthorityFactories.ALL.createCoordinateReferenceSystem(code);
        }
        catch (UnavailableFactoryException e) {
            return AuthorityFactories.fallback(e).createCoordinateReferenceSystem(code);
        }
    }

    public static CoordinateReferenceSystem fromWKT(String text) throws FactoryException {
        ArgumentChecks.ensureNonNull("text", text);
        return DefaultFactories.forBuildin(CRSFactory.class).createFromWKT(text);
    }

    public static CoordinateReferenceSystem fromXML(String xml) throws FactoryException {
        ArgumentChecks.ensureNonNull("text", xml);
        return DefaultFactories.forBuildin(CRSFactory.class).createFromXML(xml);
    }

    public static CoordinateOperation findOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, GeographicBoundingBox areaOfInterest) throws FactoryException {
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        CoordinateOperationContext context = null;
        if (areaOfInterest != null) {
            if (areaOfInterest instanceof DefaultGeographicBoundingBox && ((DefaultGeographicBoundingBox)areaOfInterest).isEmpty()) {
                throw new IllegalArgumentException(Errors.format((short)20, "areaOfInterest"));
            }
            context = new CoordinateOperationContext();
            context.setAreaOfInterest(areaOfInterest);
        }
        return CoordinateOperations.factory().createOperation(sourceCRS, targetCRS, context);
    }

    public static double getLinearAccuracy(CoordinateOperation operation) {
        if (operation == null) {
            return Double.NaN;
        }
        if (operation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)operation).getLinearAccuracy();
        }
        return PositionalAccuracyConstant.getLinearAccuracy(operation);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateOperation operation) {
        return operation != null ? Extents.getGeographicBoundingBox(operation.getDomainOfValidity()) : null;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        return crs != null ? Extents.getGeographicBoundingBox(crs.getDomainOfValidity()) : null;
    }

    public static boolean isHorizontalCRS(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        boolean isGeodetic = crs instanceof GeodeticCRS;
        if ((isGeodetic || crs instanceof ProjectedCRS || crs instanceof EngineeringCRS) && (cs = crs.getCoordinateSystem()).getDimension() == 2) {
            return !isGeodetic || cs instanceof EllipsoidalCS;
        }
        return false;
    }

    public static SingleCRS getHorizontalComponent(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        if (crs instanceof GeodeticCRS && (cs = crs.getCoordinateSystem()) instanceof EllipsoidalCS) {
            int i = AxisDirections.indexOfColinear(cs, AxisDirection.UP);
            if (i < 0) {
                return (SingleCRS)crs;
            }
            CoordinateSystemAxis xAxis = cs.getAxis(i > 0 ? 0 : 1);
            CoordinateSystemAxis yAxis = cs.getAxis(i > 1 ? 1 : 2);
            cs = CommonCRS.DEFAULT.geographic().getCoordinateSystem();
            if (!Utilities.equalsIgnoreMetadata(cs.getAxis(0), xAxis) || !Utilities.equalsIgnoreMetadata(cs.getAxis(1), yAxis)) {
                cs = new DefaultEllipsoidalCS((Map<String, ?>)Collections.singletonMap("name", "Ellipsoidal 2D"), xAxis, yAxis);
            }
            return new DefaultGeographicCRS(ReferencingUtilities.getPropertiesForModifiedCRS(crs, "identifiers"), ((GeodeticCRS)crs).getDatum(), (EllipsoidalCS)cs);
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getComponents()) {
                SingleCRS candidate = CRS.getHorizontalComponent(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return CRS.isHorizontalCRS(crs) ? (SingleCRS)crs : null;
    }

    public static VerticalCRS getVerticalComponent(CoordinateReferenceSystem crs, boolean allowCreateEllipsoidal) {
        int i;
        CoordinateSystem cs;
        if (crs instanceof VerticalCRS) {
            return (VerticalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            boolean a = false;
            do {
                for (CoordinateReferenceSystem c : cp.getComponents()) {
                    VerticalCRS candidate = CRS.getVerticalComponent(c, a);
                    if (candidate == null) continue;
                    return candidate;
                }
            } while ((a = !a) == allowCreateEllipsoidal);
        }
        if (allowCreateEllipsoidal && crs instanceof GeodeticCRS && (cs = crs.getCoordinateSystem()) instanceof EllipsoidalCS && (i = AxisDirections.indexOfColinear(cs, AxisDirection.UP)) >= 0) {
            CoordinateReferenceSystem c;
            CoordinateSystemAxis axis = cs.getAxis(i);
            c = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!c.getCoordinateSystem().getAxis(0).equals(axis)) {
                Map<String, ?> properties = IdentifiedObjects.getProperties(c, new String[0]);
                c = new DefaultVerticalCRS(properties, c.getDatum(), new DefaultVerticalCS(properties, axis));
            }
            return c;
        }
        return null;
    }

    public static TemporalCRS getTemporalComponent(CoordinateReferenceSystem crs) {
        if (crs instanceof TemporalCRS) {
            return (TemporalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getComponents()) {
                TemporalCRS candidate = CRS.getTemporalComponent(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static List<SingleCRS> getSingleComponents(CoordinateReferenceSystem crs) {
        List<SingleCRS> singles;
        if (crs == null) {
            singles = Collections.emptyList();
        } else if (crs instanceof CompoundCRS) {
            if (crs instanceof DefaultCompoundCRS) {
                singles = ((DefaultCompoundCRS)crs).getSingleComponents();
            } else {
                List<CoordinateReferenceSystem> elements = ((CompoundCRS)crs).getComponents();
                singles = new ArrayList<SingleCRS>(elements.size());
                ReferencingUtilities.getSingleComponents(elements, singles);
            }
        } else {
            singles = Collections.singletonList((SingleCRS)crs);
        }
        return singles;
    }

    public static CoordinateReferenceSystem getComponentAt(CoordinateReferenceSystem crs, int lower, int upper) {
        int dimension = ReferencingUtilities.getDimension(crs);
        ArgumentChecks.ensureValidIndexRange(dimension, lower, upper);
        block0: while (lower != 0 || upper != dimension) {
            if (crs instanceof CompoundCRS) {
                List<CoordinateReferenceSystem> components = ((CompoundCRS)crs).getComponents();
                int size = components.size();
                for (int i = 0; i < size; ++i) {
                    crs = components.get(i);
                    dimension = crs.getCoordinateSystem().getDimension();
                    if (lower < dimension) continue block0;
                    lower -= dimension;
                    upper -= dimension;
                }
            }
            return null;
        }
        return crs;
    }

    public static double getGreenwichLongitude(GeodeticCRS crs) {
        ArgumentChecks.ensureNonNull("crs", crs);
        return ReferencingUtilities.getGreenwichLongitude(crs.getDatum().getPrimeMeridian(), NonSI.DEGREE_ANGLE);
    }

    public static CRSAuthorityFactory getAuthorityFactory(String authority) throws FactoryException {
        if (authority == null) {
            return AuthorityFactories.ALL;
        }
        return AuthorityFactories.ALL.getAuthorityFactory(CRSAuthorityFactory.class, authority, null);
    }
}

