/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.util.Fallback;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;

@Fallback
final class EPSGFactoryFallback
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory {
    static final boolean FORCE_HARDCODED = false;
    static final CRSAuthorityFactory INSTANCE = new EPSGFactoryFallback();
    private Citation authority;

    private EPSGFactoryFallback() {
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            DefaultCitation c = new DefaultCitation(Citations.EPSG);
            c.setTitle(new SimpleInternationalString("Subset of " + c.getTitle().toString(Locale.ENGLISH)));
            this.authority = c;
        }
        return this.authority;
    }

    @Override
    public Set<String> getCodeSpaces() {
        return Collections.singleton("EPSG");
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) {
        boolean geographic = type.isAssignableFrom(GeographicCRS.class);
        boolean geocentric = type.isAssignableFrom(GeocentricCRS.class);
        boolean projected = type.isAssignableFrom(ProjectedCRS.class);
        LinkedHashSet<String> codes = new LinkedHashSet<String>();
        for (CommonCRS commonCRS : CommonCRS.values()) {
            if (geographic) {
                EPSGFactoryFallback.add(codes, commonCRS.geographic);
                EPSGFactoryFallback.add(codes, commonCRS.geo3D);
            }
            if (geocentric) {
                EPSGFactoryFallback.add(codes, commonCRS.geocentric);
            }
            if (!projected || commonCRS.northUTM == 0 && commonCRS.southUTM == 0) continue;
            for (int zone = commonCRS.firstZone; zone <= commonCRS.lastZone; ++zone) {
                if (commonCRS.northUTM != 0) {
                    codes.add(Integer.toString(commonCRS.northUTM + zone));
                }
                if (commonCRS.southUTM == 0) continue;
                codes.add(Integer.toString(commonCRS.southUTM + zone));
            }
        }
        if (type.isAssignableFrom(VerticalCRS.class)) {
            for (Enum enum_ : CommonCRS.Vertical.values()) {
                if (!((CommonCRS.Vertical)enum_).isEPSG) continue;
                codes.add(Integer.toString(((CommonCRS.Vertical)enum_).crs));
            }
        }
        return codes;
    }

    private static void add(Set<String> codes, int value) {
        if (value != 0) {
            codes.add(Integer.toString(value));
        }
    }

    @Override
    public IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException {
        NumberFormatException cause = null;
        try {
            int n = Integer.parseInt(CharSequences.trimWhitespaces(code, code.lastIndexOf(58) + 1, code.length()).toString());
            for (CommonCRS commonCRS : CommonCRS.values()) {
                double latitude;
                int zone;
                if (n == commonCRS.geographic) {
                    return commonCRS.geographic();
                }
                if (n == commonCRS.geocentric) {
                    return commonCRS.geocentric();
                }
                if (n == commonCRS.geo3D) {
                    return commonCRS.geographic3D();
                }
                if (commonCRS.northUTM != 0 && (zone = n - commonCRS.northUTM) >= commonCRS.firstZone && zone <= commonCRS.lastZone) {
                    latitude = 1.0;
                } else {
                    if (commonCRS.southUTM == 0 || (zone = n - commonCRS.southUTM) < commonCRS.firstZone || zone > commonCRS.lastZone) continue;
                    latitude = -1.0;
                }
                return commonCRS.UTM(latitude, TransverseMercator.centralMeridian(zone));
            }
            for (Enum enum_ : CommonCRS.Vertical.values()) {
                if (!((CommonCRS.Vertical)enum_).isEPSG || ((CommonCRS.Vertical)enum_).crs != n) continue;
                return ((CommonCRS.Vertical)enum_).crs();
            }
        }
        catch (NumberFormatException e) {
            cause = e;
        }
        String authority = "EPSG subset";
        NoSuchAuthorityCodeException e = new NoSuchAuthorityCodeException(Errors.format((short)137, "EPSG subset", CoordinateReferenceSystem.class, code), "EPSG subset", code);
        e.initCause(cause);
        throw e;
    }
}

