/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.Properties;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

public final class IdentifiedObjects
extends Static {
    private IdentifiedObjects() {
    }

    public static Map<String, ?> getProperties(IdentifiedObject object, String ... excludes) {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("excludes", excludes);
        return new Properties(object, excludes);
    }

    public static Set<String> getNames(IdentifiedObject object, Citation authority) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(8);
        IdentifiedObjects.getName(object, authority, names);
        return names;
    }

    public static String getName(IdentifiedObject object, Citation authority) {
        return IdentifiedObjects.getName(object, authority, null);
    }

    private static String getName(IdentifiedObject object, Citation authority, Collection<String> addTo) {
        block11: {
            Iterator<GenericName> it;
            String name;
            Identifier identifier;
            block12: {
                Iterator<GenericName> it2;
                String name2;
                if (object == null) break block11;
                identifier = object.getName();
                if (authority != null) break block12;
                if (identifier != null && (name2 = identifier.getCode()) != null) {
                    if (addTo == null) {
                        return name2;
                    }
                    addTo.add(name2);
                }
                if ((it2 = Citations.iterator(object.getAlias())) == null) break block11;
                while (it2.hasNext()) {
                    String name3;
                    GenericName alias = it2.next();
                    if (alias == null || (name3 = alias instanceof Identifier ? ((Identifier)((Object)alias)).getCode() : alias.toString()) == null) continue;
                    if (addTo == null) {
                        return name3;
                    }
                    addTo.add(name3);
                }
                break block11;
            }
            if (identifier != null && Citations.identifierMatches(authority, identifier.getAuthority()) && (name = identifier.getCode()) != null) {
                if (addTo == null) {
                    return name;
                }
                addTo.add(name);
            }
            if ((it = Citations.iterator(object.getAlias())) != null) {
                while (it.hasNext()) {
                    String name4;
                    GenericName scope;
                    GenericName alias = it.next();
                    if (alias == null) continue;
                    if (alias instanceof Identifier) {
                        String name5;
                        identifier = (Identifier)((Object)alias);
                        if (!Citations.identifierMatches(authority, identifier.getAuthority()) || (name5 = identifier.getCode()) == null) continue;
                        if (addTo == null) {
                            return name5;
                        }
                        addTo.add(name5);
                        continue;
                    }
                    NameSpace ns = alias.scope();
                    if (ns == null || (scope = ns.name()) == null || !Citations.identifierMatches(authority, null, scope.toString()) || (name4 = alias.toString()) == null) continue;
                    if (addTo == null) {
                        return name4;
                    }
                    addTo.add(name4);
                }
            }
        }
        return null;
    }

    public static Identifier getIdentifier(IdentifiedObject object, Citation authority) {
        Iterator<ReferenceIdentifier> it;
        if (object != null && (it = Citations.iterator(object.getIdentifiers())) != null) {
            while (it.hasNext()) {
                Identifier identifier = it.next();
                if (identifier == null || authority != null && !Citations.identifierMatches(authority, identifier.getAuthority())) continue;
                return identifier;
            }
        }
        return null;
    }

    public static String getIdentifierOrName(IdentifiedObject object) {
        if (object != null) {
            String name;
            Iterator<ReferenceIdentifier> it = Citations.iterator(object.getIdentifiers());
            if (it != null) {
                while (it.hasNext()) {
                    String code = IdentifiedObjects.toString(it.next());
                    if (code == null) continue;
                    return code;
                }
            }
            if ((name = IdentifiedObjects.toString(object.getName())) != null) {
                return name;
            }
        }
        return null;
    }

    public static String getUnicodeIdentifier(IdentifiedObject object) {
        if (object != null) {
            Iterator<ReferenceIdentifier> id;
            String code;
            String code2;
            Identifier identifier = object.getName();
            if (identifier != null && CharSequences.isUnicodeIdentifier(code2 = identifier.getCode())) {
                return code2;
            }
            Iterator<GenericName> it = Citations.iterator(object.getAlias());
            if (it != null) {
                while (it.hasNext()) {
                    GenericName alias = it.next();
                    if (alias == null || (alias = alias.tip()) == null || !CharSequences.isUnicodeIdentifier(code = alias.toString())) continue;
                    return code;
                }
            }
            if ((id = Citations.iterator(object.getIdentifiers())) != null) {
                while (id.hasNext()) {
                    identifier = id.next();
                    if (identifier == null || !CharSequences.isUnicodeIdentifier(code = identifier.getCode())) continue;
                    return code;
                }
            }
        }
        return null;
    }

    public static String lookupURN(IdentifiedObject object, Citation authority) throws FactoryException {
        String urn = null;
        if (object != null) {
            for (IdentifiedObject candidate : IdentifiedObjects.newFinder(null).find(object)) {
                String c = IdentifiedObjects.toURN(candidate.getClass(), IdentifiedObjects.getIdentifier(candidate, authority));
                if (c == null && authority == null) {
                    for (Identifier identifier : candidate.getIdentifiers()) {
                        c = IdentifiedObjects.toURN(candidate.getClass(), identifier);
                        if (c == null) continue;
                        break;
                    }
                }
                if (c == null) continue;
                if (urn != null && !urn.equals(c)) {
                    return null;
                }
                urn = c;
            }
        }
        return urn;
    }

    public static Integer lookupEPSG(IdentifiedObject object) throws FactoryException {
        Integer code = null;
        if (object != null) {
            for (IdentifiedObject candidate : IdentifiedObjects.newFinder("EPSG").find(object)) {
                Identifier id = IdentifiedObjects.getIdentifier(candidate, org.apache.sis.metadata.iso.citation.Citations.EPSG);
                if (id == null) continue;
                try {
                    Integer previous = code;
                    code = Integer.valueOf(id.getCode());
                    if (previous == null || previous.equals(code)) continue;
                    return null;
                }
                catch (NumberFormatException e) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.factory"), IdentifiedObjects.class, "lookupEPSG", e);
                }
            }
        }
        return code;
    }

    public static IdentifiedObjectFinder newFinder(String authority) throws NoSuchAuthorityFactoryException, FactoryException {
        GeodeticAuthorityFactory factory = authority == null ? AuthorityFactories.ALL : AuthorityFactories.ALL.getAuthorityFactory(GeodeticAuthorityFactory.class, authority, null);
        return ((GeodeticAuthorityFactory)factory).newIdentifiedObjectFinder();
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject object, String name) {
        ArgumentChecks.ensureNonNull("name", name);
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).isHeuristicMatchForName(name);
        }
        return NameToIdentifier.isHeuristicMatchForName(object.getName(), object.getAlias(), name, NameToIdentifier.Simplifier.DEFAULT);
    }

    public static String toURN(Class<?> type, Identifier identifier) {
        ArgumentChecks.ensureNonNull("type", type);
        if (identifier == null) {
            return null;
        }
        String cs = null;
        if (identifier instanceof ReferenceIdentifier) {
            cs = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (cs == null || cs.isEmpty()) {
            cs = Citations.getIdentifier(identifier.getAuthority(), true);
        }
        return NameMeaning.toURN(type, cs, identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getVersion() : null, identifier.getCode());
    }

    public static String toString(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName) {
            return identifier.toString();
        }
        String code = identifier.getCode();
        String cs = null;
        if (identifier instanceof ReferenceIdentifier) {
            cs = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (cs == null || cs.isEmpty()) {
            cs = Citations.getIdentifier(identifier.getAuthority(), true);
        }
        if (cs != null) {
            return cs + ':' + code;
        }
        return code;
    }
}

