/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class NameIterator
implements Iterator<ReferenceIdentifier> {
    private ReferenceIdentifier next;
    private final Iterator<GenericName> alias;

    NameIterator(IdentifiedObject object) {
        this.alias = object.getAlias().iterator();
        this.next = object.getName();
        if (NameIterator.isUnnamed(this.next)) {
            this.next();
        }
    }

    static boolean isUnnamed(ReferenceIdentifier name) {
        return name == null || name == NilReferencingObject.UNNAMED;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ReferenceIdentifier next() {
        ReferenceIdentifier n = this.next;
        while (this.alias.hasNext()) {
            GenericName c = this.alias.next();
            if (!(c instanceof ReferenceIdentifier)) continue;
            this.next = (ReferenceIdentifier)((Object)c);
            return n;
        }
        this.next = null;
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static int count(IdentifiedObject object) {
        int c = 0;
        NameIterator it = new NameIterator(object);
        while (it.hasNext()) {
            it.next();
            ++c;
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    static String getID(Context context, IdentifiedObject object, ReferenceIdentifier name, Collection<? extends GenericName> alias, Collection<? extends ReferenceIdentifier> identifiers) {
        String candidate = Context.getObjectID(context, object);
        if (candidate == null) {
            StringBuilder id = new StringBuilder();
            if (identifiers != null) {
                for (ReferenceIdentifier referenceIdentifier : identifiers) {
                    if (Utilities.appendUnicodeIdentifier(id, '-', referenceIdentifier.getCodeSpace(), "", true) | Utilities.appendUnicodeIdentifier(id, '-', NameMeaning.toObjectType(object.getClass()), "", false) | Utilities.appendUnicodeIdentifier(id, '-', referenceIdentifier.getCode(), "", true) && Context.setObjectForID(context, object, candidate = id.toString())) {
                        return candidate;
                    }
                    id.setLength(0);
                }
            }
            if ((NameIterator.isUnnamed(name) || !Utilities.appendUnicodeIdentifier(id, '-', name.getCode(), "", false)) && alias != null) {
                GenericName genericName;
                Iterator<Object> iterator = alias.iterator();
                while (iterator.hasNext() && !Utilities.appendUnicodeIdentifier(id, '-', (genericName = (GenericName)iterator.next()).toString(), "", false)) {
                }
            }
            if (id.length() != 0 && !Context.setObjectForID(context, object, candidate = id.toString())) {
                int s = id.append('-').length();
                boolean bl = false;
                do {
                    void var8_13;
                    if (++var8_13 == 100) {
                        return null;
                    }
                    candidate = id.append((int)var8_13).toString();
                    id.setLength(s);
                } while (!Context.setObjectForID(context, object, candidate));
            }
        }
        return candidate;
    }
}

