/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.NoSuchIdentifierException;

final class StandardDefinitions {
    static final String GREENWICH = "8901";

    private StandardDefinitions() {
    }

    private static Map<String, Object> properties(int code, String name, String alias, boolean world) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (code != 0) {
            map.put("identifiers", new NamedIdentifier(Citations.EPSG, String.valueOf(code)));
        }
        map.put("name", new NamedIdentifier(Citations.EPSG, name));
        map.put("alias", alias);
        if (world) {
            map.put("domainOfValidity", Extents.WORLD);
        }
        return map;
    }

    private static void addWMS(Map<String, Object> properties, String code) {
        properties.put("identifiers", new NamedIdentifier[]{(NamedIdentifier)properties.get("identifiers"), new NamedIdentifier(Citations.WMS, code)});
    }

    static ProjectedCRS createUTM(int code, GeographicCRS baseCRS, double latitude, double longitude, CartesianCS derivedCS) {
        OperationMethod method;
        try {
            method = DefaultFactories.forBuildin(MathTransformFactory.class, DefaultMathTransformFactory.class).getOperationMethod("Transverse Mercator");
        }
        catch (NoSuchIdentifierException e) {
            throw new IllegalStateException(e);
        }
        ParameterValueGroup parameters = method.getParameters().createValue();
        String name = TransverseMercator.setParameters(parameters, true, latitude, longitude);
        DefaultConversion conversion = new DefaultConversion(StandardDefinitions.properties(0, name, null, false), method, null, parameters);
        name = baseCRS.getName().getCode() + " / " + name;
        return new DefaultProjectedCRS(StandardDefinitions.properties(code, name, null, false), baseCRS, (Conversion)conversion, derivedCS);
    }

    static GeographicCRS createGeographicCRS(short code, GeodeticDatum datum, EllipsoidalCS cs) {
        String name;
        String alias = null;
        String scope = null;
        boolean world = false;
        switch (code) {
            case 4326: {
                name = "WGS 84";
                world = true;
                scope = "Horizontal component of 3D system.";
                break;
            }
            case 4322: {
                name = "WGS 72";
                world = true;
                break;
            }
            case 4258: {
                name = "ETRS89";
                alias = "ETRS89-GRS80";
                break;
            }
            case 4269: {
                name = "NAD83";
                break;
            }
            case 4267: {
                name = "NAD27";
                break;
            }
            case 4230: {
                name = "ED50";
                break;
            }
            case 4047: {
                name = "Unspecified datum based upon the GRS 1980 Authalic Sphere";
                world = true;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        Map<String, Object> properties = StandardDefinitions.properties(code, name, alias, world);
        properties.put("scope", scope);
        return new DefaultGeographicCRS(properties, datum, cs);
    }

    static GeodeticDatum createGeodeticDatum(short code, Ellipsoid ellipsoid, PrimeMeridian meridian) {
        String alias;
        String name;
        boolean world = false;
        switch (code) {
            case 6326: {
                name = "World Geodetic System 1984";
                alias = "WGS 84";
                world = true;
                break;
            }
            case 6322: {
                name = "World Geodetic System 1972";
                alias = "WGS 72";
                world = true;
                break;
            }
            case 6258: {
                name = "European Terrestrial Reference System 1989";
                alias = "ETRS89";
                break;
            }
            case 6269: {
                name = "North American Datum 1983";
                alias = "NAD83";
                break;
            }
            case 6267: {
                name = "North American Datum 1927";
                alias = "NAD27";
                break;
            }
            case 6230: {
                name = "European Datum 1950";
                alias = "ED50";
                break;
            }
            case 6047: {
                name = "Not specified (based on GRS 1980 Authalic Sphere)";
                alias = null;
                world = true;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        return new DefaultGeodeticDatum(StandardDefinitions.properties(code, name, alias, world), ellipsoid, meridian);
    }

    static Ellipsoid createEllipsoid(short code) {
        double other;
        double semiMajorAxis;
        String name;
        String alias = null;
        boolean ivfDefinitive = true;
        BaseUnit<Length> unit = SI.METRE;
        switch (code) {
            case 7030: {
                name = "WGS 84";
                alias = "WGS84";
                semiMajorAxis = 6378137.0;
                other = 298.257223563;
                break;
            }
            case 7043: {
                name = "WGS 72";
                alias = "NWL 10D";
                semiMajorAxis = 6378135.0;
                other = 298.26;
                break;
            }
            case 7019: {
                alias = "International 1979";
                name = "GRS 1980";
                semiMajorAxis = 6378137.0;
                other = 298.257222101;
                break;
            }
            case 7022: {
                name = "International 1924";
                alias = "Hayford 1909";
                semiMajorAxis = 6378388.0;
                other = 297.0;
                break;
            }
            case 7008: {
                name = "Clarke 1866";
                ivfDefinitive = false;
                semiMajorAxis = 6378206.4;
                other = 6356583.8;
                break;
            }
            case 7048: {
                name = "GRS 1980 Authalic Sphere";
                ivfDefinitive = false;
                other = 6371007.0;
                semiMajorAxis = 6371007.0;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        Map<String, Object> map = StandardDefinitions.properties(code, name, alias, false);
        if (ivfDefinitive) {
            return DefaultEllipsoid.createFlattenedSphere(map, semiMajorAxis, other, unit);
        }
        return DefaultEllipsoid.createEllipsoid(map, semiMajorAxis, other, unit);
    }

    static PrimeMeridian primeMeridian() {
        HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>(4);
        properties.put("name", new NamedIdentifier(Citations.EPSG, "Greenwich"));
        properties.put("identifiers", new NamedIdentifier(Citations.EPSG, GREENWICH));
        return new DefaultPrimeMeridian(properties, 0.0, NonSI.DEGREE_ANGLE);
    }

    static VerticalCRS createVerticalCRS(short code, VerticalDatum datum) {
        String alias;
        String name;
        String cs = "Vertical CS. Axis: height (H).";
        int c = 6499;
        short axis = 114;
        String wms = null;
        switch (code) {
            case 5703: {
                wms = "88";
                name = "NAVD88 height";
                alias = "North American Vertical Datum of 1988 height (m)";
                break;
            }
            case 5714: {
                name = "MSL height";
                alias = "mean sea level height";
                break;
            }
            case 5715: {
                name = "MSL depth";
                alias = "mean sea level depth";
                cs = "Vertical CS. Axis: depth (D).";
                c = 6498;
                axis = 113;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        Map<String, Object> properties = StandardDefinitions.properties(code, name, alias, true);
        if (wms != null) {
            StandardDefinitions.addWMS(properties, wms);
        }
        return new DefaultVerticalCRS(properties, datum, new DefaultVerticalCS(StandardDefinitions.properties(c, cs, null, false), StandardDefinitions.createAxis(axis)));
    }

    static VerticalDatum createVerticalDatum(short code) {
        String alias;
        String name;
        switch (code) {
            case 5100: {
                name = "Mean Sea Level";
                alias = "MSL";
                break;
            }
            case 5103: {
                name = "North American Vertical Datum 1988";
                alias = "NAVD88";
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        return new DefaultVerticalDatum(StandardDefinitions.properties(code, name, alias, true), VerticalDatumType.GEOIDAL);
    }

    static CoordinateSystem createCoordinateSystem(short code) {
        short axisCode;
        int dim;
        String name;
        boolean isCartesian = false;
        boolean isSpherical = false;
        switch (code) {
            case 6422: {
                name = "Ellipsoidal 2D";
                dim = 2;
                axisCode = 108;
                break;
            }
            case 6423: {
                name = "Ellipsoidal 3D";
                dim = 3;
                axisCode = 111;
                break;
            }
            case 6404: {
                name = "Spherical";
                dim = 3;
                axisCode = 63;
                isSpherical = true;
                break;
            }
            case 6500: {
                name = "Earth centred";
                dim = 3;
                axisCode = 118;
                isCartesian = true;
                break;
            }
            case 4400: {
                name = "Cartesian 2D";
                dim = 2;
                axisCode = 3;
                isCartesian = true;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        Map<String, Object> properties = StandardDefinitions.properties(code, name, null, false);
        CoordinateSystemAxis xAxis = null;
        CoordinateSystemAxis yAxis = null;
        CoordinateSystemAxis zAxis = null;
        switch (dim) {
            default: {
                throw new AssertionError(dim);
            }
            case 3: {
                axisCode = (short)(axisCode - 1);
                zAxis = StandardDefinitions.createAxis(axisCode);
            }
            case 2: {
                axisCode = (short)(axisCode - 1);
                yAxis = StandardDefinitions.createAxis(axisCode);
            }
            case 1: {
                axisCode = (short)(axisCode - 1);
                xAxis = StandardDefinitions.createAxis(axisCode);
            }
            case 0: 
        }
        if (isCartesian) {
            if (zAxis != null) {
                return new DefaultCartesianCS((Map<String, ?>)properties, xAxis, yAxis, zAxis);
            }
            return new DefaultCartesianCS((Map<String, ?>)properties, xAxis, yAxis);
        }
        if (isSpherical) {
            return new DefaultSphericalCS((Map<String, ?>)properties, xAxis, yAxis, zAxis);
        }
        if (zAxis != null) {
            return new DefaultEllipsoidalCS((Map<String, ?>)properties, xAxis, yAxis, zAxis);
        }
        return new DefaultEllipsoidalCS((Map<String, ?>)properties, xAxis, yAxis);
    }

    static CoordinateSystemAxis createAxis(short code) {
        AxisDirection dir;
        String abrv;
        String name;
        Unit unit = SI.METRE;
        double min = Double.NEGATIVE_INFINITY;
        double max = Double.POSITIVE_INFINITY;
        RangeMeaning rm = null;
        switch (code) {
            case 1: {
                name = "Easting";
                abrv = "E";
                unit = SI.METRE;
                dir = AxisDirection.EAST;
                break;
            }
            case 2: {
                name = "Northing";
                abrv = "N";
                unit = SI.METRE;
                dir = AxisDirection.NORTH;
                break;
            }
            case 60: {
                name = "Spherical latitude";
                abrv = "\u03c6\u2032";
                unit = NonSI.DEGREE_ANGLE;
                dir = AxisDirection.NORTH;
                min = -90.0;
                max = 90.0;
                rm = RangeMeaning.EXACT;
                break;
            }
            case 61: {
                name = "Spherical longitude";
                abrv = "\u03b8";
                unit = NonSI.DEGREE_ANGLE;
                dir = AxisDirection.EAST;
                min = -180.0;
                max = 180.0;
                rm = RangeMeaning.WRAPAROUND;
                break;
            }
            case 62: {
                name = "Geocentric radius";
                abrv = "R";
                unit = SI.METRE;
                dir = AxisDirection.UP;
                rm = RangeMeaning.EXACT;
                min = 0.0;
                break;
            }
            case 106: 
            case 108: {
                name = "Geodetic latitude";
                abrv = "\u03c6";
                unit = NonSI.DEGREE_ANGLE;
                dir = AxisDirection.NORTH;
                min = -90.0;
                max = 90.0;
                rm = RangeMeaning.EXACT;
                break;
            }
            case 107: 
            case 109: {
                name = "Geodetic longitude";
                abrv = "\u03bb";
                unit = NonSI.DEGREE_ANGLE;
                dir = AxisDirection.EAST;
                min = -180.0;
                max = 180.0;
                rm = RangeMeaning.WRAPAROUND;
                break;
            }
            case 110: {
                name = "Ellipsoidal height";
                abrv = "h";
                dir = AxisDirection.UP;
                break;
            }
            case 114: {
                name = "Gravity-related height";
                abrv = "H";
                dir = AxisDirection.UP;
                break;
            }
            case 113: {
                name = "Depth";
                abrv = "D";
                dir = AxisDirection.DOWN;
                break;
            }
            case 115: {
                name = "Geocentric X";
                abrv = "X";
                dir = AxisDirection.GEOCENTRIC_X;
                break;
            }
            case 116: {
                name = "Geocentric Y";
                abrv = "Y";
                dir = AxisDirection.GEOCENTRIC_Y;
                break;
            }
            case 117: {
                name = "Geocentric Z";
                abrv = "Z";
                dir = AxisDirection.GEOCENTRIC_Z;
                break;
            }
            default: {
                throw new AssertionError(code);
            }
        }
        Map<String, Object> properties = StandardDefinitions.properties(code, name, null, false);
        properties.put("minimumValue", min);
        properties.put("maximumValue", max);
        properties.put("rangeMeaning", rm);
        return new DefaultCoordinateSystemAxis(properties, abrv, dir, unit);
    }
}

