/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultGeodeticCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.GeodeticDatum;

@XmlTransient
public class DefaultGeographicCRS
extends DefaultGeodeticCRS
implements GeographicCRS {
    private static final short[] EPSG_CODES = new short[]{4267, 4269, 4326};
    private static final byte[] CRS_CODES = new byte[]{27, 83, 84};
    private static final long serialVersionUID = 861224913438092335L;

    public DefaultGeographicCRS(Map<String, ?> properties, GeodeticDatum datum, EllipsoidalCS cs) {
        super(properties, datum, cs);
    }

    protected DefaultGeographicCRS(GeographicCRS crs) {
        super(crs);
    }

    public static DefaultGeographicCRS castOrCopy(GeographicCRS object) {
        return object == null || object instanceof DefaultGeographicCRS ? (DefaultGeographicCRS)object : new DefaultGeographicCRS(object);
    }

    public Class<? extends GeographicCRS> getInterface() {
        return GeographicCRS.class;
    }

    @Override
    public final GeodeticDatum getDatum() {
        return super.getDatum();
    }

    @Override
    public EllipsoidalCS getCoordinateSystem() {
        return (EllipsoidalCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultGeographicCRS forConvention(AxesConvention convention) {
        return (DefaultGeographicCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        CoordinateSystemAxis axis = cs.getAxis(0);
        if (axis.getMinimumValue() == -180.0 && axis.getMaximumValue() == 180.0) {
            for (ReferenceIdentifier identifier : super.getIdentifiers()) {
                if (!"EPSG".equals(identifier.getCodeSpace())) continue;
                try {
                    int i = Arrays.binarySearch(EPSG_CODES, Short.parseShort(identifier.getCode()));
                    if (i < 0) continue;
                    HashMap c = new HashMap(properties);
                    c.put("identifiers", new ImmutableIdentifier(Citations.WMS, "CRS", Short.toString(CRS_CODES[i])));
                    properties = c;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return new DefaultGeographicCRS(properties, super.getDatum(), (EllipsoidalCS)cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        return super.formatTo(formatter);
    }

    private DefaultGeographicCRS() {
    }

    DefaultGeographicCRS(GeodeticCRS crs) {
        super(crs);
        CoordinateSystem cs = super.getCoordinateSystem();
        if (!(cs instanceof EllipsoidalCS)) {
            throw new IllegalArgumentException(Errors.format((short)34, EllipsoidalCS.class, cs.getClass()));
        }
    }
}

