/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Date;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Duration;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="TemporalCRS")
public class DefaultTemporalCRS
extends AbstractCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    private TemporalDatum datum;
    private transient UnitConverter toMillis;
    private transient long origin;

    public DefaultTemporalCRS(Map<String, ?> properties, TemporalDatum datum, TimeCS cs) {
        super(properties, cs);
        ArgumentChecks.ensureNonNull("datum", datum);
        this.datum = datum;
    }

    protected DefaultTemporalCRS(TemporalCRS crs) {
        super(crs);
        this.datum = crs.getDatum();
    }

    public static DefaultTemporalCRS castOrCopy(TemporalCRS object) {
        return object == null || object instanceof DefaultTemporalCRS ? (DefaultTemporalCRS)object : new DefaultTemporalCRS(object);
    }

    public Class<? extends TemporalCRS> getInterface() {
        return TemporalCRS.class;
    }

    private void initializeConverter() {
        this.origin = this.datum.getOrigin().getTime();
        this.toMillis = this.getCoordinateSystem().getAxis(0).getUnit().asType(Duration.class).getConverterTo(Units.MILLISECOND);
    }

    @Override
    @XmlElement(name="temporalDatum", required=true)
    public TemporalDatum getDatum() {
        return this.datum;
    }

    @Override
    @XmlElement(name="timeCS", required=true)
    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultTemporalCRS forConvention(AxesConvention convention) {
        return (DefaultTemporalCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultTemporalCRS(properties, this.datum, (TimeCS)cs);
    }

    public Date toDate(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return null;
        }
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return new Date(Math.round(this.toMillis.convert(value)) + this.origin);
    }

    public double toValue(Date time) {
        if (time == null) {
            return Double.NaN;
        }
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return this.toMillis.inverse().convert(time.getTime() - this.origin);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultTemporalCRS.isBaseCRS(formatter) ? "BaseTimeCRS" : "TimeCRS";
    }

    private DefaultTemporalCRS() {
    }

    private void setDatum(TemporalDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultVerticalCRS.class, "setDatum", "temporalDatum");
        }
    }

    private void setCoordinateSystem(TimeCS cs) {
        this.setCoordinateSystem("timeCS", cs);
    }
}

