/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCylindricalCS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultLinearCS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultUserDefinedCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.cs.SubTypes;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlType(name="AbstractCoordinateSystemType")
@XmlRootElement(name="AbstractCoordinateSystem")
@XmlSeeAlso(value={DefaultAffineCS.class, DefaultCartesianCS.class, DefaultSphericalCS.class, DefaultEllipsoidalCS.class, DefaultCylindricalCS.class, DefaultPolarCS.class, DefaultLinearCS.class, DefaultVerticalCS.class, DefaultTimeCS.class, DefaultParametricCS.class, DefaultUserDefinedCS.class})
public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    private static final long serialVersionUID = 6757665252533744744L;
    static final int VALID = 0;
    static final int INVALID_DIRECTION = 1;
    static final int INVALID_UNIT = 2;
    private CoordinateSystemAxis[] axes;
    private transient Map<AxesConvention, AbstractCS> derived;
    private static final CoordinateSystemAxis[] EMPTY = new CoordinateSystemAxis[0];

    public AbstractCS(Map<String, ?> properties, CoordinateSystemAxis ... axes) {
        super(properties);
        ArgumentChecks.ensureNonNull("axes", axes);
        axes = (CoordinateSystemAxis[])axes.clone();
        this.axes = axes;
        for (int i = 0; i < axes.length; ++i) {
            CoordinateSystemAxis axis = axes[i];
            ArgumentChecks.ensureNonNullElement("axes", i, axis);
            ReferenceIdentifier name = axis.getName();
            ArgumentChecks.ensureNonNullElement("axes[#].name", i, name);
            AxisDirection direction = axis.getDirection();
            ArgumentChecks.ensureNonNullElement("axes[#].direction", i, direction);
            Unit<?> unit = axis.getUnit();
            ArgumentChecks.ensureNonNullElement("axes[#].unit", i, unit);
            switch (this.validateAxis(direction, unit)) {
                case 1: {
                    throw new IllegalArgumentException(Errors.getResources(properties).getString((short)32, this.getClass(), direction));
                }
                case 2: {
                    throw new IllegalArgumentException(Errors.getResources(properties).getString((short)43, name, unit));
                }
            }
            AxisDirection dir = AxisDirections.absolute(direction);
            if (dir.equals(AxisDirection.OTHER)) continue;
            int j = i;
            while (--j >= 0) {
                AxisDirection other = axes[j].getDirection();
                AxisDirection abs = AxisDirections.absolute(other);
                if (!dir.equals(abs) || abs.equals(AxisDirection.FUTURE)) continue;
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)14, direction, other));
            }
        }
    }

    protected AbstractCS(CoordinateSystem cs) {
        super(cs);
        this.axes = cs instanceof AbstractCS ? ((AbstractCS)cs).axes : AbstractCS.getAxes(cs);
    }

    private static CoordinateSystemAxis[] getAxes(CoordinateSystem cs) {
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[cs.getDimension()];
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = cs.getAxis(i);
        }
        return axes;
    }

    public static AbstractCS castOrCopy(CoordinateSystem object) {
        return SubTypes.castOrCopy(object);
    }

    int validateAxis(AxisDirection direction, Unit<?> unit) {
        return 0;
    }

    public Class<? extends CoordinateSystem> getInterface() {
        return CoordinateSystem.class;
    }

    @Override
    public final int getDimension() {
        return this.axes.length;
    }

    @Override
    public final CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
        return this.axes[dimension];
    }

    public synchronized AbstractCS forConvention(AxesConvention convention) {
        AbstractCS cs;
        ArgumentChecks.ensureNonNull("convention", convention);
        if (this.derived == null) {
            this.derived = new EnumMap<AxesConvention, AbstractCS>(AxesConvention.class);
        }
        if ((cs = this.derived.get(convention)) == null) {
            cs = Normalizer.forConvention(this, convention);
            if (cs == null) {
                cs = this;
            }
            for (AbstractCS existing : this.derived.values()) {
                if (!cs.equals(existing)) continue;
                cs = existing;
                break;
            }
            this.derived.put(convention, cs);
        }
        return cs;
    }

    AbstractCS createForAxes(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        return new AbstractCS(properties, axes);
    }

    static IllegalArgumentException unexpectedDimension(Map<String, ?> properties, CoordinateSystemAxis[] axes, int expected) {
        return new IllegalArgumentException(Errors.getResources(properties).getString((short)59, "filter(cs)", expected, axes.length));
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                return Arrays.equals(this.axes, ((AbstractCS)object).axes);
            }
            case DEBUG: {
                int d1 = this.axes.length;
                int d2 = ((CoordinateSystem)object).getDimension();
                if (d1 != d2) {
                    throw new AssertionError((Object)Errors.format((short)58, d1, d2));
                }
                break;
            }
        }
        CoordinateSystem that = (CoordinateSystem)object;
        int dimension = this.getDimension();
        if (dimension != that.getDimension()) {
            return false;
        }
        if (mode != ComparisonMode.ALLOW_VARIANT) {
            for (int i = 0; i < dimension; ++i) {
                if (Utilities.deepEquals(this.getAxis(i), that.getAxis(i), mode)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Arrays.hashCode(this.axes);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String type = WKTUtilities.toType(CoordinateSystem.class, this.getInterface());
        if (type == null) {
            formatter.setInvalidWKT(this, null);
        }
        formatter.append(type, ElementKind.CODE_LIST);
        formatter.append(this.getDimension());
        return "CS";
    }

    AbstractCS() {
        super(NilReferencingObject.INSTANCE);
        this.axes = EMPTY;
    }

    @XmlElement(name="axis")
    private CoordinateSystemAxis[] getAxis() {
        return AbstractCS.getAxes(this);
    }

    private void setAxis(CoordinateSystemAxis[] values) {
        this.axes = values;
    }
}

