/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AxisFilter;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public enum AxesConvention implements AxisFilter
{
    NORMALIZED{

        @Override
        public boolean accept(CoordinateSystemAxis axis) {
            return true;
        }

        @Override
        @Deprecated
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return this.getUnitReplacement(null, unit);
        }

        @Override
        public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
            if (Units.isLinear(unit)) {
                unit = SI.METRE;
            } else if (Units.isAngular(unit)) {
                unit = NonSI.DEGREE_ANGLE;
            } else if (Units.isTemporal(unit)) {
                unit = NonSI.DAY;
            }
            return unit;
        }

        @Override
        @Deprecated
        public AxisDirection getDirectionReplacement(AxisDirection direction) {
            return this.getDirectionReplacement(null, direction);
        }

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
            if (!AxisDirections.isIntercardinal(direction) && (axis == null || axis.getMinimumValue() < 0.0)) {
                return AxisDirections.absolute(direction);
            }
            return direction;
        }
    }
    ,
    CONVENTIONALLY_ORIENTED{

        @Override
        public boolean accept(CoordinateSystemAxis axis) {
            return true;
        }

        @Override
        @Deprecated
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
            return unit;
        }

        @Override
        @Deprecated
        public AxisDirection getDirectionReplacement(AxisDirection direction) {
            return this.getDirectionReplacement(null, direction);
        }

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
            return NORMALIZED.getDirectionReplacement(axis, direction);
        }
    }
    ,
    RIGHT_HANDED{

        @Override
        public boolean accept(CoordinateSystemAxis axis) {
            return true;
        }

        @Override
        @Deprecated
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
            return unit;
        }

        @Override
        @Deprecated
        public AxisDirection getDirectionReplacement(AxisDirection direction) {
            return direction;
        }

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
            return direction;
        }
    }
    ,
    POSITIVE_RANGE{

        @Override
        public boolean accept(CoordinateSystemAxis axis) {
            return true;
        }

        @Override
        @Deprecated
        public Unit<?> getUnitReplacement(Unit<?> unit) {
            return unit;
        }

        @Override
        public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
            return unit;
        }

        @Override
        @Deprecated
        public AxisDirection getDirectionReplacement(AxisDirection direction) {
            return direction;
        }

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
            return direction;
        }
    };

}

