/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import javax.measure.converter.ConversionException;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.ElevationAngle;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Matrix;

public final class CoordinateSystems
extends Static {
    private CoordinateSystems() {
    }

    public static AxisDirection parseAxisDirection(String name) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("name", name);
        name = CharSequences.trimWhitespaces(name);
        AxisDirection candidate = AxisDirections.valueOf(name);
        if (candidate != null) {
            return candidate;
        }
        DirectionAlongMeridian meridian = DirectionAlongMeridian.parse(name);
        if (meridian != null) {
            candidate = meridian.getDirection();
            assert (candidate == AxisDirections.valueOf(meridian.toString()));
            return candidate;
        }
        throw new IllegalArgumentException(Errors.format((short)112, name));
    }

    public static AxisDirection directionAlongMeridian(AxisDirection baseDirection, double meridian) {
        return new DirectionAlongMeridian(baseDirection, meridian).getDirection();
    }

    public static Angle angle(AxisDirection source, AxisDirection target) {
        DirectionAlongMeridian tgtMeridian;
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("target", target);
        int c = AxisDirections.angleForCompass(source, target);
        if (c != Integer.MIN_VALUE) {
            return new Angle((double)c * 22.5);
        }
        c = AxisDirections.angleForGeocentric(source, target);
        if (c != Integer.MIN_VALUE) {
            return new Angle(c * 90);
        }
        c = AxisDirections.angleForDisplay(source, target);
        if (c != Integer.MIN_VALUE) {
            return new Angle(c * 90);
        }
        DirectionAlongMeridian srcMeridian = AxisDirections.isUserDefined(source) ? DirectionAlongMeridian.parse(source) : null;
        DirectionAlongMeridian directionAlongMeridian = tgtMeridian = AxisDirections.isUserDefined(target) ? DirectionAlongMeridian.parse(target) : null;
        if (srcMeridian != null && tgtMeridian != null) {
            return new Angle(srcMeridian.angle(tgtMeridian));
        }
        boolean srcVrt = AxisDirections.isVertical(source);
        boolean tgtVrt = AxisDirections.isVertical(target);
        if (tgtVrt) {
            if (srcVrt) {
                return new Angle(source.equals(target) ? 0.0 : (target.equals(AxisDirection.UP) ? 180.0 : -180.0));
            }
            if (AxisDirections.isCompass(source) || srcMeridian != null) {
                return target.equals(AxisDirection.UP) ? ElevationAngle.ZENITH : ElevationAngle.NADIR;
            }
        } else if (srcVrt && (AxisDirections.isCompass(target) || tgtMeridian != null)) {
            return source.equals(AxisDirection.UP) ? ElevationAngle.NADIR : ElevationAngle.ZENITH;
        }
        return null;
    }

    private static AxisDirection[] getAxisDirections(CoordinateSystem cs) {
        AxisDirection[] directions = new AxisDirection[cs.getDimension()];
        for (int i = 0; i < directions.length; ++i) {
            directions[i] = cs.getAxis(i).getDirection();
        }
        return directions;
    }

    public static Matrix swapAndScaleAxes(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws IllegalArgumentException, ConversionException {
        ArgumentChecks.ensureNonNull("sourceCS", sourceCS);
        ArgumentChecks.ensureNonNull("targetCS", targetCS);
        if (!Classes.implementSameInterfaces(sourceCS.getClass(), targetCS.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Errors.format((short)44));
        }
        Object[] srcAxes = CoordinateSystems.getAxisDirections(sourceCS);
        Object[] dstAxes = CoordinateSystems.getAxisDirections(targetCS);
        MatrixSIS matrix = Matrices.createTransform((AxisDirection[])srcAxes, (AxisDirection[])dstAxes);
        assert (Arrays.equals(srcAxes, dstAxes) == matrix.isIdentity()) : matrix;
        int sourceDim = matrix.getNumCol() - 1;
        int targetDim = matrix.getNumRow() - 1;
        for (int j = 0; j < targetDim; ++j) {
            Unit<?> targetUnit = targetCS.getAxis(j).getUnit();
            for (int i = 0; i < sourceDim; ++i) {
                Unit<?> sourceUnit;
                double element = matrix.getElement(j, i);
                if (element == 0.0 || Objects.equals(sourceUnit = sourceCS.getAxis(i).getUnit(), targetUnit)) continue;
                UnitConverter converter = sourceUnit.getConverterToAny(targetUnit);
                if (!(converter instanceof LinearConverter)) {
                    throw new ConversionException(Errors.format((short)83, sourceUnit, targetUnit));
                }
                double offset = converter.convert(0.0);
                double scale = Units.derivative(converter, 0.0);
                matrix.setElement(j, i, element * scale);
                matrix.setElement(j, sourceDim, matrix.getElement(j, sourceDim) + element * offset);
            }
        }
        return matrix;
    }

    public static CoordinateSystem replaceAxes(CoordinateSystem cs, AxisFilter filter) {
        ArgumentChecks.ensureNonNull("filter", filter);
        if (cs != null) {
            AbstractCS newCS;
            if (filter instanceof AxesConvention) {
                if (cs instanceof AbstractCS) {
                    return ((AbstractCS)cs).forConvention((AxesConvention)filter);
                }
                newCS = Normalizer.forConvention(cs, (AxesConvention)filter);
            } else {
                newCS = Normalizer.normalize(cs, filter, false);
            }
            if (newCS != null) {
                return newCS;
            }
        }
        return cs;
    }

    public static CoordinateSystem replaceLinearUnit(CoordinateSystem cs, final Unit<Length> newUnit) {
        ArgumentChecks.ensureNonNull("newUnit", newUnit);
        return CoordinateSystems.replaceAxes(cs, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
                return Units.isLinear(unit) ? newUnit : unit;
            }

            @Override
            public boolean accept(CoordinateSystemAxis axis) {
                return true;
            }

            @Override
            public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
                return direction;
            }

            @Override
            @Deprecated
            public AxisDirection getDirectionReplacement(AxisDirection direction) {
                return direction;
            }

            @Override
            @Deprecated
            public Unit<?> getUnitReplacement(Unit<?> unit) {
                return this.getUnitReplacement(null, unit);
            }
        });
    }

    public static CoordinateSystem replaceAngularUnit(CoordinateSystem cs, final Unit<javax.measure.quantity.Angle> newUnit) {
        ArgumentChecks.ensureNonNull("newUnit", newUnit);
        return CoordinateSystems.replaceAxes(cs, new AxisFilter(){

            @Override
            public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
                return Units.isAngular(unit) ? newUnit : unit;
            }

            @Override
            public boolean accept(CoordinateSystemAxis axis) {
                return true;
            }

            @Override
            public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
                return direction;
            }

            @Override
            @Deprecated
            public AxisDirection getDirectionReplacement(AxisDirection direction) {
                return direction;
            }

            @Override
            @Deprecated
            public Unit<?> getUnitReplacement(Unit<?> unit) {
                return this.getUnitReplacement(null, unit);
            }
        });
    }
}

