/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.SphericalCS;

@XmlType(name="SphericalCSType")
@XmlRootElement(name="SphericalCS")
public class DefaultSphericalCS
extends AbstractCS
implements SphericalCS {
    private static final long serialVersionUID = 196295996465774477L;

    private DefaultSphericalCS(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        super(properties, axes);
    }

    public DefaultSphericalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
    }

    protected DefaultSphericalCS(SphericalCS cs) {
        super(cs);
    }

    public static DefaultSphericalCS castOrCopy(SphericalCS object) {
        return object == null || object instanceof DefaultSphericalCS ? (DefaultSphericalCS)object : new DefaultSphericalCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(direction, false)) {
            return 1;
        }
        if (!Units.isAngular(unit) && !Units.isLinear(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends SphericalCS> getInterface() {
        return SphericalCS.class;
    }

    @Override
    public DefaultSphericalCS forConvention(AxesConvention convention) {
        return (DefaultSphericalCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 2: {
                return new DefaultPolarCS(properties, axes);
            }
            case 3: {
                return new DefaultSphericalCS(properties, axes);
            }
        }
        throw DefaultSphericalCS.unexpectedDimension(properties, axes, 2);
    }

    private DefaultSphericalCS() {
    }
}

