/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;

final class Normalizer
implements Comparable<Normalizer> {
    private static final String[] EXCLUDES = new String[]{"identifiers"};
    private static final int SHIFT = 2;
    private static final Map<AxisDirection, Integer> ORDER;
    private final CoordinateSystemAxis axis;
    private final DirectionAlongMeridian meridian;
    private final int unitOrder;

    private Normalizer(CoordinateSystemAxis axis, int angularUnitOrder) {
        this.axis = axis;
        this.unitOrder = Units.isAngular(axis.getUnit()) ? angularUnitOrder : 0;
        AxisDirection dir = axis.getDirection();
        this.meridian = AxisDirections.isUserDefined(dir) ? DirectionAlongMeridian.parse(dir) : null;
    }

    private static int order(AxisDirection dir) {
        Integer p = ORDER.get(dir);
        return p != null ? p : dir.ordinal() << 2;
    }

    @Override
    public int compareTo(Normalizer that) {
        int d = this.unitOrder - that.unitOrder;
        if (d == 0) {
            AxisDirection d1 = this.axis.getDirection();
            AxisDirection d2 = that.axis.getDirection();
            d = AxisDirections.angleForCompass(d2, d1);
            if (d == Integer.MIN_VALUE) {
                d = this.meridian != null ? (that.meridian != null ? this.meridian.compareTo(that.meridian) : -1) : (that.meridian != null ? 1 : Normalizer.order(d1) - Normalizer.order(d2));
            }
        }
        return d;
    }

    static boolean sort(CoordinateSystemAxis[] axes, int angularUnitOrder) {
        Object[] wrappers = new Normalizer[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            wrappers[i] = new Normalizer(axes[i], angularUnitOrder);
        }
        Arrays.sort(wrappers);
        boolean changed = false;
        for (int i = 0; i < axes.length; ++i) {
            CoordinateSystemAxis a = ((Normalizer)wrappers[i]).axis;
            changed |= axes[i] != a;
            axes[i] = a;
        }
        return changed;
    }

    static CoordinateSystemAxis normalize(CoordinateSystemAxis axis, AxisFilter changes) {
        Unit<?> unit = axis.getUnit();
        AxisDirection direction = axis.getDirection();
        Unit<?> newUnit = changes.getUnitReplacement(axis, unit);
        AxisDirection newDir = changes.getDirectionReplacement(axis, direction);
        boolean sameDirection = newDir.equals(direction);
        if (sameDirection && newUnit.equals(unit)) {
            return axis;
        }
        String abbreviation = axis.getAbbreviation();
        String newAbbr = sameDirection ? abbreviation : AxisDirections.suggestAbbreviation(axis.getName().getCode(), newDir, newUnit);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (newAbbr.equals(abbreviation)) {
            properties.putAll(IdentifiedObjects.getProperties(axis, EXCLUDES));
        } else {
            properties.put("name", NilReferencingObject.UNNAMED);
        }
        if (sameDirection || newDir.equals(AxisDirections.opposite(direction))) {
            UnitConverter c;
            try {
                c = unit.getConverterToAny(newUnit);
            }
            catch (ConversionException e) {
                throw new IllegalStateException(Errors.format((short)43, "axis", unit), e);
            }
            double minimum = c.convert(axis.getMinimumValue());
            double maximum = c.convert(axis.getMaximumValue());
            if (!sameDirection) {
                double tmp = minimum;
                minimum = -maximum;
                maximum = -tmp;
            }
            properties.put("minimumValue", minimum);
            properties.put("maximumValue", maximum);
            properties.put("rangeMeaning", axis.getRangeMeaning());
        }
        return new DefaultCoordinateSystemAxis(properties, newAbbr, newDir, newUnit);
    }

    static AbstractCS normalize(CoordinateSystem cs, AxisFilter changes, boolean reorder) {
        boolean changed = false;
        int dimension = cs.getDimension();
        Object[] axes = new CoordinateSystemAxis[dimension];
        int n = 0;
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis axis = cs.getAxis(i);
            if (changes != null) {
                if (!changes.accept(axis)) continue;
                changed |= axis != (axis = Normalizer.normalize(axis, changes));
            }
            axes[n++] = axis;
        }
        axes = ArraysExt.resize(axes, n);
        if (reorder) {
            int angularUnitOrder = 0;
            if (cs instanceof EllipsoidalCS || cs instanceof SphericalCS) {
                angularUnitOrder = -1;
            } else if (cs instanceof CylindricalCS || cs instanceof PolarCS) {
                angularUnitOrder = 1;
            }
            changed |= Normalizer.sort((CoordinateSystemAxis[])axes, angularUnitOrder);
            if (angularUnitOrder == 1) {
                if (axes.length == 3 && Normalizer.isLengthAndAngle((CoordinateSystemAxis[])axes, 1)) {
                    ArraysExt.swap(axes, 1, 2);
                }
                if (AxisDirections.CLOCKWISE.equals(axes[1].getDirection()) && Normalizer.isLengthAndAngle((CoordinateSystemAxis[])axes, 0)) {
                    ArraysExt.swap(axes, 0, 1);
                }
            }
        }
        if (!changed && n == dimension) {
            return null;
        }
        AbstractCS impl = Normalizer.castOrCopy(cs);
        StringBuilder buffer = (StringBuilder)CharSequences.camelCaseToSentence(impl.getInterface().getSimpleName());
        return impl.createForAxes(Collections.singletonMap("name", AxisDirections.appendTo(buffer, (CoordinateSystemAxis[])axes)), (CoordinateSystemAxis[])axes);
    }

    private static boolean isLengthAndAngle(CoordinateSystemAxis[] axes, int p) {
        return Units.isLinear(axes[p].getUnit()) && Units.isAngular(axes[p + 1].getUnit());
    }

    private static AbstractCS shiftAxisRange(CoordinateSystem cs) {
        boolean changed = false;
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[cs.getDimension()];
        for (int i = 0; i < axes.length; ++i) {
            double min;
            CoordinateSystemAxis axis = cs.getAxis(i);
            RangeMeaning rangeMeaning = axis.getRangeMeaning();
            if (RangeMeaning.WRAPAROUND.equals(rangeMeaning) && (min = axis.getMinimumValue()) < 0.0) {
                double max = axis.getMaximumValue();
                double offset = (max - min) / 2.0;
                if ((min -= (offset *= Math.floor(min / offset + 1.0E-10))) < (max -= offset)) {
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.putAll(IdentifiedObjects.getProperties(axis, EXCLUDES));
                    properties.put("minimumValue", min);
                    properties.put("maximumValue", max);
                    properties.put("rangeMeaning", rangeMeaning);
                    axis = new DefaultCoordinateSystemAxis(properties, axis.getAbbreviation(), axis.getDirection(), axis.getUnit());
                    changed = true;
                }
            }
            axes[i] = axis;
        }
        if (!changed) {
            return null;
        }
        return Normalizer.castOrCopy(cs).createForAxes(IdentifiedObjects.getProperties(cs, EXCLUDES), axes);
    }

    private static AbstractCS castOrCopy(CoordinateSystem cs) {
        return cs instanceof AbstractCS ? (AbstractCS)cs : AbstractCS.castOrCopy(cs);
    }

    static AbstractCS forConvention(CoordinateSystem cs, AxesConvention convention) {
        switch (convention) {
            case NORMALIZED: 
            case CONVENTIONALLY_ORIENTED: {
                return Normalizer.normalize(cs, convention, true);
            }
            case RIGHT_HANDED: {
                return Normalizer.normalize(cs, null, true);
            }
            case POSITIVE_RANGE: {
                return Normalizer.shiftAxisRange(cs);
            }
        }
        throw new AssertionError(convention);
    }

    static {
        Map<AxisDirection, Integer> m = ORDER = new HashMap<AxisDirection, Integer>();
        int horizontal = AxisDirection.NORTH.ordinal() + 15 << 2;
        m.put(AxisDirections.AWAY_FROM, horizontal + 1);
        m.put(AxisDirections.COUNTER_CLOCKWISE, horizontal + 2);
        m.put(AxisDirections.CLOCKWISE, horizontal + 3);
    }
}

