/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultImageDatum;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.datum.SubTypes;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDatumType", propOrder={"domainOfValidity", "scope", "anchorPoint", "realizationEpoch"})
@XmlRootElement(name="AbstractDatum")
@XmlSeeAlso(value={DefaultGeodeticDatum.class, DefaultVerticalDatum.class, DefaultTemporalDatum.class, DefaultParametricDatum.class, DefaultEngineeringDatum.class, DefaultImageDatum.class})
public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    private static final String ESRI_PREFIX = "D_";
    private InternationalString anchorDefinition;
    private long realizationEpoch;
    private Extent domainOfValidity;
    private InternationalString scope;

    public AbstractDatum(Map<String, ?> properties) {
        super(properties);
        this.realizationEpoch = MetadataUtilities.toMilliseconds(Containers.property(properties, "realizationEpoch", Date.class));
        this.domainOfValidity = Containers.property(properties, "domainOfValidity", Extent.class);
        this.anchorDefinition = Types.toInternationalString(properties, "anchorPoint");
        this.scope = Types.toInternationalString(properties, "scope");
    }

    protected AbstractDatum(Datum datum) {
        super(datum);
        this.realizationEpoch = MetadataUtilities.toMilliseconds(datum.getRealizationEpoch());
        this.domainOfValidity = datum.getDomainOfValidity();
        this.scope = datum.getScope();
        this.anchorDefinition = datum.getAnchorPoint();
    }

    public static AbstractDatum castOrCopy(Datum object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends Datum> getInterface() {
        return Datum.class;
    }

    @Override
    @XmlElement(name="anchorDefinition")
    public InternationalString getAnchorPoint() {
        return this.anchorDefinition;
    }

    @Override
    @XmlSchemaType(name="date")
    @XmlElement(name="realizationEpoch")
    public Date getRealizationEpoch() {
        return MetadataUtilities.toDate(this.realizationEpoch);
    }

    @Override
    @XmlElement(name="domainOfValidity")
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    @XmlElement(name="scope", required=true)
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public boolean isHeuristicMatchForName(String name) {
        return NameToIdentifier.isHeuristicMatchForName(super.getName(), super.getAlias(), name, Simplifier.INSTANCE);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                AbstractDatum that = (AbstractDatum)object;
                return this.realizationEpoch == that.realizationEpoch && Objects.equals(this.domainOfValidity, that.domainOfValidity) && Objects.equals(this.anchorDefinition, that.anchorDefinition) && Objects.equals(this.scope, that.scope);
            }
            case BY_CONTRACT: {
                Datum that = (Datum)object;
                return Utilities.deepEquals(this.getRealizationEpoch(), that.getRealizationEpoch(), mode) && Utilities.deepEquals(this.getDomainOfValidity(), that.getDomainOfValidity(), mode) && Utilities.deepEquals(this.getAnchorPoint(), that.getAnchorPoint(), mode) && Utilities.deepEquals(this.getScope(), that.getScope(), mode);
            }
        }
        Datum that = (Datum)object;
        Boolean match = Citations.hasCommonIdentifier(this.getIdentifiers(), that.getIdentifiers());
        if (match != null) {
            return match;
        }
        return this.isHeuristicMatchForName(that.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName(that, this.getName().getCode());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.anchorDefinition, this.realizationEpoch, this.domainOfValidity, this.scope);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Citation authority = formatter.getNameAuthority();
        String name = IdentifiedObjects.getName(this, authority);
        if (name == null) {
            name = IdentifiedObjects.getName(this, null);
            if (name == null) {
                return super.formatTo(formatter);
            }
            if ("ESRI".equalsIgnoreCase(Citations.getCodeSpace(authority)) && !name.startsWith(ESRI_PREFIX)) {
                name = ESRI_PREFIX + name;
            }
        }
        formatter.append(name, ElementKind.DATUM);
        return null;
    }

    AbstractDatum() {
        super(NilReferencingObject.INSTANCE);
        this.realizationEpoch = Long.MIN_VALUE;
    }

    private void setAnchorPoint(InternationalString value) {
        if (this.anchorDefinition == null) {
            this.anchorDefinition = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDatum.class, "setAnchorPoint", "anchorDefinition");
        }
    }

    private void setRealizationEpoch(Date value) {
        if (this.realizationEpoch == Long.MIN_VALUE) {
            this.realizationEpoch = value.getTime();
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDatum.class, "setRealizationEpoch", "realizationEpoch");
        }
    }

    private void setDomainOfValidity(Extent value) {
        if (this.domainOfValidity == null) {
            this.domainOfValidity = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDatum.class, "setDomainOfValidity", "domainOfValidity");
        }
    }

    private void setScope(InternationalString value) {
        if (this.scope == null) {
            this.scope = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDatum.class, "setScope", "scope");
        }
    }

    static class Simplifier
    extends NameToIdentifier.Simplifier {
        static final Simplifier INSTANCE = new Simplifier();

        Simplifier() {
        }

        @Override
        protected CharSequence apply(CharSequence name) {
            if (CharSequences.startsWith(name = super.apply(name), AbstractDatum.ESRI_PREFIX, false)) {
                name = name.subSequence(AbstractDatum.ESRI_PREFIX.length(), name.length());
            }
            return name;
        }
    }
}

