/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class DatumShiftGrid<C extends Quantity, T extends Quantity>
implements Serializable {
    private static final long serialVersionUID = 8405276545243175808L;
    private final Unit<C> coordinateUnit;
    private final LinearTransform coordinateToGrid;
    private final Unit<T> translationUnit;
    private final boolean isCellValueRatio;
    private final int[] gridSize;
    private transient double scaleX;
    private transient double scaleY;
    private transient double x0;
    private transient double y0;

    protected DatumShiftGrid(Unit<C> coordinateUnit, LinearTransform coordinateToGrid, int[] gridSize, boolean isCellValueRatio, Unit<T> translationUnit) {
        ArgumentChecks.ensureNonNull("coordinateUnit", coordinateUnit);
        ArgumentChecks.ensureNonNull("coordinateToGrid", coordinateToGrid);
        ArgumentChecks.ensureNonNull("gridSize", gridSize);
        ArgumentChecks.ensureNonNull("translationUnit", translationUnit);
        int n = coordinateToGrid.getTargetDimensions();
        if (n != gridSize.length) {
            throw new MismatchedDimensionException(Errors.format((short)59, "gridSize", n, gridSize.length));
        }
        this.coordinateUnit = coordinateUnit;
        this.coordinateToGrid = coordinateToGrid;
        this.isCellValueRatio = isCellValueRatio;
        this.translationUnit = translationUnit;
        gridSize = (int[])gridSize.clone();
        this.gridSize = gridSize;
        for (int i = 0; i < gridSize.length; ++i) {
            n = gridSize[i];
            if (n >= 2) continue;
            throw new IllegalArgumentException(Errors.format(n <= 0 ? (short)132 : 31, "gridSize[" + i + ']', n));
        }
        this.computeConversionFactors();
    }

    private void computeConversionFactors() {
        Matrix m;
        this.scaleX = Double.NaN;
        this.scaleY = Double.NaN;
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        UnitConverter c = this.coordinateUnit.toSI().getConverterTo(this.coordinateUnit);
        if (c instanceof LinearConverter && c.convert(0.0) == 0.0 && Matrices.isAffine(m = this.coordinateToGrid.getMatrix())) {
            int n = m.getNumCol() - 1;
            double toUnit = Units.derivative(c, 0.0);
            switch (m.getNumRow()) {
                default: {
                    this.y0 = m.getElement(1, n);
                    this.scaleY = DatumShiftGrid.diagonal(m, 1, n) * toUnit;
                }
                case 1: {
                    this.x0 = m.getElement(0, n);
                    this.scaleX = DatumShiftGrid.diagonal(m, 0, n) * toUnit;
                }
                case 0: 
            }
        }
    }

    private static double diagonal(Matrix m, int j, int n) {
        while (--n >= 0) {
            if (j == n || m.getElement(j, n) == 0.0) continue;
            return Double.NaN;
        }
        return m.getElement(j, j);
    }

    protected DatumShiftGrid(DatumShiftGrid<C, T> other) {
        ArgumentChecks.ensureNonNull("other", other);
        this.coordinateUnit = other.coordinateUnit;
        this.coordinateToGrid = other.coordinateToGrid;
        this.isCellValueRatio = other.isCellValueRatio;
        this.translationUnit = other.translationUnit;
        this.gridSize = other.gridSize;
        this.scaleX = other.scaleX;
        this.scaleY = other.scaleY;
        this.x0 = other.x0;
        this.y0 = other.y0;
    }

    public int[] getGridSize() {
        return (int[])this.gridSize.clone();
    }

    public Envelope getDomainOfValidity() throws TransformException {
        GeneralEnvelope env = new GeneralEnvelope(this.gridSize.length);
        for (int i = 0; i < this.gridSize.length; ++i) {
            env.setRange(i, -0.5, (double)this.gridSize[i] - 0.5);
        }
        return Envelopes.transform(this.getCoordinateToGrid().inverse(), (Envelope)env);
    }

    public Unit<C> getCoordinateUnit() {
        return this.coordinateUnit;
    }

    public LinearTransform getCoordinateToGrid() {
        return this.coordinateToGrid;
    }

    public final double normalizedToGridX(double x) {
        return x * this.scaleX + this.x0;
    }

    public final double normalizedToGridY(double y) {
        return y * this.scaleY + this.y0;
    }

    public abstract int getTranslationDimensions();

    public Unit<T> getTranslationUnit() {
        return this.translationUnit;
    }

    public double[] interpolateAt(double ... ordinates) throws TransformException {
        LinearTransform c = this.getCoordinateToGrid();
        ArgumentChecks.ensureDimensionMatches("ordinates", c.getSourceDimensions(), ordinates);
        int dim = this.getTranslationDimensions();
        double[] vector = new double[Math.max(dim, c.getTargetDimensions())];
        c.transform(ordinates, 0, vector, 0, 1);
        this.interpolateInCell(vector[0], vector[1], vector);
        if (this.isCellValueRatio()) {
            c.inverse().deltaTransform(vector, 0, vector, 0, 1);
        }
        if (vector.length != dim) {
            vector = Arrays.copyOf(vector, dim);
        }
        return vector;
    }

    public void interpolateInCell(double gridX, double gridY, double[] vector) {
        int n;
        int ix = (int)gridX;
        gridX -= (double)ix;
        int iy = (int)gridY;
        gridY -= (double)iy;
        if (ix < 0) {
            ix = 0;
            gridX = -1.0;
        } else {
            n = this.gridSize[0] - 2;
            if (ix > n) {
                ix = n;
                gridX = 1.0;
            }
        }
        if (iy < 0) {
            iy = 0;
            gridY = -1.0;
        } else {
            n = this.gridSize[1] - 2;
            if (iy > n) {
                iy = n;
                gridY = 1.0;
            }
        }
        n = this.getTranslationDimensions();
        for (int dim = 0; dim < n; ++dim) {
            double r0 = this.getCellValue(dim, ix, iy);
            double r1 = this.getCellValue(dim, ix, iy + 1);
            r0 += gridX * (this.getCellValue(dim, ix + 1, iy) - r0);
            r1 += gridX * (this.getCellValue(dim, ix + 1, iy + 1) - r1);
            vector[dim] = gridY * (r1 - r0) + r0;
        }
    }

    public Matrix derivativeInCell(double gridX, double gridY) {
        int ix = Math.max(0, Math.min(this.gridSize[0] - 2, (int)gridX));
        int iy = Math.max(0, Math.min(this.gridSize[1] - 2, (int)gridY));
        MatrixSIS derivative = Matrices.createDiagonal(this.getTranslationDimensions(), this.gridSize.length);
        int j = derivative.getNumRow();
        while (--j >= 0) {
            double orig = this.getCellValue(j, iy, ix);
            derivative.setElement(j, 0, derivative.getElement(j, 0) + (this.getCellValue(j, iy + 1, ix) - orig));
            derivative.setElement(j, 1, derivative.getElement(j, 1) + (this.getCellValue(j, iy, ix + 1) - orig));
        }
        return derivative;
    }

    public abstract double getCellValue(int var1, int var2, int var3);

    public double getCellMean(int dim) {
        DoubleDouble sum = new DoubleDouble();
        int nx = this.gridSize[0];
        int ny = this.gridSize[1];
        for (int gridY = 0; gridY < ny; ++gridY) {
            for (int gridX = 0; gridX < nx; ++gridX) {
                sum.add(this.getCellValue(dim, gridX, gridY));
            }
        }
        return sum.value / (double)(nx * ny);
    }

    public abstract double getCellPrecision();

    public boolean isCellValueRatio() {
        return this.isCellValueRatio;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            DatumShiftGrid that = (DatumShiftGrid)other;
            return Arrays.equals(this.gridSize, that.gridSize) && Objects.equals(this.coordinateToGrid, that.coordinateToGrid) && Objects.equals(this.coordinateUnit, that.coordinateUnit) && Objects.equals(this.translationUnit, that.translationUnit) && this.isCellValueRatio == that.isCellValueRatio;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.coordinateToGrid) + 37 * Arrays.hashCode(this.gridSize);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeConversionFactors();
    }
}

