/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.internal.jaxb.referencing.SecondDefiningParameter;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.Sphere;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.datum.Ellipsoid;

@XmlType(name="EllipsoidType", propOrder={"semiMajorAxisMeasure", "secondDefiningParameter"})
@XmlRootElement(name="Ellipsoid")
public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    private static final int MAX_ITERATIONS = 100;
    private static final double EPS = 5.0E-14;
    private static final double COMPARISON_THRESHOLD = 1.0E-10;
    private double semiMajorAxis;
    private double semiMinorAxis;
    private double inverseFlattening;
    private boolean ivfDefinitive;
    private Unit<Length> unit;

    protected DefaultEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, double inverseFlattening, boolean ivfDefinitive, Unit<Length> unit) {
        super(properties);
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureStrictlyPositive("semiMajorAxis", semiMajorAxis);
        ArgumentChecks.ensureStrictlyPositive("semiMinorAxis", semiMinorAxis);
        ArgumentChecks.ensureStrictlyPositive("inverseFlattening", inverseFlattening);
        this.unit = unit;
        this.semiMajorAxis = semiMajorAxis;
        this.semiMinorAxis = semiMinorAxis;
        this.inverseFlattening = inverseFlattening;
        this.ivfDefinitive = ivfDefinitive;
    }

    protected DefaultEllipsoid(Ellipsoid ellipsoid) {
        super(ellipsoid);
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        this.inverseFlattening = ellipsoid.getInverseFlattening();
        this.ivfDefinitive = ellipsoid.isIvfDefinitive();
        this.unit = ellipsoid.getAxisUnit();
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) {
        if (semiMajorAxis == semiMinorAxis) {
            return new Sphere(properties, semiMajorAxis, false, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, semiMinorAxis, Formulas.getInverseFlattening(semiMajorAxis, semiMinorAxis), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> properties, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) {
        if (Double.isInfinite(inverseFlattening)) {
            return new Sphere(properties, semiMajorAxis, true, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, Formulas.getSemiMinor(semiMajorAxis, inverseFlattening), inverseFlattening, true, unit);
    }

    public static DefaultEllipsoid castOrCopy(Ellipsoid object) {
        if (object == null || object instanceof DefaultEllipsoid) {
            return (DefaultEllipsoid)object;
        }
        Map<String, ?> properties = IdentifiedObjects.getProperties(object, new String[0]);
        double semiMajor = object.getSemiMajorAxis();
        Unit<Length> unit = object.getAxisUnit();
        return object.isIvfDefinitive() ? DefaultEllipsoid.createFlattenedSphere(properties, semiMajor, object.getInverseFlattening(), unit) : DefaultEllipsoid.createEllipsoid(properties, semiMajor, object.getSemiMinorAxis(), unit);
    }

    public Class<? extends Ellipsoid> getInterface() {
        return Ellipsoid.class;
    }

    @Override
    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    @Override
    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    @Override
    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getAuthalicRadius() {
        return Formulas.getAuthalicRadius(this.getSemiMajorAxis(), this.getSemiMinorAxis());
    }

    public double getEccentricity() {
        DoubleDouble e = this.eccentricitySquared();
        e.sqrt();
        return e.value;
    }

    public double getEccentricitySquared() {
        return this.eccentricitySquared().value;
    }

    private DoubleDouble eccentricitySquared() {
        DoubleDouble f = DefaultEllipsoid.flattening(this);
        DoubleDouble eccentricitySquared = new DoubleDouble(f);
        eccentricitySquared.multiply(2.0, 0.0);
        f.square();
        eccentricitySquared.subtract(f);
        return eccentricitySquared;
    }

    private static DoubleDouble flattening(Ellipsoid e) {
        DoubleDouble f;
        if (e.isIvfDefinitive()) {
            f = new DoubleDouble(e.getInverseFlattening());
            f.inverseDivide(1.0, 0.0);
        } else {
            f = new DoubleDouble(e.getSemiMajorAxis());
            double value = f.value;
            double error = f.error;
            f.subtract(e.getSemiMinorAxis());
            f.divide(value, error);
        }
        return f;
    }

    @Override
    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    @Override
    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    @Override
    public boolean isSphere() {
        return this.semiMajorAxis == this.semiMinorAxis;
    }

    public double orthodromicDistance(double \u03bb1, double \u03c61, double \u03bb2, double \u03c62) {
        \u03bb1 = Math.toRadians(\u03bb1);
        \u03c61 = Math.toRadians(\u03c61);
        \u03bb2 = Math.toRadians(\u03bb2);
        \u03c62 = Math.toRadians(\u03c62);
        double F = 1.0 / this.getInverseFlattening();
        double R = 1.0 - F;
        double tu1 = R * Math.tan(\u03c61);
        double tu2 = R * Math.tan(\u03c62);
        double cu1 = 1.0 / Math.sqrt(tu1 * tu1 + 1.0);
        double cu2 = 1.0 / Math.sqrt(tu2 * tu2 + 1.0);
        double su1 = cu1 * tu1;
        double s = cu1 * cu2;
        double baz = s * tu2;
        double faz = baz * tu1;
        double x = \u03bb2 - \u03bb1;
        for (int i = 0; i < 100; ++i) {
            double sx = Math.sin(x);
            double cx = Math.cos(x);
            tu1 = cu2 * sx;
            tu2 = baz - su1 * cu2 * cx;
            double sy = Math.hypot(tu1, tu2);
            double cy = s * cx + faz;
            double y = Math.atan2(sy, cy);
            double SA = s * (sx / sy);
            double c2a = 1.0 - SA * SA;
            double cz = 2.0 * faz;
            if (c2a > 0.0) {
                cz = -cz / c2a + cy;
            }
            double e = cz * cz * 2.0 - 1.0;
            double c = ((-3.0 * c2a + 4.0) * F + 4.0) * c2a * F / 16.0;
            double d = x;
            x = ((e * cy * c + cz) * sy * c + y) * SA;
            if (!(Math.abs(d - (x = (1.0 - c) * x * F + \u03bb2 - \u03bb1)) <= 5.0E-14)) continue;
            x = Math.sqrt((1.0 / (R * R) - 1.0) * c2a + 1.0) + 1.0;
            x = (x - 2.0) / x;
            c = 1.0 - x;
            c = (x * x / 4.0 + 1.0) / c;
            d = (0.375 * x * x - 1.0) * x;
            x = e * cy;
            s = 1.0 - 2.0 * e;
            s = ((((sy * sy * 4.0 - 3.0) * s * cz * d / 6.0 - x) * d / 4.0 + cz) * sy * d + y) * c * R * this.getSemiMajorAxis();
            return s;
        }
        if (Math.abs(\u03bb1 - \u03bb2) <= 1.0E-10 && Math.abs(\u03c61 - \u03c62) <= 1.0E-10) {
            return 0.0;
        }
        if (Math.abs(\u03c61) <= 1.0E-10 && Math.abs(\u03c62) <= 1.0E-10) {
            return Math.abs(\u03bb1 - \u03bb2) * this.getSemiMajorAxis();
        }
        if (Double.isNaN(\u03bb1) || Double.isNaN(\u03c61) || Double.isNaN(\u03bb2) || Double.isNaN(\u03c62)) {
            return Double.NaN;
        }
        throw new ArithmeticException(Errors.format((short)69, new DirectPosition2D(Math.toDegrees(\u03bb1), Math.toDegrees(\u03c61)), new DirectPosition2D(Math.toDegrees(\u03bb2), Math.toDegrees(\u03c62))));
    }

    public double semiMajorAxisDifference(Ellipsoid other) {
        double semiMajor = other.getSemiMajorAxis();
        semiMajor = other.getAxisUnit().getConverterTo(this.getAxisUnit()).convert(semiMajor);
        DoubleDouble a = new DoubleDouble(semiMajor);
        a.subtract(this.getSemiMajorAxis());
        return a.value;
    }

    public double flatteningDifference(Ellipsoid other) {
        DoubleDouble f = DefaultEllipsoid.flattening(other);
        f.subtract(DefaultEllipsoid.flattening(this));
        return f.value;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                DefaultEllipsoid that = (DefaultEllipsoid)object;
                return this.ivfDefinitive == that.ivfDefinitive && Numerics.equals(this.semiMajorAxis, that.semiMajorAxis) && Numerics.equals(this.semiMinorAxis, that.semiMinorAxis) && Numerics.equals(this.inverseFlattening, that.inverseFlattening) && Objects.equals(this.unit, that.unit);
            }
            case BY_CONTRACT: {
                if (this.isIvfDefinitive() != ((Ellipsoid)object).isIvfDefinitive()) {
                    return false;
                }
            }
            case IGNORE_METADATA: {
                if (Numerics.equals(this.getInverseFlattening(), ((Ellipsoid)object).getInverseFlattening())) break;
                return false;
            }
        }
        Ellipsoid that = (Ellipsoid)object;
        Unit<Length> unit = this.getAxisUnit();
        if (!Objects.equals(unit, that.getAxisUnit())) {
            return false;
        }
        UnitConverter c = mode.isApproximative() ? unit.getConverterTo(SI.METRE) : null;
        boolean isMinor = false;
        double v1 = this.getSemiMajorAxis();
        double v2 = that.getSemiMajorAxis();
        if (c == null ? Numerics.equals(v1, v2) : Numerics.epsilonEqual(c.convert(v1), c.convert(v2), 0.01)) {
            isMinor = true;
            v1 = this.getSemiMinorAxis();
            v2 = that.getSemiMinorAxis();
            if (c == null ? Numerics.equals(v1, v2) : Numerics.epsilonEqual(c.convert(v1), c.convert(v2), 0.01)) {
                return true;
            }
        }
        assert (mode != ComparisonMode.DEBUG) : Numerics.messageForDifference(isMinor ? "semiMinorAxis" : "semiMajorAxis", v1, v2);
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + Double.doubleToLongBits(this.semiMajorAxis) + 31L * Double.doubleToLongBits(this.ivfDefinitive ? this.inverseFlattening : this.semiMinorAxis);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        Unit<Length> unit = this.getAxisUnit();
        double length = this.getSemiMajorAxis();
        if (isWKT1) {
            length = unit.getConverterTo(SI.METRE).convert(length);
        }
        formatter.append(length);
        double inverseFlattening = this.getInverseFlattening();
        formatter.append(Double.isInfinite(inverseFlattening) ? 0.0 : inverseFlattening);
        if (isWKT1) {
            return "Spheroid";
        }
        if (!convention.isSimplified() || !SI.METRE.equals(unit)) {
            formatter.append(unit);
        }
        return "Ellipsoid";
    }

    private DefaultEllipsoid() {
        super(NilReferencingObject.INSTANCE);
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.ivfDefinitive) {
            if (this.semiMinorAxis == 0.0) {
                this.semiMinorAxis = Formulas.getSemiMinor(this.semiMajorAxis, this.inverseFlattening);
            }
        } else if (this.inverseFlattening == 0.0) {
            this.inverseFlattening = Formulas.getInverseFlattening(this.semiMajorAxis, this.semiMinorAxis);
        }
        if (this.unit == null) {
            this.unit = SI.METRE;
            Measure.missingUOM(DefaultEllipsoid.class, "semiMajorAxis");
        }
    }

    @XmlElement(name="semiMajorAxis", required=true)
    private Measure getSemiMajorAxisMeasure() {
        return new Measure(this.semiMajorAxis, this.unit);
    }

    private void setSemiMajorAxisMeasure(Measure measure) {
        if (this.semiMajorAxis == 0.0) {
            Unit<Length> uom = this.unit;
            this.semiMajorAxis = measure.value;
            ArgumentChecks.ensureStrictlyPositive("semiMajorAxis", this.semiMajorAxis);
            this.unit = measure.getUnit(Length.class);
            this.harmonizeAxisUnits(uom);
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultEllipsoid.class, "setSemiMajorAxisMeasure", "semiMajorAxis");
        }
    }

    @XmlElement(name="secondDefiningParameter", required=true)
    private SecondDefiningParameter getSecondDefiningParameter() {
        return new SecondDefiningParameter(this, true);
    }

    private void setSecondDefiningParameter(SecondDefiningParameter second) {
        while (second.secondDefiningParameter != null) {
            second = second.secondDefiningParameter;
        }
        Measure measure = second.measure;
        if (measure != null) {
            boolean isIvfDefinitive = second.isIvfDefinitive();
            if ((isIvfDefinitive ? this.inverseFlattening : this.semiMinorAxis) == 0.0) {
                this.ivfDefinitive = isIvfDefinitive;
                double value = measure.value;
                if (isIvfDefinitive) {
                    if (value == 0.0) {
                        value = Double.POSITIVE_INFINITY;
                    }
                    this.inverseFlattening = value;
                    ArgumentChecks.ensureStrictlyPositive("inverseFlattening", this.inverseFlattening);
                } else if (this.semiMinorAxis == 0.0) {
                    this.semiMinorAxis = value;
                    ArgumentChecks.ensureStrictlyPositive("semiMinorAxis", this.semiMinorAxis);
                    this.harmonizeAxisUnits(measure.getUnit(Length.class));
                }
            } else {
                MetadataUtilities.propertyAlreadySet(DefaultEllipsoid.class, "setSecondDefiningParameter", "secondDefiningParameter");
            }
        }
    }

    private void harmonizeAxisUnits(Unit<Length> uom) {
        if (this.unit == null) {
            this.unit = uom;
        } else if (uom != null && uom != this.unit) {
            this.semiMinorAxis = uom.getConverterTo(this.unit).convert(this.semiMinorAxis);
        }
    }
}

