/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.opengis.referencing.datum.Ellipsoid;

@XmlTransient
final class Sphere
extends DefaultEllipsoid {
    private static final long serialVersionUID = 7867565381280669821L;

    protected Sphere(Map<String, ?> properties, double radius, boolean ivfDefinitive, Unit<Length> unit) {
        super(properties, radius, radius, Double.POSITIVE_INFINITY, ivfDefinitive, unit);
    }

    @Override
    public boolean isSphere() {
        return true;
    }

    @Override
    public double getAuthalicRadius() {
        return this.getSemiMajorAxis();
    }

    @Override
    public double getEccentricity() {
        return 0.0;
    }

    @Override
    public double getEccentricitySquared() {
        return 0.0;
    }

    @Override
    public double flatteningDifference(Ellipsoid other) {
        return 1.0 / other.getInverseFlattening();
    }

    @Override
    public double orthodromicDistance(double \u03bb1, double \u03c61, double \u03bb2, double \u03c62) {
        \u03c61 = Math.toRadians(\u03c61);
        \u03c62 = Math.toRadians(\u03c62);
        double dx = Math.toRadians(Math.abs(\u03bb2 - \u03bb1) % 360.0);
        double rho = Math.sin(\u03c61) * Math.sin(\u03c62) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.cos(dx);
        assert (Math.abs(rho) < 1.0000001) : rho;
        if (rho > 1.0) {
            rho = 1.0;
        }
        if (rho < -1.0) {
            rho = -1.0;
        }
        return Math.acos(rho) * this.getSemiMajorAxis();
    }
}

