/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.io.PrintWriter;
import java.lang.ref.PhantomReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.AutoCloseable;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.internal.system.Shutdown;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.CacheRecord;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.PerformanceLevel;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

@AutoCloseable
public abstract class ConcurrentAuthorityFactory<DAO extends GeodeticAuthorityFactory>
extends GeodeticAuthorityFactory {
    private static final long DURATION_FOR_LOGGING = 10000000L;
    private volatile transient Citation authority;
    private final Map<Class<?>, Boolean> inherited = new IdentityHashMap();
    private final Cache<Key, Object> cache;
    private final Map<IdentifiedObject, FindEntry> findPool = new WeakHashMap<IdentifiedObject, FindEntry>();
    private final ThreadLocal<DataAccessRef<DAO>> currentDAO = new ThreadLocal();
    private final Deque<DataAccessRef<DAO>> availableDAOs = new LinkedList<DataAccessRef<DAO>>();
    private int remainingDAOs;
    private boolean isCleanScheduled;
    private long timeout = 60000000000L;
    static final long TIMEOUT_RESOLUTION = 200000000L;

    protected ConcurrentAuthorityFactory(Class<DAO> dataAccessClass) {
        this(dataAccessClass, 100, 8);
    }

    protected ConcurrentAuthorityFactory(Class<DAO> dataAccessClass, int maxStrongReferences, int maxConcurrentQueries) {
        ArgumentChecks.ensureNonNull("dataAccessClass", dataAccessClass);
        ArgumentChecks.ensurePositive("maxStrongReferences", maxStrongReferences);
        ArgumentChecks.ensureStrictlyPositive("maxConcurrentQueries", maxConcurrentQueries);
        for (Method method : dataAccessClass.getMethods()) {
            Class<?>[] p;
            if (method.getDeclaringClass() != GeodeticAuthorityFactory.class || !method.getName().startsWith("create") || (p = method.getParameterTypes()).length != 1 || p[0] != String.class) continue;
            this.inherited.put(method.getReturnType(), Boolean.TRUE);
        }
        this.remainingDAOs = maxConcurrentQueries;
        this.cache = new Cache(20, maxStrongReferences, false);
        this.cache.setKeyCollisionAllowed(true);
        Shutdown.register(new ShutdownHook(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int countAvailableDataAccess() {
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            return this.availableDAOs.size();
        }
    }

    protected abstract DAO newDataAccess() throws UnavailableFactoryException, FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DAO getDataAccess() throws FactoryException {
        DataAccessRef<DAO> usage = this.currentDAO.get();
        if (usage == null) {
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                while (this.remainingDAOs == 0) {
                    try {
                        this.availableDAOs.wait(200000000L);
                    }
                    catch (InterruptedException e) {
                        throw new FactoryException(e.getLocalizedMessage(), e);
                    }
                }
                usage = this.availableDAOs.pollLast();
                --this.remainingDAOs;
            }
            try {
                if (usage == null) {
                    DAO factory = this.newDataAccess();
                    if (factory == null) {
                        UnavailableFactoryException e = new UnavailableFactoryException(Errors.format((short)205, GeodeticAuthorityFactory.class));
                        e.setUnavailableFactory(this);
                        throw e;
                    }
                    usage = new DataAccessRef<DAO>(factory);
                }
                assert (usage.depth == 0) : usage;
                usage.timestamp = System.nanoTime();
            }
            catch (Throwable e) {
                Deque<DataAccessRef<DAO>> deque2 = this.availableDAOs;
                synchronized (deque2) {
                    ++this.remainingDAOs;
                }
                if (e instanceof FactoryException) {
                    throw (FactoryException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException(e);
            }
            this.currentDAO.set(usage);
        }
        ++usage.depth;
        return usage.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(String caller, Class<?> type, String code) {
        DataAccessRef<DAO> usage = this.currentDAO.get();
        if (--usage.depth == 0) {
            this.currentDAO.remove();
            long time = usage.timestamp;
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                ++this.remainingDAOs;
                this.recycle(usage);
                this.availableDAOs.notify();
                time = usage.timestamp - time;
            }
            if (time >= 10000000L && type != null) {
                if (caller == null) {
                    caller = "create".concat(type.getSimpleName());
                }
                Double duration = (double)time / 1.0E9;
                PerformanceLevel level = PerformanceLevel.forDuration(time, TimeUnit.NANOSECONDS);
                Messages resources = Messages.getResources(null);
                LogRecord record = code != null ? resources.getLogRecord(level, (short)33, type, code, duration) : resources.getLogRecord(level, (short)34, type, duration);
                record.setLoggerName("org.apache.sis.referencing.factory");
                Logging.log(this.getClass(), caller, record);
            }
        }
        assert (usage.depth >= 0) : usage;
    }

    private void recycle(DataAccessRef<DAO> usage) {
        usage.timestamp = System.nanoTime();
        this.availableDAOs.addLast(usage);
        if (!this.isCleanScheduled) {
            this.isCleanScheduled = true;
            DelayedExecutor.schedule(new CloseTask(usage.timestamp + this.timeout));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isCleanScheduled() {
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            return this.isCleanScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmClose(List<DAO> factories) {
        assert (!Thread.holdsLock(this.availableDAOs));
        Iterator<DAO> it = factories.iterator();
        while (it.hasNext()) {
            GeodeticAuthorityFactory factory;
            block8: {
                factory = (GeodeticAuthorityFactory)it.next();
                try {
                    if (this.canClose(factory)) {
                    }
                    break block8;
                }
                catch (Exception e) {
                    ConcurrentAuthorityFactory.unexpectedException("canClose", e);
                }
                continue;
            }
            it.remove();
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                this.recycle(new DataAccessRef<GeodeticAuthorityFactory>(factory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeExpired() {
        boolean isEmpty;
        Iterator<Object> it;
        ArrayList factories;
        Object object = this.availableDAOs;
        synchronized (object) {
            factories = new ArrayList(this.availableDAOs.size());
            it = this.availableDAOs.iterator();
            long nanoTime = System.nanoTime();
            while (it.hasNext()) {
                DataAccessRef<DAO> dao = it.next();
                long nextTime = dao.timestamp + this.timeout;
                if (nextTime - nanoTime > 200000000L) {
                    DelayedExecutor.schedule(new CloseTask(nextTime));
                    break;
                }
                factories.add(dao.factory);
                it.remove();
            }
            this.isCleanScheduled = !(isEmpty = this.availableDAOs.isEmpty());
        }
        this.confirmClose(factories);
        try {
            ConcurrentAuthorityFactory.close(factories);
        }
        catch (Exception exception) {
            ConcurrentAuthorityFactory.unexpectedException("closeExpired", exception);
        }
        if (isEmpty) {
            object = this.findPool;
            synchronized (object) {
                it = this.findPool.values().iterator();
                while (it.hasNext()) {
                    if (!((FindEntry)it.next()).cleanup()) continue;
                    it.remove();
                }
            }
        }
    }

    static void unexpectedException(String method, Exception exception) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing.factory"), ConcurrentAuthorityFactory.class, method, exception);
    }

    protected boolean canClose(DAO factory) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout(TimeUnit unit) {
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            return unit.convert(this.timeout, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long delay, TimeUnit unit) {
        ArgumentChecks.ensureStrictlyPositive("delay", delay);
        delay = unit.toNanos(delay);
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            this.timeout = delay;
        }
    }

    @Override
    public Citation getAuthority() {
        Citation c = this.authority;
        if (c == null) {
            try {
                DAO factory = this.getDataAccess();
                try {
                    this.authority = c = ((GeodeticAuthorityFactory)factory).getAuthority();
                }
                finally {
                    this.release("getAuthority", Citation.class, null);
                }
            }
            catch (FactoryException e) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing.factory"), ConcurrentAuthorityFactory.class, "getAuthority", e);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        DAO factory = this.getDataAccess();
        try {
            Set<String> set = factory.getAuthorityCodes(type);
            return set;
        }
        finally {
            this.release("getAuthorityCodes", Set.class, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternationalString getDescriptionText(String code) throws NoSuchAuthorityCodeException, FactoryException {
        DAO factory = this.getDataAccess();
        try {
            InternationalString internationalString = ((GeodeticAuthorityFactory)factory).getDescriptionText(code);
            return internationalString;
        }
        finally {
            this.release("getDescriptionText", InternationalString.class, code);
        }
    }

    private boolean isDefault(Class<?> type) {
        return this.inherited.containsKey(type);
    }

    protected String normalizeCode(String code) throws FactoryException {
        return this.trimNamespace(code);
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OBJECT, code);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        if (this.isDefault(CoordinateReferenceSystem.class)) {
            return super.createCoordinateReferenceSystem(code);
        }
        return this.create(AuthorityFactoryProxy.CRS, code);
    }

    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        if (this.isDefault(GeographicCRS.class)) {
            return super.createGeographicCRS(code);
        }
        return this.create(AuthorityFactoryProxy.GEOGRAPHIC_CRS, code);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        if (this.isDefault(GeocentricCRS.class)) {
            return super.createGeocentricCRS(code);
        }
        return this.create(AuthorityFactoryProxy.GEOCENTRIC_CRS, code);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        if (this.isDefault(ProjectedCRS.class)) {
            return super.createProjectedCRS(code);
        }
        return this.create(AuthorityFactoryProxy.PROJECTED_CRS, code);
    }

    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        if (this.isDefault(VerticalCRS.class)) {
            return super.createVerticalCRS(code);
        }
        return this.create(AuthorityFactoryProxy.VERTICAL_CRS, code);
    }

    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        if (this.isDefault(TemporalCRS.class)) {
            return super.createTemporalCRS(code);
        }
        return this.create(AuthorityFactoryProxy.TEMPORAL_CRS, code);
    }

    @Override
    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        if (this.isDefault(CompoundCRS.class)) {
            return super.createCompoundCRS(code);
        }
        return this.create(AuthorityFactoryProxy.COMPOUND_CRS, code);
    }

    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        if (this.isDefault(DerivedCRS.class)) {
            return super.createDerivedCRS(code);
        }
        return this.create(AuthorityFactoryProxy.DERIVED_CRS, code);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        if (this.isDefault(EngineeringCRS.class)) {
            return super.createEngineeringCRS(code);
        }
        return this.create(AuthorityFactoryProxy.ENGINEERING_CRS, code);
    }

    @Override
    public ImageCRS createImageCRS(String code) throws FactoryException {
        if (this.isDefault(ImageCRS.class)) {
            return super.createImageCRS(code);
        }
        return this.create(AuthorityFactoryProxy.IMAGE_CRS, code);
    }

    @Override
    public Datum createDatum(String code) throws FactoryException {
        if (this.isDefault(Datum.class)) {
            return super.createDatum(code);
        }
        return this.create(AuthorityFactoryProxy.DATUM, code);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        if (this.isDefault(GeodeticDatum.class)) {
            return super.createGeodeticDatum(code);
        }
        return this.create(AuthorityFactoryProxy.GEODETIC_DATUM, code);
    }

    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        if (this.isDefault(VerticalDatum.class)) {
            return super.createVerticalDatum(code);
        }
        return this.create(AuthorityFactoryProxy.VERTICAL_DATUM, code);
    }

    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        if (this.isDefault(TemporalDatum.class)) {
            return super.createTemporalDatum(code);
        }
        return this.create(AuthorityFactoryProxy.TEMPORAL_DATUM, code);
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        if (this.isDefault(EngineeringDatum.class)) {
            return super.createEngineeringDatum(code);
        }
        return this.create(AuthorityFactoryProxy.ENGINEERING_DATUM, code);
    }

    @Override
    public ImageDatum createImageDatum(String code) throws FactoryException {
        if (this.isDefault(ImageDatum.class)) {
            return super.createImageDatum(code);
        }
        return this.create(AuthorityFactoryProxy.IMAGE_DATUM, code);
    }

    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        if (this.isDefault(Ellipsoid.class)) {
            return super.createEllipsoid(code);
        }
        return this.create(AuthorityFactoryProxy.ELLIPSOID, code);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        if (this.isDefault(PrimeMeridian.class)) {
            return super.createPrimeMeridian(code);
        }
        return this.create(AuthorityFactoryProxy.PRIME_MERIDIAN, code);
    }

    @Override
    public Extent createExtent(String code) throws FactoryException {
        if (this.isDefault(Extent.class)) {
            return super.createExtent(code);
        }
        return this.create(AuthorityFactoryProxy.EXTENT, code);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        if (this.isDefault(CoordinateSystem.class)) {
            return super.createCoordinateSystem(code);
        }
        return this.create(AuthorityFactoryProxy.COORDINATE_SYSTEM, code);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        if (this.isDefault(EllipsoidalCS.class)) {
            return super.createEllipsoidalCS(code);
        }
        return this.create(AuthorityFactoryProxy.ELLIPSOIDAL_CS, code);
    }

    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        if (this.isDefault(VerticalCS.class)) {
            return super.createVerticalCS(code);
        }
        return this.create(AuthorityFactoryProxy.VERTICAL_CS, code);
    }

    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        if (this.isDefault(TimeCS.class)) {
            return super.createTimeCS(code);
        }
        return this.create(AuthorityFactoryProxy.TIME_CS, code);
    }

    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        if (this.isDefault(CartesianCS.class)) {
            return super.createCartesianCS(code);
        }
        return this.create(AuthorityFactoryProxy.CARTESIAN_CS, code);
    }

    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        if (this.isDefault(SphericalCS.class)) {
            return super.createSphericalCS(code);
        }
        return this.create(AuthorityFactoryProxy.SPHERICAL_CS, code);
    }

    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        if (this.isDefault(CylindricalCS.class)) {
            return super.createCylindricalCS(code);
        }
        return this.create(AuthorityFactoryProxy.CYLINDRICAL_CS, code);
    }

    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        if (this.isDefault(PolarCS.class)) {
            return super.createPolarCS(code);
        }
        return this.create(AuthorityFactoryProxy.POLAR_CS, code);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        if (this.isDefault(CoordinateSystemAxis.class)) {
            return super.createCoordinateSystemAxis(code);
        }
        return this.create(AuthorityFactoryProxy.AXIS, code);
    }

    @Override
    public Unit<?> createUnit(String code) throws FactoryException {
        if (this.isDefault(Unit.class)) {
            return super.createUnit(code);
        }
        return this.create(AuthorityFactoryProxy.UNIT, code);
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String code) throws FactoryException {
        if (this.isDefault(ParameterDescriptor.class)) {
            return super.createParameterDescriptor(code);
        }
        return this.create(AuthorityFactoryProxy.PARAMETER, code);
    }

    @Override
    public OperationMethod createOperationMethod(String code) throws FactoryException {
        if (this.isDefault(OperationMethod.class)) {
            return super.createOperationMethod(code);
        }
        return this.create(AuthorityFactoryProxy.METHOD, code);
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        if (this.isDefault(CoordinateOperation.class)) {
            return super.createCoordinateOperation(code);
        }
        return this.create(AuthorityFactoryProxy.OPERATION, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T create(AuthorityFactoryProxy<T> proxy, String code) throws FactoryException {
        Object value;
        Class type;
        block7: {
            ArgumentChecks.ensureNonNull("code", code);
            type = proxy.type;
            Key key = new Key(type, this.normalizeCode(code));
            value = this.cache.peek(key);
            if (!type.isInstance(value)) {
                Cache.Handler<Object> handler = this.cache.lock(key);
                try {
                    T result;
                    value = handler.peek();
                    if (type.isInstance(value)) break block7;
                    DAO factory = this.getDataAccess();
                    try {
                        result = proxy.create((GeodeticAuthorityFactory)factory, key.code);
                    }
                    finally {
                        this.release(null, type, code);
                    }
                    value = result;
                    T t = result;
                    return t;
                }
                finally {
                    handler.putAndUnlock(value);
                }
            }
        }
        return type.cast(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws FactoryException {
        Set<CoordinateOperation> value;
        block7: {
            ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
            ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
            Key key = new Key(this.normalizeCode(sourceCRS), this.normalizeCode(targetCRS));
            value = this.cache.peek(key);
            if (!(value instanceof Set)) {
                Cache.Handler<Object> handler = this.cache.lock(key);
                try {
                    value = handler.peek();
                    if (value instanceof Set) break block7;
                    DAO factory = this.getDataAccess();
                    try {
                        value = ((GeodeticAuthorityFactory)factory).createFromCoordinateReferenceSystemCodes(sourceCRS, targetCRS);
                    }
                    finally {
                        this.release("createFromCoordinateReferenceSystemCodes", CoordinateOperation.class, null);
                    }
                }
                finally {
                    handler.putAndUnlock(value);
                }
            }
        }
        return value;
    }

    @Override
    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        return new Finder(this);
    }

    public void printCacheContent(PrintWriter out) {
        CacheRecord.printCacheContent(this.cache, out);
    }

    static <DAO extends GeodeticAuthorityFactory> List<DAO> clear(Deque<DataAccessRef<DAO>> availableDAOs) {
        DataAccessRef<DAO> dao;
        assert (Thread.holdsLock(availableDAOs));
        ArrayList factories = new ArrayList(availableDAOs.size());
        while ((dao = availableDAOs.pollFirst()) != null) {
            factories.add(dao.factory);
        }
        return factories;
    }

    static <DAO extends GeodeticAuthorityFactory> void close(List<DAO> factories) throws Exception {
        Exception exception = null;
        int i = factories.size();
        while (--i >= 0) {
            GeodeticAuthorityFactory factory = (GeodeticAuthorityFactory)factories.get(i);
            if (!JDK7.isAutoCloseable(factory)) continue;
            try {
                JDK7.close(factory);
            }
            catch (Exception e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FactoryException {
        try {
            List<DAO> factories;
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                factories = ConcurrentAuthorityFactory.clear(this.availableDAOs);
            }
            this.confirmClose(factories);
            ConcurrentAuthorityFactory.close(factories);
        }
        catch (Exception e) {
            if (e instanceof FactoryException) {
                throw (FactoryException)e;
            }
            throw new FactoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String s = super.toString();
        DataAccessRef<DAO> usage = this.currentDAO.get();
        if (usage == null) {
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                usage = this.availableDAOs.peekLast();
            }
            if (usage == null) {
                return s;
            }
        }
        return s + JDK7.lineSeparator() + usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void toString(StringBuilder buffer) {
        buffer.append(", cache=").append(this.cache.size()).append(", DAO=");
        Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
        synchronized (deque) {
            buffer.append(this.availableDAOs.size());
            if (this.remainingDAOs <= 0) {
                buffer.append(" (limit reached)");
            }
        }
    }

    private static final class ShutdownHook<DAO extends GeodeticAuthorityFactory>
    extends PhantomReference<ConcurrentAuthorityFactory<DAO>>
    implements Disposable,
    Callable<Object> {
        private final Deque<DataAccessRef<DAO>> availableDAOs;

        ShutdownHook(ConcurrentAuthorityFactory<DAO> factory) {
            super(factory, ReferenceQueueConsumer.QUEUE);
            this.availableDAOs = ((ConcurrentAuthorityFactory)factory).availableDAOs;
        }

        @Override
        public void dispose() {
            Shutdown.unregister(this);
            try {
                this.call();
            }
            catch (Exception exception) {
                ConcurrentAuthorityFactory.unexpectedException("finalize", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            List<DAO> factories;
            Deque<DataAccessRef<DAO>> deque = this.availableDAOs;
            synchronized (deque) {
                factories = ConcurrentAuthorityFactory.clear(this.availableDAOs);
            }
            ConcurrentAuthorityFactory.close(factories);
            return null;
        }
    }

    private static final class FindEntry {
        private Set<IdentifiedObject> strict;
        private Set<IdentifiedObject> lenient;
        private boolean explicitStrict;
        private boolean explicitLenient;

        private FindEntry() {
        }

        Set<IdentifiedObject> get(boolean ignoreAxes) {
            return ignoreAxes ? this.lenient : this.strict;
        }

        Set<IdentifiedObject> set(boolean ignoreAxes, Set<IdentifiedObject> result, boolean explicit) {
            if (ignoreAxes) {
                if (this.lenient != null) {
                    result = this.lenient;
                } else {
                    this.lenient = result;
                }
                this.explicitLenient |= explicit;
            } else {
                if (this.strict != null) {
                    result = this.strict;
                } else {
                    this.strict = result;
                }
                this.explicitStrict |= explicit;
            }
            return result;
        }

        boolean cleanup() {
            if (!this.explicitStrict) {
                this.strict = null;
            }
            if (!this.explicitLenient) {
                this.lenient = null;
            }
            return this.strict == null && this.lenient == null;
        }
    }

    private static final class Finder
    extends IdentifiedObjectFinder {
        private transient IdentifiedObjectFinder finder;
        private transient int acquireCount;
        private transient IdentifiedObject searching;

        Finder(ConcurrentAuthorityFactory<?> factory) {
            super(factory);
        }

        private void acquire() throws FactoryException {
            assert (Thread.holdsLock(this));
            assert (this.acquireCount == 0 == (this.finder == null)) : this.acquireCount;
            if (this.acquireCount == 0) {
                GeodeticAuthorityFactory delegate = ((ConcurrentAuthorityFactory)this.factory).getDataAccess();
                this.acquireCount = 1;
                this.finder = delegate.newIdentifiedObjectFinder();
                this.finder.setWrapper(this);
            } else {
                ++this.acquireCount;
            }
        }

        private void release() {
            assert (Thread.holdsLock(this));
            if (this.acquireCount == 0) {
                return;
            }
            if (--this.acquireCount == 0) {
                this.finder = null;
                ((ConcurrentAuthorityFactory)this.factory).release(null, null, null);
            }
        }

        @Override
        protected synchronized Set<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
            try {
                this.acquire();
                Set<String> set = this.finder.getCodeCandidates(object);
                return set;
            }
            finally {
                this.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Set<IdentifiedObject> getFromCache(IdentifiedObject object) {
            Map findPool;
            Map map = findPool = ((ConcurrentAuthorityFactory)this.factory).findPool;
            synchronized (map) {
                FindEntry entry = (FindEntry)findPool.get(object);
                if (entry != null) {
                    return entry.get((this.finder != null ? this.finder : this).isIgnoringAxes());
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Set<IdentifiedObject> cache(IdentifiedObject object, Set<IdentifiedObject> result) {
            Map findPool = ((ConcurrentAuthorityFactory)this.factory).findPool;
            result = CollectionsExt.unmodifiableOrCopy(result);
            FindEntry entry = new FindEntry();
            Map map = findPool;
            synchronized (map) {
                FindEntry c = JDK8.putIfAbsent(findPool, object, entry);
                if (c != null) {
                    entry = c;
                }
                result = entry.set(this.finder.isIgnoringAxes(), result, object == this.searching);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<IdentifiedObject> find(IdentifiedObject object) throws FactoryException {
            Set<IdentifiedObject> candidate = this.getFromCache(object);
            if (candidate == null) {
                Finder finder = this;
                synchronized (finder) {
                    try {
                        this.acquire();
                        this.searching = object;
                        candidate = this.finder.find(object);
                    }
                    finally {
                        this.searching = null;
                        this.release();
                    }
                }
            }
            return candidate;
        }
    }

    private static final class Key {
        final Object type;
        final String code;

        Key(Object type, String code) {
            this.type = type;
            this.code = code;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.code.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Key) {
                Key that = (Key)other;
                return this.type.equals(that.type) && this.code.equals(that.code);
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.type instanceof Class) {
                buffer.append("Code[\u201c").append(this.code);
                if (buffer.length() > 15) {
                    buffer.setLength(15);
                    buffer.append('\u2026');
                }
                buffer.append("\u201d : ").append(((Class)this.type).getSimpleName());
            } else {
                buffer.append("CodePair[\u201c").append(this.type).append("\u201d \u2192 \u201c").append(this.code).append('\u201d');
            }
            return buffer.append(']').toString();
        }
    }

    private final class CloseTask
    extends DelayedRunnable {
        CloseTask(long timestamp) {
            super(timestamp);
        }

        @Override
        public void run() {
            ConcurrentAuthorityFactory.this.closeExpired();
        }
    }

    private static final class DataAccessRef<DAO extends GeodeticAuthorityFactory> {
        final DAO factory;
        int depth;
        long timestamp;

        DataAccessRef(DAO factory) {
            this.factory = factory;
        }

        public String toString() {
            Number value;
            String text;
            if (this.depth != 0) {
                text = "%s in use at depth %d";
                value = this.depth;
            } else {
                text = "%s made available %d seconds ago";
                value = Math.round((double)(System.nanoTime() - this.timestamp) / 1.0E9);
            }
            return String.format(text, Classes.getShortClassName(this.factory), value);
        }
    }
}

