/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Iterator;
import java.util.Map;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.referencing.factory.CommonAuthorityFactory;

final class FilteredCodes
extends AbstractMap<String, Boolean> {
    final Map<String, Class<?>> codes;
    final Class<?> type;

    FilteredCodes(Map<String, Class<?>> codes, Class<?> type) {
        this.codes = codes;
        this.type = type;
    }

    @Override
    protected AbstractMap.EntryIterator<String, Boolean> entryIterator() {
        return new AbstractMap.EntryIterator<String, Boolean>(){
            private final Iterator<Map.Entry<String, Class<?>>> it;
            private String code;
            {
                this.it = FilteredCodes.this.codes.entrySet().iterator();
            }

            @Override
            protected boolean next() {
                while (this.it.hasNext()) {
                    Map.Entry<String, Class<?>> entry = this.it.next();
                    if (!FilteredCodes.this.type.isAssignableFrom(entry.getValue())) continue;
                    this.code = entry.getKey();
                    return true;
                }
                return false;
            }

            @Override
            protected String getKey() {
                return this.code;
            }

            @Override
            protected Boolean getValue() {
                return Boolean.TRUE;
            }
        };
    }

    @Override
    public Boolean get(Object key) {
        Class<?> t = this.codes.get(key);
        if (t == null && key instanceof String && (t = this.codes.get(CommonAuthorityFactory.reformat((String)key))) == null) {
            return null;
        }
        return this.type.isAssignableFrom(t) ? Boolean.TRUE : null;
    }
}

