/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Collections;
import java.util.Set;
import javax.measure.unit.Unit;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public abstract class GeodeticAuthorityFactory
extends AbstractFactory
implements AuthorityFactory {
    protected GeodeticAuthorityFactory() {
    }

    @Override
    public abstract Citation getAuthority();

    public Set<String> getCodeSpaces() {
        String authority = Citations.getCodeSpace(this.getAuthority());
        return authority != null ? Collections.singleton(authority) : Collections.emptySet();
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        return new SimpleInternationalString(this.createObject(code).getName().getCode());
    }

    @Override
    public abstract IdentifiedObject createObject(String var1) throws NoSuchAuthorityCodeException, FactoryException;

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CoordinateReferenceSystem.class, this.createObject(code), code);
    }

    public GeographicCRS createGeographicCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(GeographicCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public GeocentricCRS createGeocentricCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(GeocentricCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public ProjectedCRS createProjectedCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(ProjectedCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public VerticalCRS createVerticalCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(VerticalCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public TemporalCRS createTemporalCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(TemporalCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public DefaultParametricCRS createParametricCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(DefaultParametricCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public CompoundCRS createCompoundCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CompoundCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public DerivedCRS createDerivedCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(DerivedCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public EngineeringCRS createEngineeringCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(EngineeringCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public ImageCRS createImageCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(ImageCRS.class, this.createCoordinateReferenceSystem(code), code);
    }

    public Datum createDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(Datum.class, this.createObject(code), code);
    }

    public GeodeticDatum createGeodeticDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(GeodeticDatum.class, this.createDatum(code), code);
    }

    public VerticalDatum createVerticalDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(VerticalDatum.class, this.createDatum(code), code);
    }

    public TemporalDatum createTemporalDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(TemporalDatum.class, this.createDatum(code), code);
    }

    public DefaultParametricDatum createParametricDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(DefaultParametricDatum.class, this.createDatum(code), code);
    }

    public EngineeringDatum createEngineeringDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(EngineeringDatum.class, this.createDatum(code), code);
    }

    public ImageDatum createImageDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(ImageDatum.class, this.createDatum(code), code);
    }

    public Ellipsoid createEllipsoid(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(Ellipsoid.class, this.createObject(code), code);
    }

    public PrimeMeridian createPrimeMeridian(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(PrimeMeridian.class, this.createObject(code), code);
    }

    public Extent createExtent(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(Extent.class, this.createObject(code), code);
    }

    public CoordinateSystem createCoordinateSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CoordinateSystem.class, this.createObject(code), code);
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(EllipsoidalCS.class, this.createCoordinateSystem(code), code);
    }

    public VerticalCS createVerticalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(VerticalCS.class, this.createCoordinateSystem(code), code);
    }

    public TimeCS createTimeCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(TimeCS.class, this.createCoordinateSystem(code), code);
    }

    public DefaultParametricCS createParametricCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(DefaultParametricCS.class, this.createCoordinateSystem(code), code);
    }

    public CartesianCS createCartesianCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CartesianCS.class, this.createCoordinateSystem(code), code);
    }

    public SphericalCS createSphericalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(SphericalCS.class, this.createCoordinateSystem(code), code);
    }

    public CylindricalCS createCylindricalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CylindricalCS.class, this.createCoordinateSystem(code), code);
    }

    public PolarCS createPolarCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(PolarCS.class, this.createCoordinateSystem(code), code);
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CoordinateSystemAxis.class, this.createObject(code), code);
    }

    public Unit<?> createUnit(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(Unit.class, this.createObject(code), code);
    }

    public ParameterDescriptor<?> createParameterDescriptor(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(ParameterDescriptor.class, this.createObject(code), code);
    }

    public OperationMethod createOperationMethod(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(OperationMethod.class, this.createObject(code), code);
    }

    public CoordinateOperation createCoordinateOperation(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return this.cast(CoordinateOperation.class, this.createObject(code), code);
    }

    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws NoSuchAuthorityCodeException, FactoryException {
        return Collections.emptySet();
    }

    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        return new IdentifiedObjectFinder(this);
    }

    static boolean regionMatches(String namespace, String code, int start, int end) {
        return namespace.length() == end - start && code.regionMatches(true, start, namespace, 0, namespace.length());
    }

    final String trimNamespace(String code) {
        int s = code.indexOf(58);
        if (s >= 0) {
            int end = CharSequences.skipTrailingWhitespaces(code, 0, s);
            int start = CharSequences.skipLeadingWhitespaces(code, 0, end);
            for (String codespace : this.getCodeSpaces()) {
                if (!GeodeticAuthorityFactory.regionMatches(codespace, code, start, end)) continue;
                int n = code.indexOf(58, s + 1);
                if (n >= 0) {
                    s = n;
                }
                int length = code.length();
                return CharSequences.trimWhitespaces(code, s + 1, length).toString();
            }
        }
        return CharSequences.trimWhitespaces(code);
    }

    private <T> T cast(Class<T> type, IdentifiedObject object, String code) throws NoSuchAuthorityCodeException {
        if (type.isInstance(object)) {
            return (T)object;
        }
        Class<Object> actual = object instanceof AbstractIdentifiedObject ? ((AbstractIdentifiedObject)object).getInterface() : object.getClass();
        ReferenceIdentifier id = object.getName();
        Citation authority = id != null ? id.getAuthority() : this.getAuthority();
        throw new NoSuchAuthorityCodeException(Errors.format((short)200, code, type, actual), Citations.getIdentifier(authority, false), this.trimNamespace(code), code);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this)).append("[\u201c").append(Citations.getIdentifier(this.getAuthority(), false)).append('\u201d');
        this.toString(buffer);
        return buffer.append(']').toString();
    }

    void toString(StringBuilder buffer) {
    }
}

