/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.AbstractIterator;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.internal.util.LazySet;
import org.apache.sis.internal.util.LazySynchronizedIterator;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.referencing.factory.AuthorityFactoryIdentifier;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class MultiAuthoritiesFactory
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private final Iterable<? extends AuthorityFactory>[] providers;
    private final ConcurrentMap<AuthorityFactoryIdentifier, AuthorityFactory> factories;
    private final AtomicInteger isIterationCompleted;
    private volatile Set<String> codeSpaces;
    private volatile boolean isLenient;
    private final Map<AuthorityFactoryIdentifier, Boolean> warnings;

    public MultiAuthoritiesFactory(Iterable<? extends CRSAuthorityFactory> crsFactories, Iterable<? extends CSAuthorityFactory> csFactories, Iterable<? extends DatumAuthorityFactory> datumFactories, Iterable<? extends CoordinateOperationAuthorityFactory> copFactories) {
        Iterable[] p = new Iterable[]{crsFactories, csFactories, datumFactories, copFactories};
        int length = 0;
        int nullMask = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != null) {
                length = i + 1;
                continue;
            }
            nullMask |= 1 << i;
        }
        this.providers = ArraysExt.resize(p, length);
        this.factories = new ConcurrentHashMap<AuthorityFactoryIdentifier, AuthorityFactory>();
        this.warnings = new HashMap<AuthorityFactoryIdentifier, Boolean>();
        this.isIterationCompleted = new AtomicInteger(nullMask);
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) {
        this.isLenient = lenient;
    }

    @Override
    public Citation getAuthority() {
        return null;
    }

    @Override
    public Set<String> getAuthorityCodes(final Class<? extends IdentifiedObject> type) throws FactoryException {
        return new SetOfUnknownSize<String>(){
            private final Map<AuthorityFactory, Set<String>> cache = new IdentityHashMap<AuthorityFactory, Set<String>>();
            private int size = -1;
            private final AuthorityFactoryProxy<Boolean> contains = new AuthorityFactoryProxy<Boolean>(Boolean.class, 5){

                @Override
                Boolean createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
                    return this.getAuthorityCodes(factory).contains(code);
                }

                @Override
                AuthorityFactoryProxy<Boolean> specialize(String typeName) {
                    return this;
                }
            };

            @Override
            public Iterator<String> iterator() {
                return new AbstractIterator<String>(){
                    private final Iterator<AuthorityFactory> factories;
                    private Iterator<String> codes;
                    private String prefix;
                    private final Set<String> done;
                    {
                        this.factories = MultiAuthoritiesFactory.this.getAllFactories();
                        this.codes = Collections.emptySet().iterator();
                        this.done = new HashSet<String>();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.next == null) {
                            while (!this.codes.hasNext()) {
                                do {
                                    if (!this.factories.hasNext()) {
                                        return false;
                                    }
                                    AuthorityFactory factory = this.factories.next();
                                    this.codes = this.getAuthorityCodes(factory).iterator();
                                    this.prefix = MultiAuthoritiesFactory.getCodeSpace(factory);
                                } while (!this.done.add(this.prefix));
                            }
                            this.next = this.codes.next();
                        }
                        return true;
                    }

                    @Override
                    public String next() {
                        String code = (String)super.next();
                        if (this.prefix != null && code.indexOf(58) < 0) {
                            code = this.prefix + ':' + code;
                        }
                        return code;
                    }
                };
            }

            final Set<String> getAuthorityCodes(AuthorityFactory factory) {
                Set<String> codes = this.cache.get(factory);
                if (codes == null) {
                    try {
                        codes = factory.getAuthorityCodes(type);
                    }
                    catch (FactoryException e) {
                        throw new BackingStoreException(e);
                    }
                    if (this.cache.put(factory, codes) != null) {
                        throw new ConcurrentModificationException();
                    }
                }
                return codes;
            }

            @Override
            protected boolean isSizeKnown() {
                return this.size >= 0;
            }

            @Override
            public int size() {
                if (this.size < 0) {
                    int n = 0;
                    HashSet<String> done = new HashSet<String>();
                    Iterator<AuthorityFactory> it = MultiAuthoritiesFactory.this.getAllFactories();
                    while (it.hasNext()) {
                        AuthorityFactory factory = it.next();
                        if (!done.add(MultiAuthoritiesFactory.getCodeSpace(factory))) continue;
                        n += this.getAuthorityCodes(factory).size();
                    }
                    this.size = n;
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                if (this.size == -1) {
                    Iterator<AuthorityFactory> it = MultiAuthoritiesFactory.this.getAllFactories();
                    while (it.hasNext()) {
                        if (this.getAuthorityCodes(it.next()).isEmpty()) continue;
                        this.size = -2;
                        return false;
                    }
                    this.size = 0;
                }
                return this.size == 0;
            }

            @Override
            public boolean contains(Object code) {
                if (code instanceof String) {
                    try {
                        return MultiAuthoritiesFactory.this.create(this.contains, (String)code);
                    }
                    catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                    }
                    catch (FactoryException e) {
                        throw new BackingStoreException(e);
                    }
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<String> getCodeSpaces() {
        Set<String> union = this.codeSpaces;
        if (union == null) {
            union = new LinkedHashSet<String>();
            Iterator<AuthorityFactory> it = this.getAllFactories();
            while (it.hasNext()) {
                union.addAll(MultiAuthoritiesFactory.getCodeSpaces(it.next()));
            }
            this.codeSpaces = union = CollectionsExt.unmodifiableOrCopy(union);
        }
        return union;
    }

    private static Set<String> getCodeSpaces(AuthorityFactory factory) {
        if (factory instanceof GeodeticAuthorityFactory) {
            return ((GeodeticAuthorityFactory)factory).getCodeSpaces();
        }
        String authority = Citations.getCodeSpace(factory.getAuthority());
        return authority != null ? Collections.singleton(authority) : Collections.emptySet();
    }

    static String getCodeSpace(AuthorityFactory factory) {
        return CollectionsExt.first(MultiAuthoritiesFactory.getCodeSpaces(factory));
    }

    private AuthorityFactory cache(AuthorityFactoryIdentifier identifier, AuthorityFactory factory) {
        AuthorityFactory existing = JDK8.putIfAbsent(this.factories, identifier.intern(), factory);
        return existing != null ? existing : factory;
    }

    final Iterator<AuthorityFactory> getAllFactories() {
        return new LazySynchronizedIterator<AuthorityFactory>(this.providers);
    }

    public final <T extends AuthorityFactory> T getAuthorityFactory(Class<T> type, String authority, String version) throws NoSuchAuthorityFactoryException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("authority", authority);
        return (T)((AuthorityFactory)type.cast(this.getAuthorityFactory(AuthorityFactoryIdentifier.create(type, authority, version))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorityFactory getAuthorityFactory(AuthorityFactoryIdentifier request) throws NoSuchAuthorityFactoryException {
        byte type;
        int doneMask;
        AuthorityFactory factory = (AuthorityFactory)this.factories.get(request);
        if (factory != null) {
            return factory;
        }
        if (request.hasVersion() && (factory = (AuthorityFactory)this.factories.get(request.versionOf(null))) != null) {
            if (request.versionOf(factory.getAuthority()) == request) {
                return this.cache(request, factory);
            }
            factory = null;
        }
        if (((doneMask = this.isIterationCompleted.get()) & 1 << (type = request.type)) == 0) {
            if (type >= 0 && type < this.providers.length) {
                Iterator<? extends AuthorityFactory> it;
                Iterable<? extends AuthorityFactory> provider;
                Iterable<? extends AuthorityFactory> iterable = provider = this.providers[type];
                synchronized (iterable) {
                    it = provider.iterator();
                    while (it.hasNext() && (factory = it.next()) == null) {
                    }
                }
                while (factory != null) {
                    for (String namespace : MultiAuthoritiesFactory.getCodeSpaces(factory)) {
                        AuthorityFactory found;
                        AuthorityFactoryIdentifier unversioned = request.unversioned(namespace);
                        AuthorityFactory cached = this.cache(unversioned, factory);
                        AuthorityFactory authorityFactory = found = request.equals(unversioned) ? cached : null;
                        if (factory != cached || request.hasVersion() && request.isSameAuthority(unversioned)) {
                            AuthorityFactoryIdentifier versioned = unversioned.versionOf(factory.getAuthority());
                            if (versioned != unversioned) {
                                if (factory != cached) {
                                    this.cache(unversioned.versionOf(cached.getAuthority()), cached);
                                }
                                cached = this.cache(versioned, factory);
                            }
                            if (factory != cached && this.canLog(versioned)) {
                                versioned.logConflict(cached);
                            }
                            if (request.equals(versioned)) {
                                return cached;
                            }
                        }
                        if (found == null) continue;
                        return found;
                    }
                    factory = null;
                    iterable = provider;
                    synchronized (iterable) {
                        while (it.hasNext() && (factory = it.next()) == null) {
                        }
                    }
                }
            } else if (type >= 4) {
                assert (this.providers.length <= Math.min(type, 127)) : type;
                block14: for (byte i = 0; i < this.providers.length; i = (byte)(i + 1)) {
                    factory = this.getAuthorityFactory(request.newType(i));
                    switch (type) {
                        case 5: {
                            return factory;
                        }
                        case 4: {
                            if (!(factory instanceof GeodeticAuthorityFactory)) continue block14;
                            return factory;
                        }
                    }
                }
            }
            while (!this.isIterationCompleted.compareAndSet(doneMask, doneMask | 1 << type)) {
                doneMask = this.isIterationCompleted.get();
            }
        }
        if (request.hasVersion() && this.isLenient) {
            factory = this.getAuthorityFactory(request.versionOf(null));
            if (this.canLog(request)) {
                request.logFallback();
            }
            return factory;
        }
        String authority = request.getAuthorityAndVersion().toString();
        throw new NoSuchAuthorityFactoryException(Errors.format((short)136, authority), authority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canLog(AuthorityFactoryIdentifier identifier) {
        Map<AuthorityFactoryIdentifier, Boolean> map = this.warnings;
        synchronized (map) {
            if (this.warnings.containsKey(identifier)) {
                return false;
            }
            return JDK8.putIfAbsent(this.warnings, identifier.intern(), Boolean.TRUE) == null;
        }
    }

    final <T> T create(AuthorityFactoryProxy<? extends T> proxy, String code) throws FactoryException {
        String[] parameters;
        String version;
        String authority;
        ArgumentChecks.ensureNonNull("code", code);
        DefinitionURI uri = DefinitionURI.parse(code);
        if (uri != null) {
            if (uri.authority == null) {
                throw new NoSuchAuthorityCodeException(Errors.format((short)135, code), null, uri.code, code);
            }
            Class type = proxy.type;
            authority = uri.authority;
            version = uri.version;
            code = uri.code;
            parameters = uri.parameters;
            proxy = proxy.specialize(uri.type);
            if (code == null || proxy == null) {
                String s = uri.toString();
                String message = code == null ? Errors.format((short)189, s, "code") : Errors.format((short)215, type, uri.type);
                throw new NoSuchAuthorityCodeException(message, authority, code, s);
            }
        } else {
            int afterVersion;
            int afterAuthority = code.indexOf(58);
            int end = CharSequences.skipTrailingWhitespaces(code, 0, afterAuthority);
            int start = CharSequences.skipLeadingWhitespaces(code, 0, end);
            if (start >= end) {
                throw new NoSuchAuthorityCodeException(Errors.format((short)135, code), null, code);
            }
            authority = code.substring(start, end);
            version = (start = CharSequences.skipLeadingWhitespaces(code, ++afterAuthority, afterVersion = code.indexOf(58, afterAuthority))) < (end = CharSequences.skipTrailingWhitespaces(code, start, afterVersion)) && !code.regionMatches(start, "0", 0, "0".length()) ? code.substring(start, end) : null;
            code = CharSequences.trimWhitespaces(code, Math.max(afterAuthority, afterVersion + 1), code.length()).toString();
            parameters = null;
        }
        if (parameters != null || code.indexOf(44) >= 0) {
            StringBuilder buffer = new StringBuilder(authority.length() + code.length() + 1).append(authority).append(':').append(code);
            if (parameters != null) {
                for (String p : parameters) {
                    buffer.append(',').append(p);
                }
            }
            code = buffer.toString();
        }
        return proxy.createFromAPI(this.getAuthorityFactory(AuthorityFactoryIdentifier.create(proxy.factoryType, authority, version)), code);
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DESCRIPTION, code);
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OBJECT, code);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CRS, code);
    }

    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEOGRAPHIC_CRS, code);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEOCENTRIC_CRS, code);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PROJECTED_CRS, code);
    }

    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_CRS, code);
    }

    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TEMPORAL_CRS, code);
    }

    @Override
    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.COMPOUND_CRS, code);
    }

    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DERIVED_CRS, code);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ENGINEERING_CRS, code);
    }

    @Override
    public ImageCRS createImageCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.IMAGE_CRS, code);
    }

    @Override
    public Datum createDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DATUM, code);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEODETIC_DATUM, code);
    }

    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_DATUM, code);
    }

    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TEMPORAL_DATUM, code);
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ENGINEERING_DATUM, code);
    }

    @Override
    public ImageDatum createImageDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.IMAGE_DATUM, code);
    }

    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ELLIPSOID, code);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PRIME_MERIDIAN, code);
    }

    @Override
    public Extent createExtent(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.EXTENT, code);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.COORDINATE_SYSTEM, code);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ELLIPSOIDAL_CS, code);
    }

    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_CS, code);
    }

    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TIME_CS, code);
    }

    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CARTESIAN_CS, code);
    }

    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.SPHERICAL_CS, code);
    }

    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CYLINDRICAL_CS, code);
    }

    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.POLAR_CS, code);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.AXIS, code);
    }

    @Override
    public Unit<?> createUnit(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.UNIT, code);
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PARAMETER, code);
    }

    @Override
    public OperationMethod createOperationMethod(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.METHOD, code);
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OPERATION, code);
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws FactoryException {
        Deferred deferred = new Deferred();
        CoordinateOperationAuthorityFactory factory = this.create(deferred, sourceCRS);
        String source = deferred.code;
        if (this.create(deferred, targetCRS) == factory) {
            return factory.createFromCoordinateReferenceSystemCodes(source, deferred.code);
        }
        LogRecord record = Messages.getResources(null).getLogRecord(Level.WARNING, (short)37, sourceCRS, targetCRS);
        record.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(MultiAuthoritiesFactory.class, "createFromCoordinateReferenceSystemCodes", record);
        return super.createFromCoordinateReferenceSystemCodes(sourceCRS, targetCRS);
    }

    @Override
    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        return new Finder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        for (int type = 0; type < this.providers.length; ++type) {
            Iterable<? extends AuthorityFactory> provider = this.providers[type];
            if (provider == null) continue;
            Iterable<? extends AuthorityFactory> iterable = provider;
            synchronized (iterable) {
                if (provider instanceof LazySet) {
                    ((LazySet)provider).reload();
                }
                if (provider instanceof ServiceLoader) {
                    ((ServiceLoader)provider).reload();
                }
                this.applyAndMask(~(1 << type));
                Iterator it = this.factories.keySet().iterator();
                while (it.hasNext()) {
                    if (((AuthorityFactoryIdentifier)it.next()).type != type) continue;
                    it.remove();
                }
                continue;
            }
        }
        this.applyAndMask(this.providers.length - 1);
    }

    private void applyAndMask(int mask) {
        int value;
        while (!this.isIterationCompleted.compareAndSet(value = this.isIterationCompleted.get(), value & mask)) {
        }
    }

    private static class Finder
    extends IdentifiedObjectFinder {
        private IdentifiedObjectFinder[] finders;

        protected Finder(MultiAuthoritiesFactory factory) throws FactoryException {
            super(factory);
        }

        @Override
        public void setSearchDomain(IdentifiedObjectFinder.Domain domain) {
            super.setSearchDomain(domain);
            if (this.finders != null) {
                for (IdentifiedObjectFinder finder : this.finders) {
                    finder.setSearchDomain(domain);
                }
            }
        }

        @Override
        public void setIgnoringAxes(boolean ignore) {
            super.setIgnoringAxes(ignore);
            if (this.finders != null) {
                for (IdentifiedObjectFinder finder : this.finders) {
                    finder.setIgnoringAxes(ignore);
                }
            }
        }

        @Override
        final Set<IdentifiedObject> createFromCodes(IdentifiedObject object) throws FactoryException {
            if (this.finders == null) {
                try {
                    ArrayList<IdentifiedObjectFinder> list = new ArrayList<IdentifiedObjectFinder>();
                    IdentityHashMap<AuthorityFactory, Boolean> unique = new IdentityHashMap<AuthorityFactory, Boolean>();
                    Iterator<AuthorityFactory> it = ((MultiAuthoritiesFactory)this.factory).getAllFactories();
                    while (it.hasNext()) {
                        IdentifiedObjectFinder finder;
                        AuthorityFactory candidate = it.next();
                        if (!(candidate instanceof GeodeticAuthorityFactory) || unique.put(candidate, Boolean.TRUE) != null || (finder = ((GeodeticAuthorityFactory)candidate).newIdentifiedObjectFinder()) == null) continue;
                        finder.ignoreIdentifiers = true;
                        finder.setWrapper(this);
                        list.add(finder);
                    }
                    this.finders = list.toArray(new IdentifiedObjectFinder[list.size()]);
                }
                catch (BackingStoreException e) {
                    throw e.unwrapOrRethrow(FactoryException.class);
                }
            }
            LinkedHashSet<IdentifiedObject> found = new LinkedHashSet<IdentifiedObject>();
            for (IdentifiedObjectFinder finder : this.finders) {
                found.addAll(finder.find(object));
            }
            return found;
        }
    }

    private static final class Deferred
    extends AuthorityFactoryProxy<CoordinateOperationAuthorityFactory> {
        String code;

        Deferred() {
            super(CoordinateOperationAuthorityFactory.class, (byte)3);
        }

        @Override
        CoordinateOperationAuthorityFactory createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            this.code = code;
            return this.opFactory(factory);
        }
    }
}

