/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.factory.ConcurrentAuthorityFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.EPSGInstaller;
import org.apache.sis.referencing.factory.sql.InstallationScriptProvider;
import org.apache.sis.referencing.factory.sql.SQLTranslator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;
import org.opengis.util.NameFactory;

public class EPSGFactory
extends ConcurrentAuthorityFactory<EPSGDataAccess>
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
Localized {
    private static final Set<String> CODESPACES = Collections.singleton("EPSG");
    protected final DataSource dataSource;
    protected final NameFactory nameFactory;
    protected final DatumFactory datumFactory;
    protected final CSFactory csFactory;
    protected final CRSFactory crsFactory;
    protected final CoordinateOperationFactory copFactory;
    protected final MathTransformFactory mtFactory;
    private final String catalog;
    private final String schema;
    private final InstallationScriptProvider scriptProvider;
    private volatile SQLTranslator translator;
    private final Locale locale;

    public EPSGFactory(Map<String, ?> properties) throws FactoryException {
        super(EPSGDataAccess.class);
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        DataSource ds = (DataSource)properties.get("dataSource");
        Locale locale = (Locale)properties.get("locale");
        this.schema = (String)properties.get("schema");
        this.catalog = (String)properties.get("catalog");
        this.scriptProvider = (InstallationScriptProvider)properties.get("scriptProvider");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        if (ds == null) {
            try {
                ds = Initializer.getDataSource();
                if (ds == null) {
                    throw new UnavailableFactoryException(Initializer.unspecified(locale));
                }
            }
            catch (Exception e) {
                throw new UnavailableFactoryException(this.message(e), e);
            }
        }
        this.dataSource = ds;
        this.nameFactory = EPSGFactory.factory(NameFactory.class, "nameFactory", properties);
        this.datumFactory = EPSGFactory.factory(DatumFactory.class, "datumFactory", properties);
        this.csFactory = EPSGFactory.factory(CSFactory.class, "csFactory", properties);
        this.crsFactory = EPSGFactory.factory(CRSFactory.class, "crsFactory", properties);
        this.copFactory = EPSGFactory.factory(CoordinateOperationFactory.class, "copFactory", properties);
        this.mtFactory = EPSGFactory.factory(MathTransformFactory.class, "mtFactory", properties);
        super.setTimeout(10L, TimeUnit.SECONDS);
    }

    private static <F> F factory(Class<F> type, String key, Map<String, ?> properties) {
        F factory = type.cast(properties.get(key));
        return factory != null ? factory : DefaultFactories.forBuildin(type);
    }

    private String message(Exception e) {
        String message = Exceptions.getLocalizedMessage(e, this.locale);
        if (message == null) {
            message = Classes.getShortClassName(e);
        }
        return Errors.getResources(this.locale).getString((short)218, "EPSG", message);
    }

    @Override
    public Set<String> getCodeSpaces() {
        return CODESPACES;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void install(Connection connection) throws IOException, SQLException {
        ArgumentChecks.ensureNonNull("connection", connection);
        EPSGInstaller installer = new EPSGInstaller(connection);
        try {
            boolean ac = connection.getAutoCommit();
            if (ac) {
                connection.setAutoCommit(false);
            }
            try {
                boolean success = false;
                try {
                    if (!"".equals(this.schema)) {
                        installer.setSchema(this.schema != null ? this.schema : "EPSG");
                        if (this.catalog != null && !this.catalog.isEmpty()) {
                            installer.prependNamespace(this.catalog);
                        }
                    }
                    installer.run(this.scriptProvider, this.locale);
                    success = true;
                }
                finally {
                    if (ac) {
                        if (success) {
                            connection.commit();
                        } else {
                            connection.rollback();
                        }
                        connection.setAutoCommit(true);
                    }
                }
            }
            catch (IOException e) {
                installer.logFailure(this.locale, e);
                throw e;
            }
            catch (SQLException e) {
                installer.logFailure(this.locale, e);
                throw e;
            }
        }
        finally {
            installer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EPSGDataAccess newDataAccess() throws FactoryException {
        UnavailableFactoryException exception;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            SQLTranslator tr = this.translator;
            if (tr == null) {
                EPSGFactory ePSGFactory = this;
                synchronized (ePSGFactory) {
                    tr = this.translator;
                    if (tr == null) {
                        tr = new SQLTranslator(connection.getMetaData(), this.catalog, this.schema);
                        try {
                            if (!tr.isTableFound()) {
                                this.install(connection);
                                tr.setup(connection.getMetaData());
                            }
                        }
                        finally {
                            this.translator = tr;
                        }
                    }
                }
            }
            if (tr.isTableFound()) {
                return this.newDataAccess(connection, tr);
            }
            connection.close();
            exception = new UnavailableFactoryException(SQLTranslator.tableNotFound(this.locale));
        }
        catch (Exception e) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            exception = new UnavailableFactoryException(this.message(e), e);
        }
        exception.setUnavailableFactory(this);
        throw exception;
    }

    protected EPSGDataAccess newDataAccess(Connection connection, SQLTranslator translator) throws SQLException {
        return new EPSGDataAccess(this, connection, translator);
    }

    @Override
    protected boolean canClose(EPSGDataAccess factory) {
        return factory.canClose();
    }
}

