/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.internal.jdk8.BiFunction;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.metadata.sql.ScriptRunner;
import org.apache.sis.internal.util.Fallback;
import org.apache.sis.referencing.factory.sql.InstallationScriptProvider;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.logging.PerformanceLevel;
import org.apache.sis.util.resources.Messages;

final class EPSGInstaller
extends ScriptRunner {
    static final String REPLACE_STATEMENT = "\\s*UPDATE\\s+[\\w\\.\" ]+\\s+SET\\s+(\\w+)\\s*=\\s*replace\\s*\\(\\s*\\1\\W+.*";
    private final boolean replacePilcrow;
    private final Matcher statementToSkip;

    public EPSGInstaller(Connection connection) throws SQLException {
        super(connection, 100);
        boolean isReplaceSupported = false;
        DatabaseMetaData metadata = connection.getMetaData();
        String functions = metadata.getStringFunctions();
        StringTokenizer tk = new StringTokenizer(functions, ",");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken().trim();
            if (!token.equalsIgnoreCase("REPLACE")) continue;
            isReplaceSupported = true;
            break;
        }
        this.statementToSkip = isReplaceSupported ? null : Pattern.compile(REPLACE_STATEMENT, 2).matcher("");
        this.replacePilcrow = false;
    }

    public void setSchema(String schema) throws SQLException, IOException {
        if (this.isSchemaSupported) {
            this.execute(new StringBuilder("CREATE SCHEMA ").append(schema));
            if (this.isGrantOnSchemaSupported) {
                this.execute(new StringBuilder("GRANT USAGE ON SCHEMA ").append(schema).append(" TO ").append("PUBLIC"));
            }
            this.addReplacement("epsg_alias", "Alias");
            this.addReplacement("epsg_area", "Area");
            this.addReplacement("epsg_change", "Change");
            this.addReplacement("epsg_coordinateaxis", "Coordinate Axis");
            this.addReplacement("epsg_coordinateaxisname", "Coordinate Axis Name");
            this.addReplacement("epsg_coordoperation", "Coordinate_Operation");
            this.addReplacement("epsg_coordoperationmethod", "Coordinate_Operation Method");
            this.addReplacement("epsg_coordoperationparam", "Coordinate_Operation Parameter");
            this.addReplacement("epsg_coordoperationparamusage", "Coordinate_Operation Parameter Usage");
            this.addReplacement("epsg_coordoperationparamvalue", "Coordinate_Operation Parameter Value");
            this.addReplacement("epsg_coordoperationpath", "Coordinate_Operation Path");
            this.addReplacement("epsg_coordinatereferencesystem", "Coordinate Reference System");
            this.addReplacement("epsg_coordinatesystem", "Coordinate System");
            this.addReplacement("epsg_datum", "Datum");
            this.addReplacement("epsg_deprecation", "Deprecation");
            this.addReplacement("epsg_ellipsoid", "Ellipsoid");
            this.addReplacement("epsg_namingsystem", "Naming System");
            this.addReplacement("epsg_primemeridian", "Prime Meridian");
            this.addReplacement("epsg_supersession", "Supersession");
            this.addReplacement("epsg_unitofmeasure", "Unit of Measure");
            this.addReplacement("epsg_versionhistory", "Version History");
            if (this.isEnumTypeSupported) {
                this.addReplacement("epsg_datum_kind", "Datum Kind");
                this.addReplacement("epsg_crs_kind", "CRS Kind");
                this.addReplacement("epsg_cs_kind", "CS Kind");
                this.addReplacement("epsg_table_name", "Table Name");
            }
            this.prependNamespace(schema);
        }
        if (!this.isEnumTypeSupported) {
            this.addReplacement("epsg_datum_kind", "VARCHAR(24)");
            this.addReplacement("epsg_crs_kind", "VARCHAR(24)");
            this.addReplacement("epsg_cs_kind", "VARCHAR(24)");
            this.addReplacement("epsg_table_name", "VARCHAR(80)");
        }
    }

    final void prependNamespace(final String schema) {
        this.modifyReplacements(new BiFunction<String, String, String>(){

            @Override
            public String apply(String key, String value) {
                return key.startsWith("epsg_") ? schema + '.' + EPSGInstaller.this.identifierQuote + value + EPSGInstaller.this.identifierQuote : value;
            }
        });
    }

    @Override
    protected void editText(StringBuilder sql, int lower, int upper) {
        switch (upper - lower) {
            default: {
                return;
            }
            case 2: 
        }
        String replacement = "Null";
        sql.replace(lower, upper, replacement);
    }

    @Override
    protected int execute(StringBuilder sql) throws SQLException, IOException {
        String t;
        if (CharSequences.equalsIgnoreCase(sql, "COMMIT")) {
            return 0;
        }
        if (!this.isGrantOnTableSupported && CharSequences.regionMatches(sql, 0, "GRANT")) {
            return 0;
        }
        if (!this.isEnumTypeSupported && CharSequences.regionMatches(sql, 0, "CREATE") && ((t = CharSequences.trimWhitespaces(sql, 6, 12).toString()).equals("TYPE") || t.equals("CAST"))) {
            return 0;
        }
        if (this.statementToSkip != null && this.statementToSkip.reset(sql).matches()) {
            return 0;
        }
        if (this.replacePilcrow) {
            StringBuilders.replace(sql, "\u00b6", "\n");
        }
        return super.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(InstallationResources scriptProvider, Locale locale) throws SQLException, IOException {
        long time = System.nanoTime();
        InstallationScriptProvider.log(Messages.getResources(locale).getLogRecord(Level.INFO, (short)39, "EPSG", SQLUtilities.getSimplifiedURL(this.getConnection().getMetaData())));
        if (scriptProvider == null) {
            scriptProvider = EPSGInstaller.lookupProvider(locale);
        }
        String[] scripts = scriptProvider.getResourceNames("EPSG");
        int numRows = 0;
        for (int i = 0; i < scripts.length; ++i) {
            BufferedReader in = scriptProvider.openScript("EPSG", i);
            try {
                numRows += this.run(scripts[i], in);
                continue;
            }
            finally {
                in.close();
            }
        }
        time = System.nanoTime() - time;
        InstallationScriptProvider.log(Messages.getResources(locale).getLogRecord(PerformanceLevel.forDuration(time, TimeUnit.NANOSECONDS), (short)40, numRows, Float.valueOf((float)time / 1.0E9f)));
    }

    private static InstallationResources lookupProvider(Locale locale) throws IOException {
        InstallationResources fallback = null;
        for (InstallationResources provider : ServiceLoader.load(InstallationResources.class)) {
            if (!provider.getAuthorities().contains("EPSG")) continue;
            if (provider.getClass().isAnnotationPresent(Fallback.class)) {
                return provider;
            }
            fallback = provider;
        }
        return fallback != null ? fallback : new InstallationScriptProvider.Default(locale);
    }

    final void logFailure(Locale locale, Exception cause) {
        String message = Messages.getResources(locale).getString((short)41, "EPSG");
        String status = this.status(locale);
        if (status != null) {
            message = message + ' ' + status;
        }
        message = Exceptions.formatChainedMessages(locale, message, cause);
        InstallationScriptProvider.log(new LogRecord(Level.WARNING, message));
    }
}

