/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.jdk7.DirectoryStream;
import org.apache.sis.internal.jdk7.Files;
import org.apache.sis.internal.jdk7.Path;
import org.apache.sis.internal.jdk7.StandardCharsets;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class InstallationScriptProvider
extends InstallationResources {
    protected static final String PREPARE = "Prepare";
    protected static final String FINISH = "Finish";
    private final Set<String> authorities;
    private final String[] resources;

    protected InstallationScriptProvider(String authority, String ... resources) {
        ArgumentChecks.ensureNonNull("resources", resources);
        this.authorities = CollectionsExt.singletonOrEmpty(authority);
        this.resources = resources;
    }

    @Override
    public Set<String> getAuthorities() {
        return this.authorities;
    }

    private void verifyAuthority(String authority) {
        if (!this.authorities.contains(authority)) {
            throw new IllegalArgumentException(Errors.format((short)31, "authority", authority));
        }
    }

    @Override
    public String[] getResourceNames(String authority) throws IOException {
        this.verifyAuthority(authority);
        return (String[])this.resources.clone();
    }

    @Override
    public BufferedReader openScript(String authority, int resource) throws IOException {
        Charset charset;
        InputStream in;
        this.verifyAuthority(authority);
        ArgumentChecks.ensureValidIndex(this.resources.length, resource);
        if (!"EPSG".equals(authority)) {
            throw new IllegalStateException(Errors.format((short)136, authority));
        }
        String name = this.resources[resource];
        if (PREPARE.equals(name) || FINISH.equals(name)) {
            name = authority + '_' + name + ".sql";
            in = InstallationScriptProvider.class.getResourceAsStream(name);
            charset = StandardCharsets.UTF_8;
        } else {
            in = this.openStream(name);
            charset = StandardCharsets.ISO_8859_1;
        }
        if (in == null) {
            throw new FileNotFoundException(Errors.format((short)166, name));
        }
        return new LineNumberReader(new InputStreamReader(in, charset));
    }

    protected abstract InputStream openStream(String var1) throws IOException;

    static void log(LogRecord record) {
        record.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(EPSGFactory.class, "install", record);
    }

    static final class Default
    extends InstallationScriptProvider {
        private Path directory;
        private static final int FIRST_FILE = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Default(Locale locale) throws IOException {
            super("EPSG", InstallationScriptProvider.PREPARE, "Tables", "Data", "FKeys", InstallationScriptProvider.FINISH);
            Path dir = DataDirectory.DATABASES.getDirectory();
            if (dir != null && Files.isDirectory(dir = dir.resolve("ExternalSources"))) {
                String[] resources = ((InstallationScriptProvider)this).resources;
                String[] found = new String[resources.length - 1 - 1];
                DirectoryStream stream = Files.newDirectoryStream(dir, "EPSG_*.sql");
                try {
                    for (Path path : stream) {
                        String name = path.getFileName().toString();
                        for (int i = 0; i < found.length; ++i) {
                            String part = resources[1 + i];
                            if (!name.contains(part)) continue;
                            if (found[i] != null) {
                                Default.log(Errors.getResources(locale).getLogRecord(Level.WARNING, (short)16, part));
                                return;
                            }
                            found[i] = name;
                        }
                    }
                }
                finally {
                    stream.close();
                }
                for (int i = 0; i < found.length; ++i) {
                    String file = found[i];
                    if (file != null) {
                        resources[1 + i] = file;
                        continue;
                    }
                    dir = null;
                }
                this.directory = dir;
            }
        }

        @Override
        public Set<String> getAuthorities() {
            return this.directory != null ? super.getAuthorities() : Collections.emptySet();
        }

        @Override
        public String getLicense(String authority, Locale locale, String mimeType) {
            return null;
        }

        @Override
        protected InputStream openStream(String name) throws IOException {
            return this.directory != null ? Files.newInputStream(this.directory.resolve(name)) : null;
        }
    }
}

