/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public class SQLTranslator {
    private static final String[] SENTINEL = new String[]{"Coordinate Reference System", "coordinatereferencesystem", "epsg_coordinatereferencesystem"};
    private static final int MIXED_CASE = 0;
    static final String TABLE_PREFIX = "epsg_";
    private static final String[] BOOLEAN_FIELDS = new String[]{"SHOW_CRS", "SHOW_OPERATION", "DEPRECATED"};
    private String catalog;
    private String schema;
    private final Map<String, String> accessToAnsi;
    private boolean quoteTableNames;
    private final String quote;
    private boolean useBoolean;
    private boolean isTableFound;

    public SQLTranslator(DatabaseMetaData md, String catalog, String schema) throws SQLException {
        ArgumentChecks.ensureNonNull("md", md);
        this.quote = md.getIdentifierQuoteString().trim();
        this.accessToAnsi = new HashMap<String, String>(4);
        this.catalog = catalog;
        this.schema = schema;
        this.setup(md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setup(DatabaseMetaData md) throws SQLException {
        ResultSet result;
        boolean toUpperCase = md.storesUpperCaseIdentifiers();
        int i = SENTINEL.length;
        while (--i >= 0) {
            String table = SENTINEL[i];
            if (toUpperCase && i != 0) {
                table = table.toUpperCase(Locale.US);
            }
            result = md.getTables(this.catalog, this.schema, table, null);
            try {
                if (!result.next()) continue;
                this.isTableFound = true;
                this.quoteTableNames = i == 0;
                do {
                    this.catalog = result.getString("TABLE_CAT");
                    this.schema = result.getString("TABLE_SCHEM");
                } while (!"EPSG".equalsIgnoreCase(this.schema) && result.next());
                if (this.schema != null) break;
                this.schema = "";
                break;
            }
            finally {
                result.close();
            }
        }
        boolean translateColumns = true;
        this.accessToAnsi.clear();
        if (this.quoteTableNames) {
            ResultSet result2 = md.getColumns(this.catalog, this.schema, "Coordinate Axis", "ORDER");
            try {
                translateColumns = !result2.next();
            }
            finally {
                result2.close();
            }
        } else {
            this.accessToAnsi.put("Coordinate_Operation", "coordoperation");
            this.accessToAnsi.put("Parameter", "param");
        }
        if (translateColumns) {
            this.accessToAnsi.put("ORDER", "coord_axis_order");
        }
        String deprecated = "DEPRECATED";
        if (md.storesLowerCaseIdentifiers()) {
            deprecated = deprecated.toLowerCase(Locale.US);
        }
        result = md.getColumns(this.catalog, this.schema, null, deprecated);
        try {
            while (result.next()) {
                if (!CharSequences.endsWith(result.getString("TABLE_NAME"), "Datum", true)) continue;
                int type = result.getInt("DATA_TYPE");
                this.useBoolean = type == 16 || type == -7;
                break;
            }
        }
        finally {
            result.close();
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    final boolean isTableFound() {
        return this.isTableFound;
    }

    static String tableNotFound(Locale locale) {
        return Errors.getResources(locale).getString((short)206, SENTINEL[0]);
    }

    final boolean useBoolean() {
        return this.useBoolean;
    }

    private static String nonEmpty(String s) {
        return s != null && !s.isEmpty() ? s : null;
    }

    public String apply(String sql) {
        int w;
        int start;
        String catalog = SQLTranslator.nonEmpty(this.catalog);
        String schema = SQLTranslator.nonEmpty(this.schema);
        if (this.quote.isEmpty() && this.accessToAnsi.isEmpty() && schema == null && catalog == null) {
            return sql;
        }
        StringBuilder ansi = new StringBuilder(sql.length() + 16);
        int end = 0;
        while ((start = sql.indexOf(91, end)) >= 0) {
            String name;
            ansi.append(sql, end, start);
            end = sql.indexOf(93, ++start);
            if (end < 0) {
                throw new IllegalArgumentException(Errors.format((short)188, sql.substring(start), Character.valueOf(']')));
            }
            if (CharSequences.isUpperCase(name = sql.substring(start, end++))) {
                ansi.append(JDK8.getOrDefault(this.accessToAnsi, name, name));
                continue;
            }
            if (catalog != null) {
                ansi.append(this.quote).append(catalog).append(this.quote).append('.');
            }
            if (schema != null) {
                ansi.append(this.quote).append(schema).append(this.quote).append('.');
            }
            if (this.quoteTableNames) {
                ansi.append(this.quote);
            }
            if (schema == null) {
                ansi.append(TABLE_PREFIX);
            }
            if (this.quoteTableNames) {
                ansi.append(JDK8.getOrDefault(this.accessToAnsi, name, name)).append(this.quote);
                continue;
            }
            for (String word : name.split("\\s")) {
                ansi.append(JDK8.getOrDefault(this.accessToAnsi, word, word));
            }
        }
        ansi.append(sql, end, sql.length());
        if (this.useBoolean && (w = ansi.indexOf("WHERE")) >= 0) {
            w += 5;
            for (String field : BOOLEAN_FIELDS) {
                int p = ansi.indexOf(field, w);
                if (p < 0 || SQLTranslator.replaceIfEquals(ansi, p += field.length(), "=0", "=FALSE") || SQLTranslator.replaceIfEquals(ansi, p, "<>0", "=TRUE") || (p = ansi.lastIndexOf("(", p)) <= w) continue;
                SQLTranslator.replaceIfEquals(ansi, p - 3, "ABS", "");
            }
        }
        return ansi.toString();
    }

    private static boolean replaceIfEquals(StringBuilder ansi, int pos, String expected, String replacement) {
        if (CharSequences.regionMatches(ansi, pos, expected)) {
            ansi.replace(pos, pos + expected.length(), replacement);
            return true;
        }
        return false;
    }
}

