/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPassThroughOperation;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractCoordinateOperationType", propOrder={"domainOfValidity", "scope", "operationVersion", "accuracy", "source", "target"})
@XmlRootElement(name="AbstractCoordinateOperation")
@XmlSeeAlso(value={AbstractSingleOperation.class, DefaultPassThroughOperation.class, DefaultConcatenatedOperation.class})
public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    CoordinateReferenceSystem sourceCRS;
    CoordinateReferenceSystem targetCRS;
    private CoordinateReferenceSystem interpolationCRS;
    private String operationVersion;
    Collection<PositionalAccuracy> coordinateOperationAccuracy;
    Extent domainOfValidity;
    private InternationalString scope;
    MathTransform transform;

    AbstractCoordinateOperation(Map<String, ?> properties) {
        super(properties);
        this.scope = Types.toInternationalString(properties, "scope");
        this.domainOfValidity = Containers.property(properties, "domainOfValidity", Extent.class);
        this.operationVersion = Containers.property(properties, "operationVersion", String.class);
        Object value = properties.get("coordinateOperationAccuracy");
        if (value != null) {
            this.coordinateOperationAccuracy = value instanceof PositionalAccuracy[] ? CollectionsExt.nonEmptySet((PositionalAccuracy[])value) : Collections.singleton((PositionalAccuracy)value);
        }
    }

    public AbstractCoordinateOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, MathTransform transform) {
        this(properties);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.interpolationCRS = interpolationCRS;
        this.transform = transform;
        this.checkDimensions(properties);
    }

    final void checkDimensions(Map<String, ?> properties) {
        MathTransform transform = this.transform;
        if (transform != null) {
            int interpDim = ReferencingUtilities.getDimension(this.interpolationCRS);
            int isTarget = 0;
            block4: while (true) {
                int actual;
                CoordinateReferenceSystem crs;
                switch (isTarget) {
                    case 0: {
                        crs = this.sourceCRS;
                        actual = transform.getSourceDimensions();
                        break;
                    }
                    case 1: {
                        crs = this.targetCRS;
                        actual = transform.getTargetDimensions();
                        break;
                    }
                    default: {
                        break block4;
                    }
                }
                int expected = ReferencingUtilities.getDimension(crs);
                if (interpDim != 0) {
                    if (actual == expected || actual < interpDim) {
                        throw new IllegalArgumentException(Errors.getResources(properties).getString((short)184));
                    }
                    expected += interpDim;
                }
                if (crs != null && actual != expected) {
                    throw new IllegalArgumentException(Errors.getResources(properties).getString((short)178, isTarget, expected, actual));
                }
                ++isTarget;
            }
        }
    }

    protected AbstractCoordinateOperation(CoordinateOperation operation) {
        super(operation);
        this.sourceCRS = operation.getSourceCRS();
        this.targetCRS = operation.getTargetCRS();
        this.interpolationCRS = AbstractCoordinateOperation.getInterpolationCRS(operation);
        this.operationVersion = operation.getOperationVersion();
        this.coordinateOperationAccuracy = operation.getCoordinateOperationAccuracy();
        this.domainOfValidity = operation.getDomainOfValidity();
        this.scope = operation.getScope();
        this.transform = operation.getMathTransform();
    }

    public static AbstractCoordinateOperation castOrCopy(CoordinateOperation object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends CoordinateOperation> getInterface() {
        return CoordinateOperation.class;
    }

    public boolean isDefiningConversion() {
        return this.sourceCRS == null && this.targetCRS == null || this.targetCRS instanceof GeneralDerivedCRS && ((GeneralDerivedCRS)this.targetCRS).getBaseCRS() == this.sourceCRS && ((GeneralDerivedCRS)this.targetCRS).getConversionFromBase() == this;
    }

    @Override
    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public CoordinateReferenceSystem getInterpolationCRS() {
        return this.interpolationCRS;
    }

    static CoordinateReferenceSystem getInterpolationCRS(CoordinateOperation operation) {
        return operation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)operation).getInterpolationCRS() : null;
    }

    @Override
    @XmlElement(name="operationVersion")
    public String getOperationVersion() {
        return this.operationVersion;
    }

    @Override
    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        return CollectionsExt.nonNull(this.coordinateOperationAccuracy);
    }

    public double getLinearAccuracy() {
        return PositionalAccuracyConstant.getLinearAccuracy(this);
    }

    @Override
    @XmlElement(name="domainOfValidity")
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    @XmlElement(name="scope", required=true)
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public MathTransform getMathTransform() {
        return this.transform;
    }

    OperationMethod getMethod() {
        return null;
    }

    ParameterDescriptorGroup getParameterDescriptors() {
        OperationMethod method;
        ParameterDescriptorGroup descriptor = AbstractCoordinateOperation.getParameterDescriptors(this.transform);
        if (descriptor == null && (method = this.getMethod()) != null) {
            descriptor = method.getParameters();
        }
        return descriptor;
    }

    static ParameterDescriptorGroup getParameterDescriptors(MathTransform transform) {
        while (transform != null) {
            if (transform instanceof Parameterized) {
                ParameterDescriptorGroup param;
                if (Semaphores.queryAndSet((byte)2)) {
                    throw new AssertionError();
                }
                try {
                    param = ((Parameterized)((Object)transform)).getParameterDescriptors();
                }
                finally {
                    Semaphores.clear((byte)2);
                }
                if (param != null) {
                    return param;
                }
            }
            if (!(transform instanceof PassThroughTransform)) break;
            transform = ((PassThroughTransform)transform).getSubTransform();
        }
        return null;
    }

    ParameterValueGroup getParameterValues() throws UnsupportedOperationException {
        MathTransform mt = this.transform;
        while (mt != null) {
            if (mt instanceof Parameterized) {
                ParameterValueGroup param;
                if (Semaphores.queryAndSet((byte)2)) {
                    throw new AssertionError();
                }
                try {
                    param = ((Parameterized)((Object)mt)).getParameterValues();
                }
                finally {
                    Semaphores.clear((byte)2);
                }
                if (param != null) {
                    return param;
                }
            }
            if (!(mt instanceof PassThroughTransform)) break;
            mt = ((PassThroughTransform)mt).getSubTransform();
        }
        throw new UnsupportedImplementationException(Classes.getClass(mt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            if (mode == ComparisonMode.STRICT) {
                AbstractCoordinateOperation that = (AbstractCoordinateOperation)object;
                if (Objects.equals(this.sourceCRS, that.sourceCRS) && Objects.equals(this.interpolationCRS, that.interpolationCRS) && Objects.equals(this.transform, that.transform) && Objects.equals(this.scope, that.scope) && Objects.equals(this.domainOfValidity, that.domainOfValidity) && Objects.equals(this.coordinateOperationAccuracy, that.coordinateOperationAccuracy)) {
                    if (Semaphores.queryAndSet((byte)1)) {
                        return true;
                    }
                    try {
                        boolean bl = Objects.equals(this.targetCRS, that.targetCRS);
                        return bl;
                    }
                    finally {
                        Semaphores.clear((byte)1);
                    }
                }
            } else {
                CoordinateOperation that = (CoordinateOperation)object;
                if ((mode.isIgnoringMetadata() || Utilities.deepEquals(this.getScope(), that.getScope(), mode) && Utilities.deepEquals(this.getDomainOfValidity(), that.getDomainOfValidity(), mode) && Utilities.deepEquals(this.getCoordinateOperationAccuracy(), that.getCoordinateOperationAccuracy(), mode)) && Utilities.deepEquals(this.getInterpolationCRS(), AbstractCoordinateOperation.getInterpolationCRS(that), mode)) {
                    CoordinateReferenceSystem crs2;
                    CoordinateReferenceSystem crs1;
                    if (Semaphores.queryAndSet((byte)1)) {
                        if (mode.isIgnoringMetadata()) {
                            mode = ComparisonMode.ALLOW_VARIANT;
                        }
                    } else {
                        try {
                            if (!Utilities.deepEquals(this.getTargetCRS(), that.getTargetCRS(), mode)) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        finally {
                            Semaphores.clear((byte)1);
                        }
                    }
                    if (Utilities.deepEquals(crs1 = this.getSourceCRS(), crs2 = that.getSourceCRS(), mode)) {
                        MathTransform tr1 = this.getMathTransform();
                        MathTransform tr2 = that.getMathTransform();
                        if (mode == ComparisonMode.ALLOW_VARIANT) {
                            try {
                                LinearTransform before = MathTransforms.linear(CoordinateSystems.swapAndScaleAxes(crs1.getCoordinateSystem(), crs2.getCoordinateSystem()));
                                LinearTransform after = MathTransforms.linear(CoordinateSystems.swapAndScaleAxes(that.getTargetCRS().getCoordinateSystem(), this.getTargetCRS().getCoordinateSystem()));
                                tr2 = MathTransforms.concatenate(before, tr2, after);
                            }
                            catch (Exception e) {
                                Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), AbstractCoordinateOperation.class, "equals", e);
                            }
                        }
                        return Utilities.deepEquals(tr1, tr2, mode);
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.sourceCRS, this.targetCRS, this.interpolationCRS, this.transform);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        OperationMethod method;
        super.formatTo(formatter);
        formatter.newLine();
        FormattableObject enclosing = formatter.getEnclosingElement(1);
        boolean isSubOperation = enclosing instanceof PassThroughOperation;
        boolean isComponent = enclosing instanceof ConcatenatedOperation;
        if (!isSubOperation && !isComponent) {
            AbstractCoordinateOperation.append(formatter, this.getSourceCRS(), "SourceCRS");
            AbstractCoordinateOperation.append(formatter, this.getTargetCRS(), "TargetCRS");
        }
        if ((method = this.getMethod()) != null) {
            ParameterValueGroup parameters;
            formatter.append(DefaultOperationMethod.castOrCopy(method));
            try {
                parameters = this.getParameterValues();
            }
            catch (UnsupportedOperationException e) {
                ParameterDescriptorGroup c = this.getParameterDescriptors();
                formatter.setInvalidWKT(c != null ? c : this, (Exception)e);
                parameters = null;
            }
            if (parameters != null) {
                formatter.newLine();
                formatter.indent(1);
                for (GeneralParameterValue param : parameters.values()) {
                    WKTUtilities.append(param, formatter);
                }
                formatter.indent(-1);
            }
        }
        if (!isSubOperation && !(this instanceof ConcatenatedOperation)) {
            AbstractCoordinateOperation.append(formatter, this.getInterpolationCRS(), "InterpolationCRS");
            final double accuracy = this.getLinearAccuracy();
            if (accuracy > 0.0) {
                formatter.append(new FormattableObject(){

                    @Override
                    protected String formatTo(Formatter formatter) {
                        formatter.append(accuracy);
                        return "OperationAccuracy";
                    }
                });
            }
        }
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        if (isComponent) {
            formatter.setInvalidWKT(this, null);
            return "CoordinateOperationStep";
        }
        return "CoordinateOperation";
    }

    private static void append(Formatter formatter, final CoordinateReferenceSystem crs, final String type) {
        if (crs != null) {
            formatter.append(new FormattableObject(){

                @Override
                protected String formatTo(Formatter formatter) {
                    formatter.indent(-1);
                    formatter.append(WKTUtilities.toFormattable(crs));
                    formatter.indent(1);
                    return type;
                }
            });
            formatter.newLine();
        }
    }

    AbstractCoordinateOperation() {
        super(NilReferencingObject.INSTANCE);
    }

    @XmlElement(name="sourceCRS")
    private CoordinateReferenceSystem getSource() {
        return this.isDefiningConversion() ? null : this.getSourceCRS();
    }

    private void setSource(CoordinateReferenceSystem crs) {
        if (this.sourceCRS == null) {
            this.sourceCRS = crs;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractCoordinateOperation.class, "setSource", "sourceCRS");
        }
    }

    @XmlElement(name="targetCRS")
    private CoordinateReferenceSystem getTarget() {
        return this.isDefiningConversion() ? null : this.getTargetCRS();
    }

    private void setTarget(CoordinateReferenceSystem crs) {
        if (this.targetCRS == null) {
            this.targetCRS = crs;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractCoordinateOperation.class, "setTarget", "targetCRS");
        }
    }

    @XmlElement(name="coordinateOperationAccuracy")
    private PositionalAccuracy[] getAccuracy() {
        Collection<PositionalAccuracy> accuracy = this.getCoordinateOperationAccuracy();
        int size = accuracy.size();
        return size != 0 ? accuracy.toArray(new PositionalAccuracy[size]) : null;
    }

    private void setAccuracy(PositionalAccuracy[] values) {
        if (this.coordinateOperationAccuracy == null) {
            this.coordinateOperationAccuracy = UnmodifiableArrayList.wrap(values);
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractCoordinateOperation.class, "setAccuracy", "coordinateOperationAccuracy");
        }
    }

    private void setOperationVersion(String value) {
        if (this.operationVersion == null) {
            this.operationVersion = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractCoordinateOperation.class, "setOperationVersion", "operationVersion");
        }
    }

    private void setDomainOfValidity(Extent value) {
        if (this.domainOfValidity == null) {
            this.domainOfValidity = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractCoordinateOperation.class, "setDomainOfValidity", "domainOfValidity");
        }
    }

    private void setScope(InternationalString value) {
        if (this.scope == null) {
            this.scope = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractCoordinateOperation.class, "setScope", "scope");
        }
    }
}

